/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx.jts;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.jbossatx.agent.LocalJBossAgentImpl;
import com.arjuna.ats.internal.jbossatx.jta.XAResourceRecoveryHelperWrapper;
import com.arjuna.ats.internal.jbossatx.jts.PropagationContextManager;
import com.arjuna.ats.internal.jbossatx.jts.PropagationContextWrapper;
import com.arjuna.ats.internal.jbossatx.jts.jca.XATerminator;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.transaction.jts.UserTransactionImple;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.recovery.RecoveryORBManager;
import com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceJMXPlugin;
import com.arjuna.ats.jbossatx.jts.TransactionManagerDelegate;
import com.arjuna.ats.jbossatx.jts.TransactionManagerServiceMBean;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.ats.jta.utils.JNDIManager;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.TransactionServer;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.RootOA;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.logging.Logger;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.LastResource;
import org.jboss.tm.XAExceptionFormatter;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TransactionManagerService
implements TransactionManagerServiceMBean,
XAResourceRecoveryRegistry {
    private final Logger log = Logger.getLogger(TransactionManagerService.class);
    private static final String SERVICE_NAME = "TransactionManagerService";
    private static final String PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextImporter";
    private static final String PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextExporter";
    private static final JBossXATerminator TERMINATOR;
    private RecoveryManager _recoveryManager;
    private boolean _runRM = true;
    private boolean alwaysPropagateContext = true;
    private boolean configured;
    private byte[] configuredLock = new byte[0];
    private boolean isTransactionStatusManagerBindAddressSet;
    private boolean isRecoveryManagerBindAddressSet;
    private MBeanServer mbeanServer;

    public String getName() {
        return SERVICE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws Exception {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            InetAddress serverInetAddress = InetAddress.getByName(System.getProperty("jboss.bind.address"));
            if (!this.isRecoveryManagerBindAddressSet) {
                this.setRecoveryInetAddress(serverInetAddress);
            }
            if (!this.isTransactionStatusManagerBindAddressSet) {
                this.setTransactionStatusManagerInetAddress(serverInetAddress);
            }
            this.configured = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.log.info((java.lang.Object)"JBossTS Transaction Service (JTS version) - JBoss Inc.");
            this.log.info((java.lang.Object)"Setting up property manager MBean and JMX layer");
            LocalJBossAgentImpl.setLocalAgent(this.getMbeanServer());
            System.setProperty("com.arjuna.ats.tsmx.agentimpl", LocalJBossAgentImpl.class.getName());
            System.setProperty("com.arjuna.ats.jta.lastResourceOptimisationInterface", LastResource.class.getName());
            String alwaysPropagateProperty = this.alwaysPropagateContext ? "YES" : "NO";
            System.setProperty("com.arjuna.ats.jts.alwaysPropagateContext", alwaysPropagateProperty);
            arjPropertyManager.propertyManager.addManagementPlugin((PropertyManagementPlugin)new PropertyServiceJMXPlugin());
            TransactionReaper.create();
            try {
                this.bindRef(PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE, PropagationContextManager.class.getName());
                this.bindRef(PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE, PropagationContextManager.class.getName());
            }
            catch (Exception e) {
                this.log.fatal((java.lang.Object)"Failed to create and register Propagation Context Manager", (Throwable)e);
            }
            this.log.info((java.lang.Object)"Binding TransactionManager JNDI Reference");
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTMImplementation", TransactionManagerDelegate.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaUTImplementation", UserTransactionImple.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTSRImplementation", TransactionSynchronizationRegistryImple.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.utils.TSRJNDIContext", "java:/TransactionSynchronizationRegistry");
            JNDIManager.bindJTATransactionManagerImplementation();
            JNDIManager.bindJTATransactionSynchronizationRegistryImplementation();
            return;
        }
    }

    public void destroy() {
        this.log.info((java.lang.Object)"Destroying TransactionManagerService");
        try {
            this.unbind(PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE);
            this.unbind(PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE);
            JNDIManager.unbindJTATransactionManagerImplementation();
            JNDIManager.unbindJTATransactionSynchronizationRegistryImplementation();
        }
        catch (NamingException e) {
            this.log.warn((java.lang.Object)"Unable to unbind TransactionManagerService JNDI entries ", (Throwable)e);
        }
    }

    public void start(ORB theCorbaORB) throws Exception {
        block6: {
            this.log.info((java.lang.Object)"Starting transaction recovery manager");
            try {
                com.arjuna.orbportability.ORB orb = com.arjuna.orbportability.ORB.getInstance((String)"jboss-atx");
                POA rootPOA = POAHelper.narrow((Object)theCorbaORB.resolve_initial_references("RootPOA"));
                orb.setOrb(theCorbaORB);
                RootOA oa = OA.getRootOA((com.arjuna.orbportability.ORB)orb);
                oa.setPOA(rootPOA);
                RecoveryORBManager.setORB((com.arjuna.orbportability.ORB)orb);
                RecoveryORBManager.setPOA((OA)oa);
                try {
                    ORBManager.setORB((com.arjuna.orbportability.ORB)orb);
                    ORBManager.setPOA((OA)oa);
                    TransactionFactory factory = OTSManager.get_factory();
                    int resolver = TransactionServer.getResolver();
                    TransactionServer.registerTransactionManager((int)resolver, (com.arjuna.orbportability.ORB)orb, (TransactionFactory)factory);
                }
                catch (Exception ex) {
                    this.log.fatal((java.lang.Object)"Problem encountered while trying to register transaction manager with ORB!");
                    throw new Exception("Problem encountered while trying to register transaction manager with ORB! " + ex);
                }
                if (this._runRM) {
                    this.log.info((java.lang.Object)"Initializing recovery manager");
                    RecoveryManager.delayRecoveryManagerThread();
                    this._recoveryManager = RecoveryManager.manager();
                    this._recoveryManager.initialize();
                    this._recoveryManager.startRecoveryManagerThread();
                    this.log.info((java.lang.Object)"Recovery manager configured and started");
                    break block6;
                }
                if (this.isRecoveryManagerRunning()) {
                    this.log.info((java.lang.Object)"Using external recovery manager");
                    break block6;
                }
                this.log.fatal((java.lang.Object)"Recovery manager not found - please refer to the JBossTS documentation for details");
                throw new Exception("Recovery manager not found - please refer to the JBossTS documentation for details");
            }
            catch (Exception e) {
                this.log.fatal((java.lang.Object)"Failed to initialize recovery manager", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRecoveryManagerRunning() throws Exception {
        boolean active = false;
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        if (pm != null) {
            BufferedReader in = null;
            PrintStream out = null;
            try {
                Socket sckt = RecoveryManager.getClientSocket();
                in = new BufferedReader(new InputStreamReader(sckt.getInputStream()));
                out = new PrintStream(sckt.getOutputStream());
                out.println("PING");
                String inMessage = in.readLine();
                active = inMessage != null ? inMessage.equals("PONG") : false;
            }
            catch (Exception ex) {
                try {
                    InetAddress host = RecoveryManager.getRecoveryManagerHost();
                    int port = RecoveryManager.getRecoveryManagerPort();
                    this.log.error((java.lang.Object)("Failed to connect to recovery manager on " + host.getHostAddress() + ':' + port));
                }
                catch (UnknownHostException e) {
                    this.log.error((java.lang.Object)"Failed to connect to recovery manager", (Throwable)ex);
                }
                active = false;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        return active;
    }

    public void stop() throws Exception {
        if (this._runRM) {
            this.log.info((java.lang.Object)"Stopping transaction recovery manager");
            this._recoveryManager.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionTimeout(int timeout) throws IllegalStateException {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                int currentTimeout = this.getTransactionTimeout();
                if (currentTimeout != timeout) {
                    throw new IllegalStateException("Cannot set transaction timeout once MBean has configured");
                }
            } else {
                jtsPropertyManager.propertyManager.setProperty("com.arjuna.ats.jts.defaultTimeout", Integer.toString(timeout));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getTransactionTimeout() {
        String timeout = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.defaultTimeout");
        if (timeout != null) {
            try {
                return Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public TransactionManager getTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return new TransactionSynchronizationRegistryImple();
    }

    public JBossXATerminator getXATerminator() {
        return TERMINATOR;
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return UserTransaction.userTransaction();
    }

    public void setPropagateFullContext(boolean propagateFullContext) {
        PropagationContextWrapper.setPropagateFullContext(propagateFullContext);
    }

    public boolean getPropagateFullContext() {
        return PropagationContextWrapper.getPropagateFullContext();
    }

    public void setStatisticsEnabled(boolean enabled) {
        System.setProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", enabled ? "YES" : "NO");
    }

    public boolean getStatisticsEnabled() {
        boolean enabled = System.getProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", "NO").equals("YES");
        return enabled;
    }

    public void registerXAExceptionFormatter(Class c, XAExceptionFormatter f) {
        this.log.warn((java.lang.Object)"XAExceptionFormatters are not supported by the JBossTS Transaction Service - this warning can safely be ignored");
    }

    public void unregisterXAExceptionFormatter(Class c) {
    }

    public long getTransactionCount() {
        return TxStats.numberOfTransactions();
    }

    public long getNestedTransactonCount() {
        return TxStats.numberOfNestedTransactions();
    }

    public long getHeuristicCount() {
        return TxStats.numberOfHeuristics();
    }

    public long getCommitCount() {
        return TxStats.numberOfCommittedTransactions();
    }

    public long getRollbackCount() {
        return TxStats.numberOfAbortedTransactions();
    }

    public long getRunningTransactionCount() {
        return TxStats.numberOfInflightTransactions();
    }

    public long getTimedoutCount() {
        return TxStats.numberOfTimedOutTransactions();
    }

    public long getApplicationRollbackCount() {
        return TxStats.numberOfApplicationRollbacks();
    }

    public long getResourceRollbackCount() {
        return TxStats.numberOfResourceRollbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunInVMRecoveryManager(boolean runRM) throws IllegalStateException {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                if (this._runRM != runRM) {
                    throw new IllegalStateException("Cannot set run in VM recovery manager once MBean has configured");
                }
            } else {
                this._runRM = runRM;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRunInVMRecoveryManager() {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._runRM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectStoreDir(String objectStoreDir) throws IllegalStateException {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                boolean equal;
                String currentDir = this.getObjectStoreDir();
                boolean bl = currentDir == null ? objectStoreDir == null : (equal = currentDir.equals(objectStoreDir));
                if (!equal) {
                    throw new IllegalStateException("Cannot set object store dir once MBean has configured");
                }
            } else {
                System.setProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir", objectStoreDir);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getObjectStoreDir() {
        return System.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMbeanServer(MBeanServer mbeanServer) {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                if (this.mbeanServer != mbeanServer) {
                    throw new IllegalStateException("Cannot set MBeanServer once MBean has configured");
                }
            } else {
                this.mbeanServer = mbeanServer;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            this.log.error((java.lang.Object)"No recovery system in which to register XAResourceRecovery instance");
            throw new IllegalStateException("No recovery system present in this server");
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            this.log.error((java.lang.Object)"No suitable recovery module in which to register XAResourceRecovery instance");
            throw new IllegalStateException("No xa recovery module present in this server");
        }
        xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }

    public void removeXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            this.log.warn((java.lang.Object)"No recovery system from which to remove XAResourceRecovery instance");
            return;
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            this.log.warn((java.lang.Object)"No suitable recovery module in which to register XAResourceRecovery instance");
            return;
        }
        xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }

    private void bindRef(String jndiName, String className) throws Exception {
        Reference ref = new Reference(className, className, null);
        new InitialContext().bind(jndiName, (java.lang.Object)ref);
    }

    private void unbind(String jndiName) throws NamingException {
        new InitialContext().unbind(jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlwaysPropagateContext(boolean alwaysPropagateContext) throws IllegalStateException {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                if (this.alwaysPropagateContext != alwaysPropagateContext) {
                    throw new IllegalStateException("Cannot set always propagate context once MBean has configured");
                }
            } else {
                this.alwaysPropagateContext = alwaysPropagateContext;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAlwaysPropagateContext() {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.alwaysPropagateContext;
        }
    }

    public InetAddress getTransactionStatusManagerInetAddress() {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        try {
            return Utility.hostNameToInetAddress((String)pm.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerAddress"), (String)"");
        }
        catch (UnknownHostException e) {
            this.log.warn((java.lang.Object)("UnknownHostException from getTransactionStatusManagerInetAddress, input was: " + pm.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerAddress")));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionStatusManagerInetAddress(InetAddress tsmInetAddress) throws IllegalStateException {
        byte[] byArray = this.configuredLock;
        synchronized (this.configuredLock) {
            if (this.configured) {
                if (!tsmInetAddress.getAddress().equals(this.getTransactionStatusManagerInetAddress().getAddress())) {
                    throw new IllegalStateException("Cannot set transactionStatusManagerInetAddress once the MBean has configured");
                }
            } else {
                PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
                pm.setProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerAddress", tsmInetAddress.getHostAddress());
                this.isTransactionStatusManagerBindAddressSet = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getTransactionStatusManagerPort() {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        return Integer.parseInt(pm.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerPort"));
    }

    public void setTransactionStatusManagerPort(int port) throws IllegalStateException {
        if (this.configured) {
            if (port != this.getTransactionStatusManagerPort()) {
                throw new IllegalStateException("Cannot set transactionStatusManagerPort once the MBean has configured");
            }
        } else {
            PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
            pm.setProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerPort", "" + port);
        }
    }

    public InetAddress getRecoveryInetAddress() {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        try {
            return Utility.hostNameToInetAddress((String)pm.getProperty("com.arjuna.ats.arjuna.recovery.recoveryAddress"), (String)"");
        }
        catch (UnknownHostException e) {
            this.log.warn((java.lang.Object)("UnknownHostException from getRecoveryInetAddress, input was: " + pm.getProperty("com.arjuna.ats.arjuna.recovery.recoveryAddress")));
            return null;
        }
    }

    public void setRecoveryInetAddress(InetAddress recoveryInetAddress) throws IllegalStateException {
        if (this.configured) {
            if (!recoveryInetAddress.getAddress().equals(this.getRecoveryInetAddress().getAddress())) {
                throw new IllegalStateException("Cannot set recoveryInetAddress once the MBean has configured");
            }
        } else {
            PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
            pm.setProperty("com.arjuna.ats.arjuna.recovery.recoveryAddress", recoveryInetAddress.getHostAddress());
            this.isRecoveryManagerBindAddressSet = true;
        }
    }

    public int getRecoveryPort() {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        return Integer.parseInt(pm.getProperty("com.arjuna.ats.arjuna.recovery.recoveryPort"));
    }

    public void setRecoveryPort(int port) throws IllegalStateException {
        if (this.configured) {
            if (port != this.getRecoveryPort()) {
                throw new IllegalStateException("Cannot set recoveryPort once the MBean has configured");
            }
        } else {
            PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
            pm.setProperty("com.arjuna.ats.arjuna.recovery.recoveryPort", "" + port);
        }
    }

    public int getSocketProcessIdPort() {
        PropertyManager pm = arjPropertyManager.getPropertyManager();
        return Integer.parseInt(pm.getProperty("com.arjuna.ats.internal.arjuna.utils.SocketProcessIdPort"));
    }

    public void setSocketProcessIdPort(int port) throws IllegalStateException {
        if (this.configured) {
            if (port != this.getSocketProcessIdPort()) {
                throw new IllegalStateException("Cannot set socketProcessIdPort once the MBean has configured");
            }
        } else {
            PropertyManager pm = arjPropertyManager.getPropertyManager();
            pm.setProperty("com.arjuna.ats.internal.arjuna.utils.SocketProcessIdPort", "" + port);
        }
    }

    static {
        arjPropertyManager.propertyManager.setProperty("com.arjuna.common.util.logger", "log4j_releveler");
        TERMINATOR = new XATerminator();
    }
}

