/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts;

import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.xa.XID;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Collections;
import java.util.Map;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.Unavailable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlWrapper
implements Reapable {
    private Control _control;
    private ControlImple _controlImpl;
    private boolean _checkedLocality;
    private Uid _theUid;

    public ControlWrapper(Control c) {
        this(c, (Uid)null);
        try {
            UidCoordinator uidCoord = Helper.getUidCoordinator(c);
            this._theUid = Helper.getUid(uidCoord);
        }
        catch (Exception e) {
            this._theUid = new Uid();
        }
    }

    public ControlWrapper(ControlImple impl) {
        this._control = null;
        this._controlImpl = impl;
        this._checkedLocality = true;
        this._theUid = impl.get_uid();
    }

    public ControlWrapper(Control c, ControlImple impl) {
        this._control = c;
        this._controlImpl = impl;
        this._checkedLocality = impl != null;
        this._theUid = impl == null ? Uid.nullUid() : impl.get_uid();
    }

    public ControlWrapper(Control c, Uid u) {
        this._control = c;
        this._controlImpl = null;
        this._checkedLocality = false;
        this._theUid = u;
    }

    @Override
    public boolean running() {
        try {
            Status status = this.get_status();
            switch (status.value()) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    @Override
    public boolean preventCommit() {
        try {
            this.rollback_only();
            return true;
        }
        catch (Exception ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.cwcommit", (Throwable)ex);
            }
            return false;
        }
    }

    @Override
    public int cancel() {
        try {
            this.rollback();
            return 4;
        }
        catch (Unavailable ex) {
            return 9;
        }
        catch (NoTransaction ex) {
            return 16;
        }
        catch (Exception ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.cwabort", (Throwable)ex);
            }
            return 9;
        }
    }

    @Override
    public Uid get_uid() {
        return this._theUid;
    }

    public ControlWrapper create_subtransaction() throws Unavailable, Inactive, SubtransactionsUnavailable, SystemException {
        Coordinator coord = null;
        try {
            coord = this._control != null ? this._control.get_coordinator() : this._controlImpl.get_coordinator();
        }
        catch (SystemException e) {
            coord = null;
        }
        if (coord != null) {
            return new ControlWrapper(coord.create_subtransaction());
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ControlWrapper::create_subtransaction - subtransaction parent is inactive.");
        }
        throw new INVALID_TRANSACTION(60005, CompletionStatus.COMPLETED_NO);
    }

    public final void commit(boolean report_heuristics) throws Unavailable, HeuristicMixed, HeuristicHazard, SystemException {
        block6: {
            try {
                if (this._controlImpl != null) {
                    this._controlImpl.getImplHandle().commit(report_heuristics);
                    break block6;
                }
                Terminator t = null;
                try {
                    t = this._control.get_terminator();
                }
                catch (SystemException e) {
                    throw new Unavailable();
                }
                if (t != null) {
                    t.commit(report_heuristics);
                    break block6;
                }
                throw new Unavailable();
            }
            catch (NullPointerException ex) {
                throw new Unavailable();
            }
        }
    }

    public final void rollback() throws Unavailable, NoTransaction, SystemException {
        block6: {
            try {
                if (this._controlImpl != null) {
                    this._controlImpl.getImplHandle().rollback();
                    break block6;
                }
                Terminator t = null;
                try {
                    t = this._control.get_terminator();
                }
                catch (SystemException e) {
                    throw new Unavailable();
                }
                if (t != null) {
                    t.rollback();
                    break block6;
                }
                throw new Unavailable();
            }
            catch (NullPointerException ex) {
                throw new Unavailable();
            }
        }
    }

    public final void rollback_only() throws Unavailable, NoTransaction, Inactive, SystemException {
        block6: {
            try {
                if (this._controlImpl != null) {
                    this._controlImpl.getImplHandle().rollback_only();
                    break block6;
                }
                Coordinator c = null;
                try {
                    c = this._control.get_coordinator();
                }
                catch (SystemException e) {
                    throw new Unavailable();
                }
                if (c != null) {
                    c.rollback_only();
                    break block6;
                }
                throw new Unavailable();
            }
            catch (NullPointerException ex) {
                throw new Unavailable();
            }
        }
    }

    public final RecoveryCoordinator register_resource(Resource r) throws Inactive, SystemException {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.getImplHandle().register_resource(r);
            }
            try {
                Coordinator coord = this._control.get_coordinator();
                return coord.register_resource(r);
            }
            catch (Unavailable e2) {
                throw new Inactive();
            }
            catch (SystemException e3) {
                throw new UNKNOWN();
            }
        }
        catch (NullPointerException e1) {
            throw new Inactive();
        }
    }

    public final void register_subtran_aware(SubtransactionAwareResource sr) throws Inactive, NotSubtransaction, SystemException {
        block6: {
            try {
                if (this._controlImpl != null) {
                    this._controlImpl.getImplHandle().register_subtran_aware(sr);
                    break block6;
                }
                try {
                    Coordinator coord = this._control.get_coordinator();
                    coord.register_subtran_aware(sr);
                }
                catch (Unavailable e2) {
                    throw new Inactive();
                }
                catch (SystemException e3) {
                    throw new UNKNOWN();
                }
            }
            catch (NullPointerException e1) {
                throw new Inactive();
            }
        }
    }

    public final void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable, SystemException {
        block6: {
            try {
                if (this._controlImpl != null) {
                    this._controlImpl.getImplHandle().register_synchronization(sync);
                    break block6;
                }
                try {
                    Coordinator coord = this._control.get_coordinator();
                    coord.register_synchronization(sync);
                }
                catch (Unavailable e2) {
                    throw new Inactive();
                }
                catch (Exception e3) {
                    throw new UNKNOWN();
                }
            }
            catch (NullPointerException e1) {
                throw new Inactive();
            }
        }
    }

    public Map<Uid, String> getSynchronizations() {
        if (this._controlImpl.getImplHandle() == null) {
            return Collections.EMPTY_MAP;
        }
        return this._controlImpl.getImplHandle().getSynchronizations();
    }

    public final Status get_status() throws SystemException {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.getImplHandle().get_status();
            }
            Coordinator c = null;
            try {
                c = this._control.get_coordinator();
            }
            catch (Unavailable e) {
                c = null;
            }
            if (c != null) {
                try {
                    return c.get_status();
                }
                catch (Exception e) {
                    return Status.StatusUnknown;
                }
            }
            return Status.StatusNoTransaction;
        }
        catch (NullPointerException ex) {
            return Status.StatusNoTransaction;
        }
    }

    public final XID get_xid(boolean branch) throws SystemException {
        if (this._controlImpl != null) {
            return Utility.getXid(this._controlImpl.get_uid(), branch);
        }
        try {
            return Utility.getXid(this._control, branch);
        }
        catch (Exception e) {
            throw new BAD_OPERATION();
        }
    }

    public final String get_transaction_name() throws SystemException {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.getImplHandle().get_transaction_name();
            }
            try {
                return this._control.get_coordinator().get_transaction_name();
            }
            catch (Unavailable e1) {
                return null;
            }
            catch (SystemException e2) {
                throw e2;
            }
        }
        catch (NullPointerException e3) {
            return null;
        }
    }

    public final Control get_control() throws Unavailable, SystemException {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.getControl();
            }
            return this._control;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public final Coordinator get_coordinator() throws SystemException, Unavailable {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.get_coordinator();
            }
            return this._control.get_coordinator();
        }
        catch (NullPointerException e) {
            throw new Unavailable();
        }
    }

    public final Terminator get_terminator() throws SystemException, Unavailable {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.get_terminator();
            }
            return this._control.get_terminator();
        }
        catch (NullPointerException e) {
            throw new Unavailable();
        }
    }

    public final int hash_transaction() throws SystemException {
        try {
            if (this._controlImpl != null) {
                return this._controlImpl.getImplHandle().hash_transaction();
            }
            Coordinator coord = this._control.get_coordinator();
            return coord.hash_transaction();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean equals(Object e) {
        if (e instanceof Uid) {
            return this._theUid.equals(e);
        }
        if (e instanceof ControlWrapper) {
            ControlWrapper c = (ControlWrapper)e;
            if (c.isLocal() && this.isLocal()) {
                return c.getImple().equals((Object)this._controlImpl);
            }
            Coordinator coord = null;
            try {
                coord = this._control.get_coordinator();
            }
            catch (Exception e1) {
                return false;
            }
            Coordinator myCoord = null;
            try {
                myCoord = this.get_coordinator();
            }
            catch (Exception e2) {
                return false;
            }
            try {
                return coord.is_same_transaction(myCoord);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        try {
            return this.get_transaction_name() + " : " + super.toString();
        }
        catch (Exception e) {
            return "Invalid";
        }
    }

    public int hashCode() {
        try {
            return this.hash_transaction();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public final Control getControl() {
        return this._control;
    }

    public final ControlImple getImple() {
        return this._controlImpl;
    }

    public final boolean isLocal() {
        return this._controlImpl != null;
    }

    public final void determineLocality() {
        if (!this._checkedLocality) {
            this._controlImpl = Helper.localControl(this._control);
            if (this._controlImpl != null && this._controlImpl.getImplHandle() == null) {
                this._theUid = this._controlImpl.get_uid();
                this._controlImpl = null;
            }
            this._checkedLocality = true;
        }
    }
}

