/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts;

import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.jts.common.Configuration;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import com.arjuna.orbportability.Services;
import org.omg.CORBA.Object;

public class TransactionServer {
    public static void main(String[] args) {
        String refFile = "TransactionManagerService";
        String objectName = null;
        boolean printReady = false;
        ORB myORB = null;
        RootOA myOA = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-otsname") == 0) {
                objectName = args[i + 1];
            }
            if (args[i].compareTo("-test") == 0) {
                printReady = true;
            }
            if (args[i].compareTo("-help") == 0) {
                System.out.println("foo Usage: [-otsname <name>] [-help] [-version]");
                System.exit(0);
            }
            if (args[i].compareTo("-version") != 0) continue;
            System.out.println("TransactionServer version " + Configuration.version());
            System.exit(0);
        }
        TransactionFactoryImple theOTS = null;
        int resolver = com.arjuna.orbportability.common.Configuration.bindDefault();
        String resolveService = jtsPropertyManager.propertyManager.getProperty("com.arjuna.orbportability.resolveService");
        if (resolveService != null) {
            if (resolveService.compareTo("NAME_SERVICE") == 0) {
                resolver = 2;
            } else if (resolveService.compareTo("BIND_CONNECT") == 0) {
                resolver = 5;
            } else if (resolveService.compareTo("FILE") == 0) {
                resolver = 3;
            } else if (resolveService.compareTo("RESOLVE_INITIAL_REFERENCES") == 0) {
                resolver = 1;
            }
        }
        try {
            try {
                myORB = ORB.getInstance("TransactionServer");
                myOA = OA.getRootOA(myORB);
                myORB.initORB(args, null);
                myOA.initOA();
                ORBManager.setORB(myORB);
                ORBManager.setPOA(myOA);
            }
            catch (Exception e) {
                System.err.println("Initialisation of TransactionServer failed: " + e);
                throw e;
            }
            theOTS = new TransactionFactoryImple(objectName);
            try {
                Services myServ = new Services(myORB);
                System.err.println("**checking " + resolver);
                if (resolver != 5) {
                    java.lang.Object[] params = new String[]{"OTS"};
                    System.err.println("**registering**");
                    myServ.registerService((Object)theOTS.getReference(), "TransactionManagerService", params, resolver);
                    params = null;
                }
                if (!printReady) {
                    System.out.println("Transaction manager registered.");
                }
            }
            catch (Exception e1) {
                System.err.println("Failed to bind transaction manager: " + e1);
                System.exit(0);
            }
            if (printReady) {
                System.out.println("Ready");
            } else {
                System.out.println("JBossTS OTS Server startup.");
            }
            if (resolver == 5) {
                myOA.run("TransactionManagerService");
            } else {
                myOA.run();
            }
        }
        catch (Exception e2) {
            System.err.println("TransactionServer caught exception " + e2);
        }
        System.out.println("JBossTS OTS Server shutdown");
        theOTS = null;
        if (myOA != null) {
            myOA.destroy();
        }
        if (myORB != null) {
            myORB.shutdown();
        }
    }
}

