/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.RecoverAtomicAction;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import java.util.Enumeration;
import java.util.Vector;

public class AtomicActionRecoveryModule
implements RecoveryModule {
    private String _transactionType = new AtomicAction().type();
    private Vector _transactionUidVector = null;
    private static ObjectStore _transactionStore = null;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    public AtomicActionRecoveryModule() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(1L, 4L, 2048L, "AtomicActionRecoveryModule created");
        }
        if (_transactionStore == null) {
            _transactionStore = TxControl.getStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
    }

    public void periodicWorkFirstPass() {
        InputObjectState aa_uids;
        boolean AtomicActions;
        block4: {
            AtomicActions = false;
            aa_uids = new InputObjectState();
            try {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug("StatusModule: first pass ");
                }
                AtomicActions = _transactionStore.allObjUids(this._transactionType, aa_uids);
            }
            catch (ObjectStoreException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_1", new Object[]{ex});
            }
        }
        if (AtomicActions) {
            this._transactionUidVector = this.processTransactions(aa_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("AtomicActionRecoveryModule: Second pass ");
        }
        this.processTransactionsStatus();
    }

    protected AtomicActionRecoveryModule(String type) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(1L, 4L, 2048L, "AtomicActionRecoveryModule created");
        }
        if (_transactionStore == null) {
            _transactionStore = TxControl.getStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        this._transactionType = type;
    }

    private void doRecoverTransaction(Uid recoverUid) {
        block4: {
            boolean commitThisTransaction = true;
            int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
            boolean inFlight = this.isTransactionInMidFlight(theStatus);
            String Status2 = ActionStatus.stringForm(theStatus);
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status2 + " in flight is " + inFlight);
            }
            if (!inFlight) {
                try {
                    RecoverAtomicAction rcvAtomicAction = new RecoverAtomicAction(recoverUid, theStatus);
                    rcvAtomicAction.replayPhase2();
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_2", new Object[]{recoverUid.toString(), ex});
                }
            }
        }
    }

    private boolean isTransactionInMidFlight(int status) {
        boolean inFlight = false;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                inFlight = true;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                inFlight = false;
                break;
            }
            default: {
                inFlight = false;
            }
        }
        return inFlight;
    }

    private Vector processTransactions(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "processing " + this._transactionType + " transactions");
        }
        Uid theUid = new Uid(Uid.nullUid());
        boolean moreUids = true;
        while (moreUids) {
            try {
                theUid.unpack(uids);
                if (theUid.equals(Uid.nullUid())) {
                    moreUids = false;
                    continue;
                }
                Uid newUid = new Uid(theUid);
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "found transaction " + newUid);
                }
                uidVector.addElement(newUid);
            }
            catch (Exception ex) {
                moreUids = false;
            }
        }
        return uidVector;
    }

    private void processTransactionsStatus() {
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_transactionStore.currentState(currentUid, this._transactionType) == 0) continue;
                this.doRecoverTransaction(currentUid);
            }
            catch (ObjectStoreException ex) {
                if (!tsLogger.arjLogger.isWarnEnabled()) continue;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_3", new Object[]{currentUid.toString(), ex});
            }
        }
    }
}

