/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.coordinator.listener.ReaperMonitor;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperWorkerThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final String PERIODIC = "PERIODIC";
    public static final long defaultCheckPeriod = 120000L;
    public static final long defaultCancelWaitPeriod = 500L;
    public static final long defaultCancelFailWaitPeriod = 500L;
    public static final int defaultZombieMax = 8;
    private SortedSet _transactions = Collections.synchronizedSortedSet(new TreeSet());
    private Map _timeouts = Collections.synchronizedMap(new HashMap());
    private final Map<Reapable, ReaperElement> _pendingInsertions = new ConcurrentHashMap<Reapable, ReaperElement>();
    private List _workQueue = new LinkedList();
    private Vector<ReaperMonitor> _listeners = new Vector();
    private long _checkPeriod = 0L;
    private long _cancelWaitPeriod = 0L;
    private long _cancelFailWaitPeriod = 0L;
    private int _zombieMax = 0;
    private static TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static ReaperWorkerThread _reaperWorkerThread = null;
    private static boolean _dynamic = true;
    private static long _lifetime = 0L;
    private static int _zombieCount = 0;
    private boolean _inShutdown = false;

    public TransactionReaper(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 1L, "TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
        }
        this._checkPeriod = checkPeriod;
        if (this._transactions == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1");
            }
            throw new OutOfMemoryError();
        }
    }

    public final long checkingPeriod() {
        if (_dynamic) {
            try {
                ReaperElement head = (ReaperElement)this._transactions.first();
                return head.getAbsoluteTimeout() - System.currentTimeMillis();
            }
            catch (NoSuchElementException nsee) {
                return Long.MAX_VALUE;
            }
        }
        try {
            long waitTime;
            ReaperElement head = (ReaperElement)this._transactions.first();
            if (head._status != 0 && (waitTime = head.getAbsoluteTimeout() - System.currentTimeMillis()) < this._checkPeriod) {
                return head.getAbsoluteTimeout() - System.currentTimeMillis();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this._checkPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean check() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::check ()");
        }
        while (true) {
            ReaperElement e;
            Object entrySet;
            Object object = this;
            synchronized (object) {
                long now;
                entrySet = this._pendingInsertions.entrySet();
                if (entrySet != null) {
                    Iterator<Map.Entry<Reapable, ReaperElement>> queueIter = entrySet.iterator();
                    while (queueIter.hasNext()) {
                        Map.Entry<Reapable, ReaperElement> entry = queueIter.next();
                        ReaperElement element = entry.getValue();
                        if (!entrySet.remove(entry)) continue;
                        this.synchronousInsert(element);
                    }
                }
                try {
                    e = (ReaperElement)this._transactions.first();
                }
                catch (NoSuchElementException nsee) {
                    return true;
                }
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[]{Long.toString(e.getAbsoluteTimeout())});
                }
                if ((now = System.currentTimeMillis()) < e.getAbsoluteTimeout()) {
                    break;
                }
            }
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_18", new Object[]{e._control.get_uid(), e.statusName()});
            }
            object = e;
            synchronized (object) {
                switch (e._status) {
                    case 0: {
                        e._status = 1;
                        entrySet = this;
                        synchronized (entrySet) {
                            this._transactions.remove(e);
                            e.setAbsoluteTimeout(System.currentTimeMillis() + this._cancelWaitPeriod);
                            this._transactions.add(e);
                        }
                        if (tsLogger.arjLogger.debugAllowed()) {
                            tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper scheduling TX for cancellation " + e._control.get_uid());
                        }
                        entrySet = this._workQueue;
                        synchronized (entrySet) {
                            this._workQueue.add(e);
                            this._workQueue.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        entrySet = this;
                        synchronized (entrySet) {
                            this._transactions.remove(e);
                            e.setAbsoluteTimeout(System.currentTimeMillis() + this._cancelWaitPeriod);
                            this._transactions.add(e);
                        }
                        if (!tsLogger.arjLogger.debugAllowed()) break;
                        tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper deferring interrupt for TX scheduled for cancel " + e._control.get_uid());
                        break;
                    }
                    case 2: {
                        e._status = 3;
                        e._worker.interrupt();
                        entrySet = this;
                        synchronized (entrySet) {
                            this._transactions.remove(e);
                            e.setAbsoluteTimeout(System.currentTimeMillis() + this._cancelFailWaitPeriod);
                            this._transactions.add(e);
                        }
                        if (!tsLogger.arjLoggerI18N.isDebugEnabled()) break;
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_4", new Object[]{e._control.get_uid()});
                        break;
                    }
                    case 3: {
                        e._status = 6;
                        entrySet = this;
                        synchronized (entrySet) {
                            ++_zombieCount;
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper " + Thread.currentThread() + " got a zombie " + e._worker + " (zombie count now " + _zombieCount + ") cancelling " + e._control.get_uid());
                            }
                            if (_zombieCount == this._zombieMax && tsLogger.arjLoggerI18N.isErrorEnabled()) {
                                tsLogger.arjLoggerI18N.error("com.arjuna.ats.arjuna.coordinator.TransactionReaper_5", new Object[]{new Integer(_zombieCount)});
                            }
                        }
                        _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
                        _reaperWorkerThread.setDaemon(true);
                        _reaperWorkerThread.start();
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{e._worker, e._control.get_uid()});
                        }
                        entrySet = this;
                        synchronized (entrySet) {
                            this.removeElement(e);
                        }
                        try {
                            if (e._control.preventCommit()) {
                                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_10", new Object[]{e._control.get_uid()});
                                }
                                this.notifyListeners(e._control, false);
                                break;
                            }
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_11", new Object[]{e._control.get_uid()});
                        }
                        catch (Exception e1) {
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_12", new Object[]{e._control.get_uid()}, e1);
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        TransactionReaper transactionReaper = this;
                        synchronized (transactionReaper) {
                            this.removeElement(e);
                            break;
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForCancellations() {
        List list2 = this._workQueue;
        synchronized (list2) {
            try {
                while (this._workQueue.isEmpty()) {
                    this._workQueue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doCancellations() {
        while (true) {
            Object object;
            ReaperElement e;
            block41: {
                List list2 = this._workQueue;
                synchronized (list2) {
                    try {
                        e = (ReaperElement)this._workQueue.remove(0);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        break;
                    }
                }
                if (tsLogger.arjLogger.debugAllowed()) {
                    tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper Worker " + Thread.currentThread() + " attempting to cancel " + e._control.get_uid());
                }
                boolean cancelled = false;
                Exception exception = null;
                object = e;
                synchronized (object) {
                    e._worker = Thread.currentThread();
                    e._status = 2;
                    e.notifyAll();
                }
                try {
                    if (e._control.running() && e._control.cancel() == 4) {
                        cancelled = true;
                        if (TxStats.enabled()) {
                            TxStats.getInstance().incrementTimeouts();
                        }
                        this.notifyListeners(e._control, true);
                    }
                }
                catch (Exception e1) {
                    exception = e1;
                }
                ReaperElement e1 = e;
                synchronized (e1) {
                    if (e._status == 6) {
                        ReaperWorkerThread worker = (ReaperWorkerThread)Thread.currentThread();
                        worker.shutdown();
                        TransactionReaper transactionReaper = this;
                        synchronized (transactionReaper) {
                            --_zombieCount;
                        }
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_13", new Object[]{Thread.currentThread(), e._control.get_uid(), new Integer(_zombieCount)});
                        }
                        break;
                    }
                    if (cancelled && e._status == 3) {
                        cancelled = false;
                        e._status = 4;
                        e.notifyAll();
                    } else {
                        e._status = cancelled ? 5 : 4;
                        e.notifyAll();
                    }
                }
                if (cancelled) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_7", new Object[]{Thread.currentThread(), e._control.get_uid()});
                    }
                } else if (e._control.running()) {
                    if (exception != null) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_9", new Object[]{Thread.currentThread(), e._control.get_uid()}, exception);
                        }
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_8", new Object[]{Thread.currentThread(), e._control.get_uid()});
                    }
                    try {
                        if (e._control.preventCommit()) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_14", new Object[]{Thread.currentThread(), e._control.get_uid()});
                            }
                            this.notifyListeners(e._control, false);
                        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_15", new Object[]{Thread.currentThread(), e._control.get_uid()});
                        }
                    }
                    catch (Exception e12) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block41;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_16", new Object[]{Thread.currentThread(), e._control.get_uid()}, e12);
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.removeElement(e);
            }
        }
    }

    public final long numberOfTransactions() {
        return this._transactions.size() + this._pendingInsertions.size();
    }

    public final long numberOfTimeouts() {
        return this._timeouts.size() + this._pendingInsertions.size();
    }

    public final void addListener(ReaperMonitor listener) {
        this._listeners.add(listener);
    }

    public final boolean removeListener(ReaperMonitor listener) {
        return this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insert(Reapable control, int timeout) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::insert ( " + control + ", " + timeout + " )");
        }
        if (timeout == 0) {
            return true;
        }
        ReaperElement e = new ReaperElement(control, timeout);
        boolean asyncInsert = false;
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            ReaperElement first;
            if (this._transactions.size() > 0 && (first = (ReaperElement)this._transactions.first()) != null && e.compareTo(first) > 0) {
                if (this._timeouts.containsKey(control)) {
                    return false;
                }
                ReaperElement old = this._pendingInsertions.put(control, e);
                if (old != null) {
                    this._pendingInsertions.put(control, old);
                    return false;
                }
                asyncInsert = true;
            }
            if (asyncInsert) {
                return true;
            }
            return this.synchronousInsert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean synchronousInsert(ReaperElement elementToInsert) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            _lifetime += (long)elementToInsert._timeout;
            ReaperElement old = this._timeouts.put(elementToInsert._control, elementToInsert);
            if (old != null) {
                this._timeouts.put(elementToInsert._control, old);
                return false;
            }
            boolean rtn = this._transactions.add(elementToInsert);
            if (_dynamic && this._transactions.first() == elementToInsert) {
                this.notifyAll();
            }
            return rtn;
        }
    }

    public final boolean remove(Object control) {
        if (this._pendingInsertions.remove(control) != null) {
            return true;
        }
        return this.synchronousRemove(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean synchronousRemove(Object control) {
        ReaperElement key;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::remove ( " + control + " )");
        }
        if (control == null) {
            return false;
        }
        Object object = this;
        synchronized (object) {
            key = (ReaperElement)this._timeouts.remove(control);
            if (key == null) {
                return false;
            }
        }
        object = key;
        synchronized (object) {
            if (key._status != 0) {
                return false;
            }
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                this.removeElement(key);
                return true;
            }
        }
    }

    public final long getRemainingTimeoutMills(Object control) {
        if (this._transactions.size() == 0 || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getRemainingTimeout for " + control + " returning 0");
            }
            return 0L;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        long timeout = 0L;
        timeout = reaperElement == null ? 0L : reaperElement.getAbsoluteTimeout() - System.currentTimeMillis();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_17", new Object[]{control, timeout});
        }
        return timeout;
    }

    public final int getTimeout(Object control) {
        if (this._transactions.size() == 0 || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getTimeout for " + control + " returning 0");
            }
            return 0;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        Integer timeout = reaperElement == null ? new Integer(0) : new Integer(reaperElement._timeout);
        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{control, timeout});
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdown(boolean waitForTransactions) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            this._inShutdown = true;
            if (!waitForTransactions) {
                for (ReaperElement e : this._transactions) {
                    e.setAbsoluteTimeout(0L);
                }
            }
            while (this._transactions.size() > 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            _reaperThread.shutdown();
            this.notifyAll();
        }
        try {
            _reaperThread.join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        _reaperThread = null;
        List ex = this._workQueue;
        synchronized (ex) {
            _reaperWorkerThread.shutdown();
            this._workQueue.notifyAll();
            _reaperWorkerThread.interrupt();
        }
        try {
            _reaperWorkerThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _reaperWorkerThread = null;
    }

    private final void removeElement(ReaperElement e) {
        this._timeouts.remove(e._control);
        this._transactions.remove(e);
        if (this._inShutdown && this._transactions.size() == 0) {
            this.notifyAll();
        }
    }

    private final void notifyListeners(Reapable element, boolean rollback) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            try {
                if (rollback) {
                    this._listeners.get(i).rolledBack(element.get_uid());
                    continue;
                }
                this._listeners.get(i).markedRollbackOnly(element.get_uid());
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    public static synchronized TransactionReaper create(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::create ( " + checkPeriod + " )");
        }
        if (_theReaper == null) {
            _dynamic = true;
            String mode = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperMode();
            if (mode.compareTo(PERIODIC) == 0) {
                _dynamic = false;
            }
            if (mode.compareTo(NORMAL) == 0) {
                _dynamic = false;
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_19");
                }
            }
            checkPeriod = !_dynamic ? arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperTimeout() : Long.MAX_VALUE;
            _theReaper = new TransactionReaper(checkPeriod);
            TransactionReaper._theReaper._cancelWaitPeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperCancelWaitPeriod();
            if (TransactionReaper._theReaper._cancelWaitPeriod < 10L) {
                TransactionReaper._theReaper._cancelWaitPeriod = 10L;
            }
            TransactionReaper._theReaper._cancelFailWaitPeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperCancelFailWaitPeriod();
            if (TransactionReaper._theReaper._cancelFailWaitPeriod < 10L) {
                TransactionReaper._theReaper._cancelFailWaitPeriod = 10L;
            }
            TransactionReaper._theReaper._zombieMax = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperZombieMax();
            if (TransactionReaper._theReaper._zombieMax <= 0) {
                TransactionReaper._theReaper._zombieMax = 1;
            }
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
            _reaperWorkerThread.setDaemon(true);
            _reaperThread.start();
            _reaperWorkerThread.start();
        }
        return _theReaper;
    }

    public static TransactionReaper create() {
        return TransactionReaper.create(120000L);
    }

    public static TransactionReaper transactionReaper() {
        return TransactionReaper.transactionReaper(false);
    }

    public static synchronized TransactionReaper transactionReaper(boolean createReaper) {
        if (createReaper) {
            return TransactionReaper.create();
        }
        return _theReaper;
    }

    public static synchronized void terminate(boolean waitForTransactions) {
        if (_theReaper != null) {
            _theReaper.shutdown(waitForTransactions);
            _theReaper = null;
        }
    }

    public static boolean isDynamic() {
        return _dynamic;
    }

    public static final synchronized long transactionLifetime() {
        return _lifetime;
    }

    static final void reset() {
        _theReaper = null;
    }
}

