/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.TxStatsMBean;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;

public class TxStats
implements TxStatsMBean {
    private static TxStats _instance = new TxStats();
    private AtomicLong numberOfTransactions = new AtomicLong(0L);
    private AtomicLong numberOfNestedTransactions = new AtomicLong(0L);
    private AtomicLong numberOfCommittedTransactions = new AtomicLong(0L);
    private AtomicLong numberOfAbortedTransactions = new AtomicLong(0L);
    private AtomicLong numberOfHeuristics = new AtomicLong(0L);
    private AtomicLong numberOfTimeouts = new AtomicLong(0L);
    private AtomicLong numberOfApplicationAborts = new AtomicLong(0L);
    private AtomicLong numberOfResourceAborts = new AtomicLong(0L);

    public static boolean enabled() {
        return arjPropertyManager.getCoordinatorEnvironmentBean().isEnableStatistics();
    }

    public static TxStats getInstance() {
        return _instance;
    }

    @Override
    public long getNumberOfTransactions() {
        return this.numberOfTransactions.longValue();
    }

    @Override
    public long getNumberOfNestedTransactions() {
        return this.numberOfNestedTransactions.longValue();
    }

    @Override
    public long getNumberOfHeuristics() {
        return this.numberOfHeuristics.get();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfAbortedTransactions() {
        return this.numberOfAbortedTransactions.get();
    }

    @Override
    public long getNumberOfInflightTransactions() {
        return ActionManager.manager().inflightTransactions().size();
    }

    @Override
    public long getNumberOfTimedOutTransactions() {
        return this.numberOfTimeouts.get();
    }

    @Override
    public long getNumberOfApplicationRollbacks() {
        return this.numberOfApplicationAborts.get();
    }

    @Override
    public long getNumberOfResourceRollbacks() {
        return this.numberOfResourceAborts.get();
    }

    public void printStatus(PrintWriter pw) {
        pw.println("JBoss Transaction Service statistics.");
        pw.println(Calendar.getInstance().getTime() + "\n");
        pw.println("Number of created transactions: " + this.getNumberOfTransactions());
        pw.println("Number of nested transactions: " + this.getNumberOfNestedTransactions());
        pw.println("Number of heuristics: " + this.getNumberOfHeuristics());
        pw.println("Number of committed transactions: " + this.getNumberOfCommittedTransactions());
        pw.println("Number of rolled back transactions: " + this.getNumberOfAbortedTransactions());
        pw.println("Number of inflight transactions: " + this.getNumberOfInflightTransactions());
        pw.println("Number of timed-out transactions: " + this.getNumberOfTimedOutTransactions());
        pw.println("Number of application rolled back transactions: " + this.getNumberOfApplicationRollbacks());
        pw.println("Number of resource rolled back transactions: " + this.getNumberOfResourceRollbacks());
    }

    void incrementTransactions() {
        this.numberOfTransactions.incrementAndGet();
    }

    void incrementNestedTransactions() {
        this.numberOfNestedTransactions.incrementAndGet();
    }

    void incrementAbortedTransactions() {
        this.numberOfAbortedTransactions.incrementAndGet();
    }

    void incrementCommittedTransactions() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    void incrementHeuristics() {
        this.numberOfHeuristics.incrementAndGet();
    }

    void incrementTimeouts() {
        this.numberOfTimeouts.incrementAndGet();
    }

    void incrementApplicationRollbacks() {
        this.numberOfApplicationAborts.incrementAndGet();
    }

    void incrementResourceRollbacks() {
        this.numberOfResourceAborts.incrementAndGet();
    }
}

