/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.io.File;
import java.io.IOException;
import java.io.SyncFailedException;

public abstract class ObjectStoreImple {
    protected int shareStatus;
    private String _objectStoreRoot = null;
    private String _objectStoreDir = null;
    private static final ClassName _className = new ClassName("ObjectStoreImple");

    public abstract int typeIs();

    public abstract boolean allObjUids(String var1, InputObjectState var2, int var3) throws ObjectStoreException;

    public abstract boolean allTypes(InputObjectState var1) throws ObjectStoreException;

    public abstract int currentState(Uid var1, String var2) throws ObjectStoreException;

    public abstract String getStoreName();

    public abstract boolean commit_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean hide_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean reveal_state(Uid var1, String var2) throws ObjectStoreException;

    public abstract InputObjectState read_committed(Uid var1, String var2) throws ObjectStoreException;

    public abstract InputObjectState read_uncommitted(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean remove_committed(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean remove_uncommitted(Uid var1, String var2) throws ObjectStoreException;

    public abstract boolean write_committed(Uid var1, String var2, OutputObjectState var3) throws ObjectStoreException;

    public abstract boolean write_uncommitted(Uid var1, String var2, OutputObjectState var3) throws ObjectStoreException;

    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public String locateStore(String localOSRoot) throws ObjectStoreException {
        if (this._objectStoreRoot == null) {
            this._objectStoreRoot = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
        }
        if (this._objectStoreDir == null) {
            this._objectStoreDir = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir();
            if (this._objectStoreDir == null || this._objectStoreDir.length() == 0) {
                throw new ObjectStoreException("com.arjuna.ats.arjuna.objectstore.objectStoreDir not set.");
            }
            if (!this._objectStoreDir.endsWith(File.separator)) {
                this._objectStoreDir = this._objectStoreDir + File.separator;
            }
            this._objectStoreDir = this._objectStoreDir + this.className().stringForm();
        }
        String toReturn = null;
        if (localOSRoot == null || localOSRoot.length() == 0) {
            localOSRoot = this._objectStoreRoot != null && this._objectStoreRoot.length() > 0 ? this._objectStoreRoot : "defaultStore" + File.separator;
        }
        if (localOSRoot != null && localOSRoot.length() > 0) {
            toReturn = this._objectStoreDir + File.separator + localOSRoot;
        }
        if (!toReturn.endsWith(File.separator)) {
            toReturn = toReturn + File.separator;
        }
        return toReturn;
    }

    public boolean fullCommitNeeded() {
        return true;
    }

    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    public void initialise(Uid u, String tn) {
    }

    public void pack(OutputBuffer buff) throws IOException {
    }

    public void unpack(InputBuffer buff) throws IOException {
    }

    public ClassName className() {
        return _className;
    }

    public final int shareState() {
        return this.shareStatus;
    }

    public final String storeDir() {
        return this._objectStoreDir;
    }

    public final String storeRoot() {
        return this._objectStoreRoot;
    }

    public static ClassName name() {
        return _className;
    }

    protected ObjectStoreImple() {
        this(14);
    }

    protected ObjectStoreImple(int ss) {
        this.shareStatus = ss;
    }

    protected ObjectStoreImple(ObjectName objName) {
        this.parseObjectName(objName);
    }

    protected abstract boolean supressEntry(String var1);

    protected String revealedId(String name) {
        return name;
    }

    private final void parseObjectName(ObjectName objName) {
        if (objName != null) {
            try {
                this._objectStoreRoot = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.localOSRoot");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this._objectStoreDir = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String shareType = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.share");
                if (shareType != null && shareType.equals("OS_SHARED")) {
                    this.shareStatus = 13;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

