/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class ExpiredTransactionStatusManagerScanner
implements ExpiryScanner {
    private String _itemTypeName;
    private ObjectStore _objectStore;
    private static int _expiryTime = 43200;
    private static SimpleDateFormat _timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    public ExpiredTransactionStatusManagerScanner() {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_1", new Object[]{Integer.toString(_expiryTime)});
        }
        this._objectStore = TransactionStatusManagerItem.getStore();
        this._itemTypeName = TransactionStatusManagerItem.typeName();
    }

    @Override
    public void scan() {
        Date oldestSurviving = new Date(new Date().getTime() - (long)(_expiryTime * 1000));
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_2", new Object[]{_timeFormat.format(oldestSurviving)});
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._objectStore.allObjUids(this._itemTypeName, uids)) {
                Uid theUid = new Uid(Uid.nullUid());
                boolean endOfUids = false;
                while (!endOfUids) {
                    theUid.unpack(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    TransactionStatusManagerItem tsmItem = TransactionStatusManagerItem.recreate(newUid);
                    if (tsmItem == null) continue;
                    Date timeOfDeath = tsmItem.getDeadTime();
                    if (timeOfDeath != null && timeOfDeath.before(oldestSurviving)) {
                        if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                            tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[]{newUid});
                        }
                        this._objectStore.remove_committed(newUid, this._itemTypeName);
                        continue;
                    }
                    Uid currentUid = newUid;
                    String process_id = this.get_process_id(currentUid);
                    TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
                    tsc.test(tsmItem);
                    if (!tsc.isDead()) continue;
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[]{newUid});
                    }
                    tsc.delete();
                    tsc = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean toBeUsed() {
        return _expiryTime != 0;
    }

    private String get_process_id(Uid uid) {
        String strUid = uid.toString();
        StringTokenizer st = new StringTokenizer(strUid, ":");
        st.nextToken();
        String process_id_in_Hex = st.nextToken();
        return process_id_in_Hex;
    }

    static {
        _expiryTime = recoveryPropertyManager.getRecoveryEnvironmentBean().getTransactionStatusManagerExpiryTime() * 60 * 60;
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_4", new Object[]{Integer.toString(_expiryTime)});
        }
    }
}

