/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.arjuna.Implementations;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader;
import java.io.IOException;
import java.util.Vector;

public class RecoveryManagerImple {
    private PeriodicRecovery _periodicRecovery;
    private RecActivatorLoader _recActivatorLoader;

    public RecoveryManagerImple(boolean threaded) {
        block9: {
            this._periodicRecovery = null;
            this._recActivatorLoader = null;
            tsLogger.arjLogger.mergeFacilityCode(262144L);
            tsLogger.arjLoggerI18N.mergeFacilityCode(262144L);
            Implementations.initialise();
            boolean useListener = recoveryPropertyManager.getRecoveryEnvironmentBean().isRecoveryListener();
            if (useListener && this.isRecoveryManagerEndPointInUse()) {
                if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                    try {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.recovery.fail", new Object[]{RecoveryManager.getRecoveryManagerHost(), RecoveryManager.getRecoveryManagerPort()});
                    }
                    catch (Throwable t) {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.recovery.fail", new Object[]{"unknown", "unknown"});
                    }
                }
                throw new FatalError("Recovery manager already active (or recovery port and address are in use)!");
            }
            this._recActivatorLoader = new RecActivatorLoader();
            ExpiredEntryMonitor.startUp();
            this._periodicRecovery = new PeriodicRecovery(threaded, useListener);
            try {
                if (tsLogger.arjLogger.isInfoEnabled()) {
                    if (useListener) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.socketready", new Object[]{this._periodicRecovery.getServerSocket().getLocalPort()});
                    } else {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.localready");
                    }
                }
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block9;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_2", new Object[]{ex});
            }
        }
    }

    public final void scan() {
        this._periodicRecovery.doWork();
    }

    public final void addModule(RecoveryModule module) {
        this._periodicRecovery.addModule(module);
    }

    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        this._periodicRecovery.removeModule(module, waitOnScan);
    }

    public final void removeAllModules(boolean waitOnScan) {
        this._periodicRecovery.removeAllModules(waitOnScan);
    }

    public final Vector getModules() {
        return this._periodicRecovery.getModules();
    }

    public void start() {
        if (!this._periodicRecovery.isAlive()) {
            this._periodicRecovery.start();
        }
    }

    public void stop(boolean async) {
        ExpiredEntryMonitor.shutdown();
        this._periodicRecovery.shutdown(async);
    }

    public void suspendScan(boolean async) {
        this._periodicRecovery.suspendScan(async);
    }

    public void resumeScan() {
        this._periodicRecovery.resumeScan();
    }

    public void waitForTermination() {
        try {
            this._periodicRecovery.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean isRecoveryManagerEndPointInUse() {
        if (this._periodicRecovery != null) {
            return this._periodicRecovery.getMode() != PeriodicRecovery.Mode.TERMINATED;
        }
        return false;
    }
}

