/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.TransactionManager;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class ConnectionManager {
    private static Set<ConnectionImple> _connections = new HashSet<ConnectionImple>();

    public static synchronized Connection create(String dbUrl, Properties info) throws SQLException {
        ConnectionImple conn2;
        String user = info.getProperty("user");
        String passwd = info.getProperty("password");
        String dynamic = info.getProperty("DYNAMIC_CLASS");
        if (dynamic == null) {
            dynamic = "";
        }
        for (ConnectionImple conn2 : _connections) {
            ConnectionControl connControl = conn2.connectionControl();
            javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
            Transaction tx2 = null;
            Transaction tx1 = connControl.transaction();
            try {
                tx2 = tm.getTransaction();
            }
            catch (SystemException se) {
                // empty catch block
            }
            if (tx1 == null || !tx1.equals(tx2) || !connControl.url().equals(dbUrl) || !connControl.user().equals(user) || !connControl.password().equals(passwd) || !connControl.dynamicClass().equals(dynamic)) continue;
            try {
                if (conn2.isClosed()) continue;
                return (Connection)((Object)conn2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SQLException sqlException = new SQLException(ex.getMessage());
                sqlException.initCause(ex);
                throw sqlException;
            }
        }
        String connectionImpleClassName = "com.arjuna.ats.internal.jdbc.ConnectionImpleJDBC4";
        try {
            Class<?> clazz = Class.forName(connectionImpleClassName);
            Constructor<?> ctor = clazz.getConstructor(String.class, Properties.class);
            conn2 = (ConnectionImple)ctor.newInstance(dbUrl, info);
        }
        catch (Exception exception) {
            connectionImpleClassName = "com.arjuna.ats.internal.jdbc.ConnectionImpleJDBC3";
            try {
                Class<?> clazz = Class.forName(connectionImpleClassName);
                Constructor<?> ctor = clazz.getConstructor(String.class, Properties.class);
                conn2 = (ConnectionImple)ctor.newInstance(dbUrl, info);
            }
            catch (Exception e) {
                if (jdbcLogger.logger.isErrorEnabled()) {
                    jdbcLogger.logger.error(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.nojdbcimple") + " " + e.toString());
                }
                SQLException sqlException = new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.nojdbcimple") + " " + e.toString());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        _connections.add(conn2);
        return (Connection)((Object)conn2);
    }

    public static synchronized void remove(ConnectionImple conn) {
        _connections.remove(conn);
    }
}

