/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.jts.orbspecific;

import com.arjuna.ArjunaOTS.OTSAbstractRecord;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.XAResourceRecord;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;

public class LastResourceRecord
extends XAResourceRecord {
    private static final String UID = Uid.lastResourceUid().stringForm();
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES;
    private static boolean _disableMLRWarning;
    private static boolean _issuedWarning;

    public LastResourceRecord(TransactionImple tx2, XAResource xaResource, Xid xid, Object[] params) {
        super(tx2, xaResource, xid, params);
    }

    @Override
    public int type_id() throws SystemException {
        return Integer.MAX_VALUE;
    }

    @Override
    public String uid() throws SystemException {
        return UID;
    }

    @Override
    public void commit() throws SystemException, NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
    }

    @Override
    public Vote prepare() throws HeuristicMixed, HeuristicHazard, SystemException {
        try {
            this.commit_one_phase();
            return Vote.VoteCommit;
        }
        catch (TRANSACTION_ROLLEDBACK tr) {
            return Vote.VoteRollback;
        }
    }

    @Override
    public String type() {
        return "/CosTransactions/LastXAResourceRecord";
    }

    @Override
    public boolean saveRecord() throws SystemException {
        return false;
    }

    @Override
    public boolean shouldAdd(OTSAbstractRecord record) throws SystemException {
        if (record.type_id() == this.type_id()) {
            if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                if (jtaLogger.loggerI18N.isWarnEnabled() && (!_disableMLRWarning || _disableMLRWarning && !_issuedWarning)) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.jts.orbspecific.lastResource.multipleWarning", new Object[]{record});
                    _issuedWarning = true;
                }
                return true;
            }
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.jts.orbspecific.lastResource.disallow", new Object[]{record});
            }
            return false;
        }
        return true;
    }

    static {
        _disableMLRWarning = false;
        _issuedWarning = false;
        ALLOW_MULTIPLE_LAST_RESOURCES = arjPropertyManager.getCoreEnvironmentBean().isAllowMultipleLastResources();
        if (ALLOW_MULTIPLE_LAST_RESOURCES && jtaLogger.loggerI18N.isWarnEnabled()) {
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.jts.orbspecific.lastResource.startupWarning");
        }
        if (arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning()) {
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.jts.orbspecific.lastResource.disableWarning");
            _disableMLRWarning = true;
        }
    }
}

