/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.util.logging.LogNoi18n;

public class LogNoi18nImpl
implements LogNoi18n {
    private LogInterface m_logInterface = null;
    protected String m_resourceBundle = "no resource bundle set";
    protected String[] m_extraResBundles = null;
    private long m_debugLevel = 0L;
    private long m_visLevel = -1L;
    private long m_facLevel = -1L;

    public LogNoi18nImpl(LogInterface logInterface) {
        this.m_logInterface = logInterface;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_logInterface.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_logInterface.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_logInterface.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_logInterface.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_logInterface.isFatalEnabled();
    }

    @Override
    public void setLevels(long dl, long vl, long fl) {
        this.m_debugLevel = dl;
        this.m_visLevel = vl;
        this.m_facLevel = fl;
    }

    @Override
    public long getDebugLevel() {
        return this.m_debugLevel;
    }

    @Override
    public void setDebugLevel(long level) {
        this.m_debugLevel = level;
    }

    @Override
    public void mergeDebugLevel(long level) {
        this.m_debugLevel |= level;
    }

    @Override
    public long getVisibilityLevel() {
        return this.m_visLevel;
    }

    @Override
    public void setVisibilityLevel(long level) {
        this.m_visLevel = level;
    }

    @Override
    public void mergeVisibilityLevel(long level) {
        this.m_visLevel |= level;
    }

    @Override
    public long getFacilityCode() {
        return this.m_facLevel;
    }

    @Override
    public void setFacilityCode(long level) {
        this.m_facLevel = level;
    }

    @Override
    public void mergeFacilityCode(long level) {
        this.m_facLevel |= level;
    }

    @Override
    public boolean debugAllowed() {
        return this.debugAllowed(-1L, -1L, -1L);
    }

    @Override
    public boolean debugAllowed(long dLevel) {
        return this.debugAllowed(dLevel, -1L, -1L);
    }

    @Override
    public boolean debugAllowed(long dLevel, long vLevel) {
        return this.debugAllowed(dLevel, vLevel, -1L);
    }

    @Override
    public boolean debugAllowed(long dLevel, long vLevel, long fLevel) {
        return (dLevel & this.m_debugLevel) != 0L && (vLevel & this.m_visLevel) != 0L && (fLevel & this.m_facLevel) != 0L && this.isDebugEnabled();
    }

    @Override
    public void debug(long dl, long vl, long fl, Object message) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(message);
        }
    }

    @Override
    public void debug(long dl, long vl, long fl, String message) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(message);
        }
    }

    @Override
    public void debug(Object message) {
        this.m_logInterface.debug(message);
    }

    @Override
    public void debug(String message) {
        this.m_logInterface.debug(message);
    }

    @Override
    public void info(Object message) {
        this.m_logInterface.info(message);
    }

    @Override
    public void info(String message) {
        this.m_logInterface.info(message);
    }

    @Override
    public void warn(Object message) {
        this.m_logInterface.warn(message);
    }

    @Override
    public void warn(String message) {
        this.m_logInterface.warn(message);
    }

    @Override
    public void error(Object message) {
        this.m_logInterface.error(message);
    }

    @Override
    public void error(String message) {
        this.m_logInterface.error(message);
    }

    @Override
    public void fatal(Object message) {
        this.m_logInterface.fatal(message);
    }

    @Override
    public void fatal(String message) {
        this.m_logInterface.fatal(message);
    }
}

