/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.lockstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;
import com.arjuna.ats.txoj.common.txojPropertyManager;
import com.arjuna.ats.txoj.exceptions.LockStoreException;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;

public class BasicPersistentLockStore
extends LockStore {
    private String _key;
    private ObjectStore _lockStore;
    private static String lockStoreLocation = null;

    public BasicPersistentLockStore(String key) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 65536L, "BasicPersistentLockStore.BasicPersistentLockStore(" + key + ")");
        }
        lockStoreLocation = txojPropertyManager.getTxojEnvironmentBean().getLockStoreDir();
        this._key = txojPropertyManager.getTxojEnvironmentBean().getLockStoreDir();
        this._lockStore = new ShadowingStore(this._key);
    }

    @Override
    public InputObjectState read_state(Uid u, String tName) throws LockStoreException {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.read_state(" + u + ", " + tName + ")");
        }
        try {
            return this._lockStore.read_committed(u, tName);
        }
        catch (ObjectStoreException e) {
            throw new LockStoreException("Persistent store error.", e);
        }
    }

    @Override
    public boolean remove_state(Uid u, String tName) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.remove_state(" + u + ", " + tName + ")");
        }
        try {
            return this._lockStore.remove_committed(u, tName);
        }
        catch (ObjectStoreException e) {
            return false;
        }
    }

    @Override
    public boolean write_committed(Uid u, String tName, OutputObjectState state) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.write_committed(" + u + ", " + tName + ", " + state + ")");
        }
        try {
            return this._lockStore.write_committed(u, tName, state);
        }
        catch (ObjectStoreException e) {
            return false;
        }
    }
}

