/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.semaphore;

import com.arjuna.ats.txoj.logging.txojLogger;
import com.arjuna.ats.txoj.semaphore.Semaphore;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class BasicSemaphore
extends Semaphore {
    private Thread owner = null;
    private int useCount = 0;
    private Hashtable waiters = new Hashtable();
    private int numberOfResources = 1;
    private String semKey;
    private static final Map<String, BasicSemaphore> semaphores = new HashMap<String, BasicSemaphore>();

    public BasicSemaphore(String key) {
        this.semKey = key;
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 128L, "BasicSemapore::BasicSemaphore ( " + key + " )");
        }
    }

    public void finalize() {
        if (this.waiters.size() != 0 && txojLogger.aitLoggerI18N.isWarnEnabled()) {
            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.semaphore.BasicSemaphore_1");
        }
        this.owner = null;
        this.waiters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lock() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::lock()");
        }
        BasicSemaphore basicSemaphore = this;
        synchronized (basicSemaphore) {
            Thread t = Thread.currentThread();
            if (this.owner == null) {
                this.owner = t;
            } else if (this.owner != t) {
                this.waiters.put(t, t);
                while (this.owner != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.waiters.remove(t);
                this.owner = t;
            }
            ++this.useCount;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::unlock()");
        }
        BasicSemaphore basicSemaphore = this;
        synchronized (basicSemaphore) {
            Thread t = Thread.currentThread();
            if (this.owner != t) {
                return 3;
            }
            if (--this.useCount == 0) {
                this.owner = null;
                if (this.waiters.size() > 0) {
                    this.notify();
                }
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tryLock() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::tryLock()");
        }
        BasicSemaphore basicSemaphore = this;
        synchronized (basicSemaphore) {
            if (this.owner == null || this.owner == Thread.currentThread()) {
                return this.lock();
            }
            return 2;
        }
    }
}

