/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBArchiveMetaDataAdapterEJB21 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB21.class);

    public EJBArchiveMetaData buildUnifiedApplicationMetaData(Deployment dep, DeploymentUnit unit) {
        ApplicationMetaData appMetaData = (ApplicationMetaData)unit.getAttachment(ApplicationMetaData.class);
        dep.addAttachment(ApplicationMetaData.class, (Object)appMetaData);
        EJBArchiveMetaData umd = new EJBArchiveMetaData();
        this.buildUnifiedBeanMetaData(umd, appMetaData);
        this.buildWebservicesMetaData(umd, appMetaData);
        umd.setSecurityDomain(appMetaData.getSecurityDomain());
        return umd;
    }

    private void buildWebservicesMetaData(EJBArchiveMetaData umd, ApplicationMetaData apmd) {
        ApplicationMetaData.Webservices webservices = apmd.getWebservices();
        if (webservices != null) {
            String contextRoot = webservices.getContextRoot();
            umd.setPublishLocationAdapter(this.getPublishLocationAdpater(webservices));
            List wsDescriptions = webservices.getWebserviceDescriptions();
            if (wsDescriptions.size() > 1) {
                log.warn((Object)"Multiple <webservice-description> elements not supported");
            }
            if (wsDescriptions.size() > 0) {
                ApplicationMetaData.WebserviceDescription wsd = (ApplicationMetaData.WebserviceDescription)wsDescriptions.get(0);
                umd.setConfigName(wsd.getConfigName());
                umd.setConfigFile(wsd.getConfigFile());
            }
            umd.setWebServiceContextRoot(contextRoot);
        }
    }

    private EJBArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final ApplicationMetaData.Webservices webservices) {
        return new EJBArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                String wsdlPublishLocation = null;
                for (ApplicationMetaData.WebserviceDescription wsd : webservices.getWebserviceDescriptions()) {
                    if (!wsd.getDescriptionName().equals(name)) continue;
                    wsdlPublishLocation = wsd.getWsdlPublishLocation();
                }
                return wsdlPublishLocation;
            }
        };
    }

    private void buildUnifiedBeanMetaData(EJBArchiveMetaData umd, ApplicationMetaData appMetaData) {
        ArrayList<EJBMetaData> beans = new ArrayList<EJBMetaData>();
        Iterator it = appMetaData.getEnterpriseBeans();
        while (it.hasNext()) {
            BeanMetaData bmd = (BeanMetaData)it.next();
            this.buildUnifiedBeanMetaData(beans, bmd);
        }
        umd.setEnterpriseBeans(beans);
    }

    private EJBMetaData buildUnifiedBeanMetaData(List<EJBMetaData> beans, BeanMetaData bmd) {
        SLSBMetaData ubmd = null;
        if (bmd instanceof SessionMetaData) {
            ubmd = new SLSBMetaData();
        } else if (bmd instanceof MessageDrivenMetaData) {
            ubmd = new MDBMetaData();
            ((MDBMetaData)ubmd).setDestinationJndiName(((MessageDrivenMetaData)bmd).getDestinationJndiName());
        }
        if (ubmd != null) {
            ubmd.setEjbName(bmd.getEjbName());
            ubmd.setEjbClass(bmd.getEjbClass());
            ubmd.setServiceEndpointInterface(bmd.getServiceEndpoint());
            ubmd.setHome(bmd.getHome());
            ubmd.setLocalHome(bmd.getLocalHome());
            ubmd.setJndiName(bmd.getJndiName());
            ubmd.setLocalJndiName(bmd.getLocalJndiName());
            EjbPortComponentMetaData pcmd = bmd.getPortComponent();
            if (pcmd != null) {
                ubmd.setPortComponentName(pcmd.getPortComponentName());
                ubmd.setPortComponentURI(pcmd.getPortComponentURI());
                EJBSecurityMetaData smd = new EJBSecurityMetaData();
                smd.setAuthMethod(pcmd.getAuthMethod());
                smd.setTransportGuarantee(pcmd.getTransportGuarantee());
                smd.setSecureWSDLAccess(pcmd.getSecureWSDLAccess());
                ubmd.setSecurityMetaData(smd);
            }
            beans.add((EJBMetaData)ubmd);
        }
        return ubmd;
    }
}

