/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.metamodel.Ejb3PortComponent;
import org.jboss.ejb3.metamodel.EjbJarDD;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.metamodel.WebserviceDescription;
import org.jboss.ejb3.metamodel.Webservices;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

public class EJBArchiveMetaDataAdapterEJB3 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB3.class);

    public EJBArchiveMetaData buildUnifiedApplicationMetaData(Deployment dep, DeploymentUnit unit) {
        Ejb3Deployment ejb3Deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        dep.addAttachment(Ejb3Deployment.class, (Object)ejb3Deployment);
        EjbJarDD jarDD = (EjbJarDD)unit.getAttachment(EjbJarDD.class);
        EJBArchiveMetaData umd = new EJBArchiveMetaData();
        this.buildUnifiedBeanMetaData(umd, ejb3Deployment);
        this.buildWebservicesMetaData(umd, jarDD);
        return umd;
    }

    private void buildWebservicesMetaData(EJBArchiveMetaData umd, EjbJarDD jarDD) {
        if (jarDD == null) {
            return;
        }
        Webservices webservices = jarDD.getWebservices();
        if (webservices != null) {
            String contextRoot = webservices.getContextRoot();
            umd.setPublishLocationAdapter(this.getPublishLocationAdpater(webservices));
            List wsDescriptions = webservices.getWebserviceDescriptions();
            if (wsDescriptions.size() > 1) {
                log.warn((Object)"Multiple <webservice-description> elements not supported");
            }
            if (wsDescriptions.size() > 0) {
                WebserviceDescription wsd = (WebserviceDescription)wsDescriptions.get(0);
                umd.setConfigName(wsd.getConfigName());
                umd.setConfigFile(wsd.getConfigFile());
                if (contextRoot == null) {
                    contextRoot = "/" + wsd.getDescriptionName();
                }
            }
            umd.setWebServiceContextRoot(contextRoot);
        }
    }

    private void buildUnifiedBeanMetaData(EJBArchiveMetaData umd, Ejb3Deployment ejb3Deployment) {
        ArrayList<SLSBMetaData> ubmdList = new ArrayList<SLSBMetaData>();
        for (EJBContainer container : ejb3Deployment.getEjbContainers().values()) {
            Ejb3PortComponent pcmd;
            SLSBMetaData ubmd = null;
            if (container instanceof SessionContainer) {
                ubmd = new SLSBMetaData();
            } else if (container instanceof MessagingContainer) {
                ubmd = new MDBMetaData();
                log.warn((Object)"No implemented: initialize MDB destination");
            }
            if (ubmd == null) continue;
            ubmd.setEjbName(container.getEjbName());
            ubmd.setEjbClass(container.getBeanClassName());
            EnterpriseBean bean = container.getXml();
            Ejb3PortComponent ejb3PortComponent = pcmd = bean != null ? bean.getPortComponent() : null;
            if (pcmd != null) {
                ubmd.setPortComponentName(pcmd.getPortComponentName());
                ubmd.setPortComponentURI(pcmd.getPortComponentURI());
                EJBSecurityMetaData smd = new EJBSecurityMetaData();
                smd.setAuthMethod(pcmd.getAuthMethod());
                smd.setTransportGuarantee(pcmd.getTransportGuarantee());
                smd.setSecureWSDLAccess(pcmd.getSecureWSDLAccess());
                ubmd.setSecurityMetaData(smd);
            }
            ubmdList.add(ubmd);
        }
        umd.setEnterpriseBeans(ubmdList);
    }

    private EJBArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final Webservices webservices) {
        return new EJBArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                String wsdlPublishLocation = null;
                for (WebserviceDescription wsd : webservices.getWebserviceDescriptions()) {
                    if (!wsd.getDescriptionName().equals(name)) continue;
                    wsdlPublishLocation = wsd.getWsdlPublishLocation();
                }
                return wsdlPublishLocation;
            }
        };
    }
}

