/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.wsf.container.jboss50.AbstractDeployerHookEJB;
import org.jboss.wsf.container.jboss50.VirtualFileAdaptor;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class JAXRPCDeployerHookEJB21
extends AbstractDeployerHookEJB {
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXRPC_EJB21;
    }

    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setRuntimeClassLoader(unit.getClassLoader());
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        ApplicationMetaData appmd = (ApplicationMetaData)unit.getAttachment(ApplicationMetaData.class);
        if (appmd == null) {
            throw new IllegalStateException("Deployment unit does not contain application meta data");
        }
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(unit);
        if (wsMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain webservices meta data");
        }
        dep.addAttachment(WebservicesMetaData.class, (Object)wsMetaData);
        dep.addAttachment(ApplicationMetaData.class, (Object)appmd);
        for (WebserviceDescriptionMetaData wsd : wsMetaData.getWebserviceDescriptions()) {
            for (PortComponentMetaData pcmd : wsd.getPortComponents()) {
                String ejbLink = pcmd.getEjbLink();
                if (ejbLink == null) {
                    throw new IllegalStateException("ejb-link cannot be null");
                }
                BeanMetaData beanMetaData = appmd.getBeanByEjbName(ejbLink);
                if (beanMetaData == null) {
                    throw new IllegalStateException("Cannot obtain bean meta data for: " + ejbLink);
                }
                String ejbClass = beanMetaData.getEjbClass();
                Endpoint ep = this.newEndpoint(ejbClass);
                ep.setShortName(ejbLink);
                service.addEndpoint(ep);
            }
        }
        return dep;
    }

    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(unit);
        return wsMetaData != null && unit.getAllMetaData(ApplicationMetaData.class).size() > 0;
    }
}

