/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.web.Servlet;
import org.jboss.wsf.container.jboss50.AbstractDeployerHookJSE;
import org.jboss.wsf.container.jboss50.VirtualFileAdaptor;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDeployerHookJSE
extends AbstractDeployerHookJSE {
    @Override
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_JSE;
    }

    @Override
    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain web meta data");
        }
        dep.addAttachment(WebMetaData.class, (Object)webMetaData);
        List<Servlet> servlets = this.getRelevantServlets(webMetaData, unit.getClassLoader());
        for (Servlet servlet : servlets) {
            String servletName = servlet.getName();
            String servletClass = servlet.getServletClass();
            Endpoint ep = this.newEndpoint(servletClass);
            ep.setShortName(servletName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    @Override
    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        if (!super.isWebServiceDeployment(unit)) {
            return false;
        }
        boolean isWebServiceDeployment = false;
        try {
            WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
            List<Servlet> servlets = this.getRelevantServlets(webMetaData, unit.getClassLoader());
            isWebServiceDeployment = servlets.size() > 0;
        }
        catch (Exception ex) {
            this.log.error((Object)"Cannot process web deployment", (Throwable)ex);
        }
        return isWebServiceDeployment;
    }

    private List<Servlet> getRelevantServlets(WebMetaData webMetaData, ClassLoader loader) {
        ArrayList<Servlet> servlets = new ArrayList<Servlet>();
        for (Servlet servlet : webMetaData.getServlets()) {
            String servletClassName = servlet.getServletClass();
            if (servletClassName == null || servletClassName.length() == 0) continue;
            try {
                Class<?> servletClass = loader.loadClass(servletClassName.trim());
                boolean isWebService = servletClass.isAnnotationPresent(WebService.class);
                boolean isWebServiceProvider = servletClass.isAnnotationPresent(WebServiceProvider.class);
                if (!isWebService && !isWebServiceProvider) continue;
                servlets.add(servlet);
            }
            catch (ClassNotFoundException ex) {
                this.log.warn((Object)("Cannot load servlet class: " + servletClassName));
            }
        }
        return servlets;
    }
}

