/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServer;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebAppDeployingHttpServer
extends AbstractExtensible
implements HttpServer {
    private DeployerClient mainDeployer;
    private Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void start() {
    }

    public HttpContext createContext(String contextRoot) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        HttpContext httpContext = ((HttpContextFactory)spiProvider.getSPI(HttpContextFactory.class)).newHttpContext((HttpServer)this, contextRoot);
        return httpContext;
    }

    public void publish(HttpContext context, Endpoint endpoint) {
        Class implClass = this.getImplementorClass(endpoint);
        String implName = implClass.getName();
        try {
            Element webDoc = this.createWebAppDescriptor(context, endpoint);
            Element jbossDoc = this.createJBossWebAppDescriptor(context, endpoint);
            File tmpWar = null;
            try {
                SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
                File tmpDir = new File(serverConfig.getServerTempDir().getCanonicalPath() + "/jbossws");
                tmpDir.mkdirs();
                String deploymentName = implName.substring(implName.lastIndexOf(".") + 1);
                tmpWar = File.createTempFile(deploymentName, ".war", tmpDir);
                tmpWar.delete();
                File webInf = new File(tmpWar, "WEB-INF");
                webInf.mkdirs();
                File webXml = new File(webInf, "web.xml");
                FileWriter fw = new FileWriter(webXml);
                new DOMWriter((Writer)fw).setPrettyprint(true).print((Node)webDoc);
                fw.close();
                File jbossWebXml = new File(webInf, "jboss-web.xml");
                fw = new FileWriter(jbossWebXml);
                new DOMWriter((Writer)fw).setPrettyprint(true).print((Node)jbossDoc);
                fw.close();
            }
            catch (IOException e) {
                throw new WebServiceException("Failed to create webservice war", (Throwable)e);
            }
            Map epProps = endpoint.getProperties();
            epProps.put("jbossws-endpoint-war-url", tmpWar);
            URL tmpURL = tmpWar.toURL();
            Deployment deployment = this.createDeploymentContext(tmpURL);
            this.mainDeployer.deploy(deployment);
            this.deploymentMap.put(tmpURL.toExternalForm(), deployment);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    public void destroy(HttpContext context, Endpoint endpoint) {
        Map epProps = endpoint.getProperties();
        File tmpWar = (File)epProps.get("jbossws-endpoint-war-url");
        if (tmpWar == null) {
            throw new IllegalStateException("Cannot find endpoint war property");
        }
        try {
            URL tmpURL = tmpWar.toURL();
            Deployment deployment = this.deploymentMap.get(tmpURL.toExternalForm());
            if (deployment != null) {
                this.mainDeployer.undeploy(deployment);
                this.deploymentMap.remove(tmpURL.toExternalForm());
            }
            tmpWar.delete();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private Class getImplementorClass(Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        Class<?> implClass = implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
        return implClass;
    }

    private Element createWebAppDescriptor(HttpContext context, Endpoint endpoint) {
        Class implClass = this.getImplementorClass(endpoint);
        String implName = implClass.getName();
        Element webApp = DOMUtils.createElement((String)"web-app");
        Element servlet = (Element)webApp.appendChild(DOMUtils.createElement((String)"servlet"));
        Element servletName = (Element)servlet.appendChild(DOMUtils.createElement((String)"servlet-name"));
        servletName.appendChild(DOMUtils.createTextNode((String)"JAXWSEndpoint"));
        Element servletClass = (Element)servlet.appendChild(DOMUtils.createElement((String)"servlet-class"));
        servletClass.appendChild(DOMUtils.createTextNode((String)implName));
        Element servletMapping = (Element)webApp.appendChild(DOMUtils.createElement((String)"servlet-mapping"));
        servletName = (Element)servletMapping.appendChild(DOMUtils.createElement((String)"servlet-name"));
        servletName.appendChild(DOMUtils.createTextNode((String)"JAXWSEndpoint"));
        Element urlPatternElement = (Element)servletMapping.appendChild(DOMUtils.createElement((String)"url-pattern"));
        String urlPattern = "/*";
        urlPatternElement.appendChild(DOMUtils.createTextNode((String)urlPattern));
        return webApp;
    }

    private Element createJBossWebAppDescriptor(HttpContext context, Endpoint endpoint) {
        Element jbossWeb = DOMUtils.createElement((String)"jboss-web");
        String contextRoot = context.getContextRoot();
        if (contextRoot == null) {
            throw new WebServiceException("Cannot obtain context root");
        }
        Element root = (Element)jbossWeb.appendChild(DOMUtils.createElement((String)"context-root"));
        root.appendChild(DOMUtils.createTextNode((String)contextRoot));
        return jbossWeb;
    }

    private Deployment createDeploymentContext(URL warURL) throws Exception {
        VirtualFile file = VFS.getRoot((URL)warURL);
        return VFSDeploymentFactory.getInstance().createVFSDeployment(file);
    }
}

