/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.SchemaMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.metadata.XsdAnnotation;
import org.jboss.xb.binding.metadata.XsdAppInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;

public class XsdBinder {
    static final Logger log = Logger.getLogger(XsdBinder.class);

    private XsdBinder() {
    }

    public static SchemaBinding bind(String xsdUrl) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(xsdUrl);
        return XsdBinder.bind(xsdUrl, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(String xsdUrl, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdUrl, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding) {
        return XsdBinder.bind(xsdStream, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI) {
        return XsdBinder.bind(xsdStream, encoding, baseURI, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI, boolean processAnnotations) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdStream, encoding, resolver, processAnnotations);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver) {
        return XsdBinder.bind(xsdStream, encoding, resolver, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver, boolean processAnnotations) {
        XSModel model = Util.loadSchema(xsdStream, encoding, resolver);
        return XsdBinder.bind(model, resolver, processAnnotations);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding) {
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, String baseURI) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdReader, encoding, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(String xsd, String encoding) {
        return XsdBinder.bind(xsd, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(String xsd, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsd, encoding);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver) {
        return XsdBinder.bind(model, resolver, true);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver, boolean processAnnotations) {
        Context ctx = new Context();
        ctx.processAnnotations = processAnnotations;
        SchemaBinding schema = ctx.schema;
        schema.setSchemaResolver(resolver);
        if (ctx.processAnnotations) {
            XSObjectList annotations = model.getAnnotations();
            if (ctx.trace) {
                log.trace((Object)("started binding schema " + schema));
                log.trace((Object)("Schema annotations: " + annotations.getLength()));
            }
            int i = 0;
            while (i < annotations.getLength()) {
                SchemaMetaData schemaBindings;
                XSAnnotation annotation = (XSAnnotation)annotations.item(i);
                XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
                XsdAppInfo appinfo = an.getAppInfo();
                if (appinfo != null && (schemaBindings = appinfo.getSchemaMetaData()) != null) {
                    schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
                    schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
                    PackageMetaData packageMetaData = schemaBindings.getPackage();
                    if (packageMetaData != null) {
                        if (ctx.trace) {
                            log.trace((Object)("schema default package: " + packageMetaData.getName()));
                        }
                        schema.setPackageMetaData(packageMetaData);
                    }
                }
                ++i;
            }
        }
        StringList namespaceList = model.getNamespaces();
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>(namespaceList.getLength());
        int i = 0;
        while (i < namespaceList.getLength()) {
            namespaces.add(namespaceList.item(i));
            ++i;
        }
        schema.setNamespaces(namespaces);
        XSNamedMap groups = model.getComponents((short)6);
        if (ctx.trace) {
            log.trace((Object)("Model groups: " + groups.getLength()));
        }
        int i2 = 0;
        while (i2 < groups.getLength()) {
            XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i2);
            XsdBinder.bindGlobalGroup(groupDef.getModelGroup(), ctx.sharedElements);
            ++i2;
        }
        XSNamedMap types = model.getComponents((short)3);
        if (ctx.trace) {
            log.trace((Object)("Model types: " + types.getLength()));
        }
        int i3 = 0;
        while (i3 < types.getLength()) {
            XSTypeDefinition type = (XSTypeDefinition)types.item(i3);
            if (!"http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) {
                XsdBinder.bindType(ctx, type);
            }
            ++i3;
        }
        XSNamedMap elements = model.getComponents((short)2);
        if (ctx.trace) {
            log.trace((Object)("Model elements: " + types.getLength()));
        }
        int i4 = 0;
        while (i4 < elements.getLength()) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i4);
            XsdBinder.bindElement(ctx, element, 1, 0, false);
            ++i4;
        }
        if (ctx.trace) {
            log.trace((Object)("finished binding schema " + schema));
        }
        return schema;
    }

    public static void bindType(SchemaBinding schema, XSTypeDefinition type) {
        TypeBinding typeBinding = XsdBinder.bindType(new Context(schema), type);
        schema.addType(typeBinding);
    }

    public static void bindElement(SchemaBinding schema, XSElementDeclaration element, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        ParticleBinding particle = XsdBinder.bindElement(new Context(schema), element, minOccurs, maxOccurs, maxOccursUnbounded);
        schema.addElementParticle(particle);
    }

    private static TypeBinding bindType(Context ctx, XSTypeDefinition type) {
        TypeBinding binding;
        switch (type.getTypeCategory()) {
            case 16: {
                binding = XsdBinder.bindSimpleType(ctx, (XSSimpleTypeDefinition)type);
                break;
            }
            case 15: {
                binding = XsdBinder.bindComplexType(ctx, (XSComplexTypeDefinition)type);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
            }
        }
        return binding;
    }

    private static TypeBinding bindSimpleType(Context ctx, XSSimpleTypeDefinition type) {
        XSObjectList annotations;
        int i;
        XSTypeDefinition baseTypeDef;
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : ctx.schema.getType(typeName);
        if (binding != null) {
            return binding;
        }
        if (ctx.trace) {
            log.trace((Object)("binding simple type " + typeName));
        }
        TypeBinding baseType = (baseTypeDef = type.getBaseType()) == null ? null : XsdBinder.bindType(ctx, baseTypeDef);
        binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
        StringList strList = type.getLexicalPattern();
        if (strList != null && strList.getLength() > 0) {
            i = 0;
            while (i < strList.getLength()) {
                binding.addLexicalPattern(strList.item(i));
                ++i;
            }
        }
        if ((strList = type.getLexicalEnumeration()) != null && strList.getLength() > 0) {
            i = 0;
            while (i < strList.getLength()) {
                binding.addEnumValue(strList.item(i));
                ++i;
            }
        }
        if (type.getItemType() != null) {
            TypeBinding itemType = XsdBinder.bindSimpleType(ctx, type.getItemType());
            binding.setItemType(itemType);
        }
        if (typeName != null) {
            ctx.schema.addType(binding);
        }
        if (ctx.trace) {
            String msg;
            String string = msg = typeName == null ? "bound simple anonymous type" : "bound simple type " + typeName;
            if (baseType != null) {
                msg = String.valueOf(msg) + " inherited binding metadata from " + baseType.getQName();
            }
            log.trace((Object)msg);
        }
        if (ctx.processAnnotations && (annotations = type.getAnnotations()) != null) {
            if (ctx.trace) {
                log.trace((Object)(typeName + " annotations " + annotations.getLength()));
            }
            int i2 = 0;
            while (i2 < annotations.getLength()) {
                XSAnnotation an = (XSAnnotation)annotations.item(i2);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo != null) {
                    ValueMetaData valueMetaData;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (ctx.trace) {
                            log.trace((Object)("simple type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                        if (ctx.trace) {
                            log.trace((Object)("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                        }
                        binding.setValueMetaData(valueMetaData);
                    }
                }
                ++i2;
            }
        }
        binding.setSchemaBinding(ctx.schema);
        return binding;
    }

    private static TypeBinding bindComplexType(Context ctx, XSComplexTypeDefinition type) {
        XSParticle particle;
        XSObjectList annotations;
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : ctx.schema.getType(typeName);
        if (binding != null) {
            return binding;
        }
        XSTypeDefinition baseTypeDef = type.getBaseType();
        TypeBinding baseType = null;
        if (baseTypeDef != null && !Constants.QNAME_ANYTYPE.equals(typeName)) {
            baseType = XsdBinder.bindType(ctx, baseTypeDef);
            if (typeName != null && (binding = ctx.schema.getType(typeName)) != null) {
                return binding;
            }
        }
        if (ctx.trace) {
            log.trace((Object)("binding complex " + (typeName == null ? "anonymous type" : "type " + typeName)));
        }
        binding = new TypeBinding(typeName);
        binding.setBaseType(baseType);
        binding.setStartElementCreatesObject(true);
        binding.setSimple(false);
        if (type.getSimpleType() != null) {
            TypeBinding simpleType = XsdBinder.bindSimpleType(ctx, type.getSimpleType());
            binding.setSimpleType(simpleType);
        } else if (type.getContentType() == 3) {
            TypeBinding stringType = ctx.schema.getType(Constants.QNAME_STRING);
            if (stringType == null) {
                throw new JBossXBRuntimeException("xsd:string has not been bound yet!");
            }
            binding.setSimpleType(stringType);
        }
        if (typeName != null) {
            ctx.schema.addType(binding);
        }
        binding.setSchemaBinding(ctx.schema);
        XSObjectList attrs = type.getAttributeUses();
        if (ctx.trace) {
            log.trace((Object)(typeName + " attributes " + attrs.getLength()));
        }
        int i = 0;
        while (i < attrs.getLength()) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            XsdBinder.bindAttributes(ctx, binding, attr);
            ++i;
        }
        if (ctx.processAnnotations && (annotations = type.getAnnotations()) != null) {
            if (ctx.trace) {
                log.trace((Object)(typeName + " annotations " + annotations.getLength()));
            }
            int i2 = 0;
            while (i2 < annotations.getLength()) {
                XSAnnotation an = (XSAnnotation)annotations.item(i2);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo != null) {
                    AddMethodMetaData addMethodMetaData;
                    PropertyMetaData propertyMetaData;
                    boolean skip;
                    MapEntryMetaData mapEntryMetaData;
                    CharactersMetaData charactersMetaData;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (ctx.trace) {
                            log.trace((Object)("complex type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((charactersMetaData = appInfo.getCharactersMetaData()) != null) {
                        if (ctx.trace) {
                            boolean mapEntryValue;
                            boolean mapEntryKey;
                            ValueMetaData valueMetaData;
                            PropertyMetaData propertyMetaData2 = charactersMetaData.getProperty();
                            if (propertyMetaData2 != null) {
                                log.trace((Object)("complex type " + type.getName() + ": characters bound to " + propertyMetaData2.getName()));
                            }
                            if ((valueMetaData = charactersMetaData.getValue()) != null) {
                                log.trace((Object)("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                            }
                            if (mapEntryKey = appInfo.isMapEntryKey()) {
                                log.trace((Object)("complex type " + type.getName() + ": characters are bound as a key in a map entry"));
                            }
                            if (mapEntryValue = appInfo.isMapEntryValue()) {
                                log.trace((Object)("complex type " + type.getName() + ": characters are bound as a value in a map entry"));
                            }
                        }
                        binding.setCharactersMetaData(charactersMetaData);
                    }
                    if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                        if (ctx.trace) {
                            log.trace((Object)("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue()));
                        }
                        if (classMetaData != null) {
                            throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
                        }
                        binding.setMapEntryMetaData(mapEntryMetaData);
                    }
                    if (skip = appInfo.isSkip()) {
                        if (ctx.trace) {
                            log.trace((Object)("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent."));
                        }
                        binding.setSkip(skip);
                    }
                    if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                        if (ctx.trace) {
                            log.trace((Object)("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName()));
                        }
                        binding.setPropertyMetaData(propertyMetaData);
                    }
                    if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                        if (ctx.trace) {
                            log.trace((Object)("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType()));
                        }
                        binding.setAddMethodMetaData(addMethodMetaData);
                    }
                }
                ++i2;
            }
        }
        if ((particle = type.getParticle()) != null) {
            ctx.pushType(binding);
            XsdBinder.bindParticle(ctx, particle);
            ctx.popType();
        }
        if (binding.hasOnlyXmlMimeAttributes()) {
            XsdBinder.addXOPInclude(binding, ctx.schema);
        }
        if (ctx.trace) {
            log.trace((Object)(typeName == null ? "bound complex anonymous type" : "bound complex type " + typeName));
        }
        return binding;
    }

    private static void bindAttributes(Context ctx, TypeBinding type, XSAttributeUse attrUse) {
        XSAnnotation an;
        XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
        QName attrName = new QName(attr.getNamespace(), attr.getName());
        if (ctx.trace) {
            log.trace((Object)("binding attribute " + attrName + " for " + type.getQName() + ", required=" + attrUse.getRequired()));
        }
        XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
        TypeBinding typeBinding = XsdBinder.bindSimpleType(ctx, attrType);
        AttributeBinding binding = type.addAttribute(attrName, typeBinding, DefaultHandlers.ATTRIBUTE_HANDLER);
        binding.setRequired(attrUse.getRequired());
        if (attrUse.getConstraintType() == 1) {
            binding.setDefaultConstraint(attrUse.getConstraintValue());
        }
        if (ctx.processAnnotations && (an = attr.getAnnotation()) != null) {
            XsdAnnotation xsdAn;
            XsdAppInfo appInfo;
            if (ctx.trace) {
                log.trace((Object)(attrName + " attribute annotation"));
            }
            if ((appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
                boolean mapEntryValue;
                boolean mapEntryKey;
                PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
                if (propertyMetaData != null) {
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if (mapEntryKey = appInfo.isMapEntryKey()) {
                    binding.setMapEntryKey(mapEntryKey);
                }
                if (mapEntryValue = appInfo.isMapEntryValue()) {
                    binding.setMapEntryValue(mapEntryValue);
                }
            }
        }
        if (ctx.trace) {
            String msg = "bound attribute " + attrName;
            msg = binding.getPropertyMetaData() != null ? String.valueOf(msg) + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType() : (binding.isMapEntryKey() ? String.valueOf(msg) + "bound as a key in a map entry" : (binding.isMapEntryValue() ? String.valueOf(msg) + "bound as a value in a map entry" : String.valueOf(msg) + " type=" + attrType.getName() + ", owner type=" + type.getQName()));
            if (binding.getDefaultConstraint() != null) {
                msg = String.valueOf(msg) + ", default=" + binding.getDefaultConstraint();
            }
            log.trace((Object)msg);
        }
    }

    private static void bindParticle(Context ctx, XSParticle particle) {
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                Object o;
                XSAnnotation annotation;
                ModelGroupBinding groupBinding;
                XSModelGroup modelGroup = (XSModelGroup)term;
                if (modelGroup.getParticles().getLength() <= 0) break;
                switch (modelGroup.getCompositor()) {
                    case 3: {
                        groupBinding = new AllBinding(ctx.schema);
                        break;
                    }
                    case 2: {
                        groupBinding = new ChoiceBinding(ctx.schema);
                        break;
                    }
                    case 1: {
                        groupBinding = new SequenceBinding(ctx.schema);
                        break;
                    }
                    default: {
                        throw new JBossXBRuntimeException("Unexpected model group: " + modelGroup.getCompositor());
                    }
                }
                ParticleBinding particleBinding = new ParticleBinding(groupBinding);
                particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
                particleBinding.setMinOccurs(particle.getMinOccurs());
                particleBinding.setMaxOccurs(particle.getMaxOccurs());
                if (ctx.trace) {
                    log.trace((Object)("created model group " + groupBinding));
                }
                if (ctx.processAnnotations && (annotation = modelGroup.getAnnotation()) != null) {
                    XsdBinder.customizeTerm(annotation, groupBinding, ctx.trace);
                }
                if ((o = ctx.peekTypeOrGroup()) instanceof ModelGroupBinding) {
                    ModelGroupBinding parentGroup = (ModelGroupBinding)o;
                    parentGroup.addParticle(particleBinding);
                    if (ctx.trace) {
                        log.trace((Object)("added " + groupBinding + " to " + parentGroup));
                    }
                } else if (o instanceof TypeBinding) {
                    TypeBinding typeBinding = (TypeBinding)o;
                    typeBinding.setParticle(particleBinding);
                    if (ctx.trace) {
                        log.trace((Object)("added " + groupBinding + " to type " + typeBinding.getQName()));
                    }
                }
                ctx.pushModelGroup(groupBinding);
                XsdBinder.bindModelGroup(ctx, modelGroup);
                ctx.popModelGroup();
                break;
            }
            case 9: {
                XsdBinder.bindWildcard(ctx, particle);
                break;
            }
            case 2: {
                XsdBinder.bindElement(ctx, (XSElementDeclaration)term, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
    }

    private static void bindWildcard(Context ctx, XSParticle particle) {
        XSAnnotation annotation;
        XSWildcard wildcard;
        WildcardBinding binding = new WildcardBinding(ctx.schema);
        ModelGroupBinding group = (ModelGroupBinding)ctx.peekTypeOrGroup();
        ParticleBinding particleBinding = new ParticleBinding(binding);
        particleBinding.setMaxOccurs(particle.getMaxOccurs());
        particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
        particleBinding.setMinOccurs(particle.getMinOccurs());
        group.addParticle(particleBinding);
        TypeBinding type = ctx.peekType();
        type.setWildcard(binding);
        if (ctx.trace) {
            log.trace((Object)("added wildcard to " + group));
            log.trace((Object)("added wildcard to type " + type.getQName()));
        }
        if ((wildcard = (XSWildcard)particle.getTerm()).getName() != null) {
            binding.setQName(new QName(wildcard.getNamespace(), wildcard.getName()));
        }
        binding.setProcessContents(wildcard.getProcessContents());
        if (ctx.processAnnotations && (annotation = wildcard.getAnnotation()) != null) {
            XsdBinder.customizeTerm(annotation, binding, ctx.trace);
        }
    }

    private static ParticleBinding bindElement(Context ctx, XSElementDeclaration elementDec, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        XSAnnotation an;
        QName qName = new QName(elementDec.getNamespace(), elementDec.getName());
        ModelGroupBinding parentGroup = (ModelGroupBinding)ctx.peekTypeOrGroup();
        boolean global = elementDec.getScope() == 1;
        ElementBinding element = ctx.schema.getElement(qName);
        if (global && element != null) {
            ParticleBinding particle = new ParticleBinding(element);
            if (parentGroup != null) {
                parentGroup.addParticle(particle);
            }
            particle.setMinOccurs(minOccurs);
            if (maxOccursUnbounded) {
                particle.setMaxOccursUnbounded(maxOccursUnbounded);
            } else {
                particle.setMaxOccurs(maxOccurs);
            }
            return particle;
        }
        TypeBinding type = null;
        boolean shared = ctx.sharedElements.isShared(elementDec);
        if (shared) {
            type = ctx.sharedElements.getTypeBinding(elementDec);
        }
        if (type == null) {
            type = XsdBinder.bindType(ctx, elementDec.getTypeDefinition());
            if (shared) {
                ctx.sharedElements.setTypeBinding(elementDec, type);
            }
        }
        element = new ElementBinding(ctx.schema, qName, type);
        element.setNillable(elementDec.getNillable());
        ParticleBinding particle = new ParticleBinding(element);
        particle.setMinOccurs(minOccurs);
        particle.setMaxOccurs(maxOccurs);
        particle.setMaxOccursUnbounded(maxOccursUnbounded);
        if (global) {
            ctx.schema.addElementParticle(particle);
        }
        if (parentGroup != null) {
            parentGroup.addParticle(particle);
            if (ctx.trace) {
                log.trace((Object)("Element " + element.getQName() + " added to " + parentGroup));
            }
        }
        if (ctx.trace) {
            TypeBinding parentType = ctx.peekType();
            log.trace((Object)("element: name=" + qName + ", type=" + type.getQName() + ", repeatable=" + particle.isRepeatable() + ", nillable=" + element.isNillable() + ", minOccurs=" + minOccurs + ", maxOccurs=" + (maxOccursUnbounded ? "unbounded" : "" + maxOccurs) + ", " + (global ? "global scope" : " owner type=" + parentType.getQName())));
        }
        if (ctx.processAnnotations && (an = elementDec.getAnnotation()) != null) {
            XsdBinder.customizeTerm(an, element, ctx.trace);
        }
        return particle;
    }

    private static void bindModelGroup(Context ctx, XSModelGroup modelGroup) {
        XSObjectList particles = modelGroup.getParticles();
        int i = 0;
        while (i < particles.getLength()) {
            XSParticle particle = (XSParticle)particles.item(i);
            XsdBinder.bindParticle(ctx, particle);
            ++i;
        }
    }

    private static void addXOPInclude(TypeBinding binding, SchemaBinding schema) {
        binding.setHandler(DefaultHandlers.XOP_HANDLER);
        if (binding.getParticle() != null) {
            throw new JBossXBRuntimeException("XOP optimizable type has a particle which is unexpected, please, open a JIRA issue!");
        }
        TypeBinding anyUriType = schema.getType(Constants.QNAME_ANYURI);
        if (anyUriType == null) {
            log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
        }
        TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
        xopIncludeType.setSchemaBinding(schema);
        xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
        xopIncludeType.setHandler(new XOPIncludeHandler(binding));
        ElementBinding xopInclude = new ElementBinding(schema, new QName("http://www.w3.org/2004/08/xop/include", "Include"), xopIncludeType);
        ParticleBinding particleBinding = new ParticleBinding(xopInclude);
        particleBinding.setMinOccurs(0);
        binding.addParticle(particleBinding);
    }

    private static void customizeTerm(XSAnnotation an, TermBinding term, boolean trace) {
        XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
        XsdAppInfo appInfo = xsdAn.getAppInfo();
        if (appInfo != null) {
            boolean mapEntryValue;
            boolean mapEntryKey;
            ValueMetaData valueMetaData;
            AddMethodMetaData addMethodMetaData;
            PutMethodMetaData putMethodMetaData;
            MapEntryMetaData mapEntryMetaData;
            PropertyMetaData propertyMetaData;
            Boolean skip = null;
            ClassMetaData classMetaData = appInfo.getClassMetaData();
            if (classMetaData != null) {
                if (trace) {
                    String msg = term.isModelGroup() ? term + " bound to " : (term.isWildcard() ? " wildcard bound to " : "element: name=" + ((ElementBinding)term).getQName() + ", class=");
                    msg = String.valueOf(msg) + classMetaData.getImpl();
                    log.trace((Object)msg);
                }
                term.setClassMetaData(classMetaData);
                skip = Boolean.FALSE;
            }
            if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term + " " : "element: name=" + ((ElementBinding)term).getQName() + ", ";
                    msg = String.valueOf(msg) + " property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType();
                    log.trace((Object)msg);
                }
                term.setPropertyMetaData(propertyMetaData);
            }
            if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                String msg;
                if (propertyMetaData != null) {
                    String msg2 = "A term can be bound either as a property or as a map entry but not both: " + (term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg2);
                }
                if (trace) {
                    msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = String.valueOf(msg) + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue();
                    log.trace((Object)msg);
                }
                if (classMetaData != null) {
                    msg = "Invalid customization: both jbxb:class and jbxb:mapEntry are specified for term " + (term.isWildcard() || term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg);
                }
                term.setMapEntryMetaData(mapEntryMetaData);
                skip = Boolean.FALSE;
            }
            if ((putMethodMetaData = appInfo.getPutMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = String.valueOf(msg) + " putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType();
                    log.trace((Object)msg);
                }
                term.setPutMethodMetaData(putMethodMetaData);
            }
            if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = String.valueOf(msg) + " addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType();
                    log.trace((Object)msg);
                }
                term.setAddMethodMetaData(addMethodMetaData);
            }
            if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element " + ((ElementBinding)term).getQName();
                    msg = String.valueOf(msg) + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod();
                    log.trace((Object)msg);
                }
                term.setValueMetaData(valueMetaData);
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = String.valueOf(msg) + ": is bound to a key in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryKey(mapEntryKey);
                skip = Boolean.FALSE;
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = String.valueOf(msg) + ": is bound to a value in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryValue(mapEntryValue);
                skip = Boolean.FALSE;
            }
            boolean skipAnnotation = appInfo.isSkip();
            if (skip != null) {
                term.setSkip(skip);
            } else if (skipAnnotation) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = String.valueOf(msg) + ": will be skipped, it's attributes, character content and children will be set on the parent";
                    log.trace((Object)msg);
                }
                term.setSkip(skipAnnotation ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private static void bindGlobalGroup(XSModelGroup group, SharedElements sharedElements) {
        XSObjectList particles = group.getParticles();
        int j = 0;
        while (j < particles.getLength()) {
            XSParticle particle = (XSParticle)particles.item(j);
            XSTerm term = particle.getTerm();
            switch (term.getType()) {
                case 2: {
                    XSElementDeclaration element = (XSElementDeclaration)term;
                    sharedElements.add(element);
                    break;
                }
                case 9: {
                    break;
                }
                case 7: {
                    XsdBinder.bindGlobalGroup((XSModelGroup)term, sharedElements);
                }
            }
            ++j;
        }
    }

    private static final class SharedElements {
        private Map elements = Collections.EMPTY_MAP;

        private SharedElements() {
        }

        public void add(XSElementDeclaration element) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, null);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, null);
                }
            }
        }

        public boolean isShared(XSElementDeclaration element) {
            return this.elements.containsKey(element);
        }

        public TypeBinding getTypeBinding(XSElementDeclaration element) {
            return (TypeBinding)this.elements.get(element);
        }

        public void setTypeBinding(XSElementDeclaration element, TypeBinding type) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, type);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, type);
                }
            }
        }
    }

    private static final class Context {
        public final SchemaBinding schema;
        public SharedElements sharedElements = new SharedElements();
        public boolean processAnnotations = true;
        public boolean trace = log.isTraceEnabled();
        private final List typeGroupStack = new ArrayList();

        public Context() {
            this(new SchemaBinding());
        }

        public Context(SchemaBinding schema) {
            this.schema = schema;
        }

        public void popType() {
            Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
            if (!(o instanceof TypeBinding)) {
                throw new JBossXBRuntimeException("Should have poped type binding but got " + o);
            }
        }

        public void pushType(TypeBinding binding) {
            this.typeGroupStack.add(binding);
        }

        public void popModelGroup() {
            Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
            if (!(o instanceof ModelGroupBinding)) {
                throw new JBossXBRuntimeException("Should have poped model group binding but got " + o);
            }
        }

        public void pushModelGroup(ModelGroupBinding binding) {
            this.typeGroupStack.add(binding);
        }

        public Object peekTypeOrGroup() {
            return this.typeGroupStack.isEmpty() ? null : this.typeGroupStack.get(this.typeGroupStack.size() - 1);
        }

        public TypeBinding peekType() {
            TypeBinding binding = null;
            ListIterator i = this.typeGroupStack.listIterator(this.typeGroupStack.size());
            while (i.hasPrevious()) {
                Object o = i.previous();
                if (!(o instanceof TypeBinding)) continue;
                binding = (TypeBinding)o;
                break;
            }
            return binding;
        }
    }
}

