/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XercesXsMarshaller
extends AbstractMarshaller {
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Object root;
    private boolean supportNil = true;
    private QName rootTypeQName;
    private SchemaBindingResolver schemaResolver;
    private XSModel model;
    private boolean ignoreUnresolvedWildcard;
    private XSAttributeUse currentAttribute;
    private XSTypeDefinition currentElementType;
    private String simpleContentProperty = "value";
    private MarshallingContext ctx = new MarshallingContext(){
        private ContentHandler ch;

        public boolean isAttributeRequired() {
            if (XercesXsMarshaller.this.currentAttribute == null) {
                throw new JBossXBRuntimeException("There is no current attribute!");
            }
            return XercesXsMarshaller.this.currentAttribute.getRequired();
        }

        public boolean isTypeComplex() {
            if (XercesXsMarshaller.this.currentElementType == null) {
                throw new JBossXBRuntimeException("There is no current element!");
            }
            return XercesXsMarshaller.this.currentElementType.getTypeCategory() == 15;
        }

        public String getSimpleContentProperty() {
            return XercesXsMarshaller.this.simpleContentProperty;
        }

        public ContentHandler getContentHandler() {
            if (this.ch == null) {
                this.ch = new AbstractMarshaller.ContentHandlerAdaptor();
            }
            return this.ch;
        }

        public NamespaceRegistry getNamespaceContext() {
            return XercesXsMarshaller.this.nsRegistry;
        }
    };

    public String getSimpleContentProperty() {
        return this.simpleContentProperty;
    }

    public void setSimpleContentProperty(String simpleContentProperty) {
        this.simpleContentProperty = simpleContentProperty;
    }

    public boolean isIgnoreUnresolvedWildcard() {
        return this.ignoreUnresolvedWildcard;
    }

    public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard) {
        this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        XSModel model = Util.loadSchema(xsdReader, null, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        XSModel model = Util.loadSchema(xsdURL, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(XSModel model, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        this.marshallInternal(provider, root, model, writer);
    }

    private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer) throws IOException, SAXException {
        if (model == null) {
            throw new JBossXBRuntimeException("XSModel is not available!");
        }
        this.model = model;
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            XSTypeDefinition type = model.getTypeDefinition(this.rootTypeQName.getLocalPart(), this.rootTypeQName.getNamespaceURI());
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (XercesXsMarshaller.isArrayWrapper(type)) {
                Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
                this.stack.push(o);
                this.marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), (XSComplexTypeDefinition)type, true, false);
                this.stack.pop();
            } else {
                Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
                this.marshalElementOccurence(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, o, false, false, true);
            }
        } else if (this.rootQNames.isEmpty()) {
            XSNamedMap components = model.getComponents((short)2);
            if (components.getLength() == 0) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            for (int i = 0; i < components.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(i);
                Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
                this.marshalElementOccurence(element.getNamespace(), element.getName(), element.getTypeDefinition(), o, element.getNillable(), false, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XSElementDeclaration element = model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI());
                if (element == null) {
                    XSNamedMap components = model.getComponents((short)2);
                    String roots = "";
                    for (int j = 0; j < components.getLength(); ++j) {
                        XSObject xsObject = components.item(j);
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + "{" + xsObject.getNamespace() + "}" + xsObject.getName();
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
                this.marshalElementOccurence(element.getNamespace(), element.getName(), element.getTypeDefinition(), o, element.getNillable(), false, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
        if (this.log.isTraceEnabled()) {
            StringWriter traceWriter = new StringWriter();
            contentWriter = new ContentWriter(traceWriter, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
            this.content.handleContent(contentWriter);
            this.log.trace((Object)("marshalled:\n" + traceWriter.getBuffer().toString()));
        }
    }

    private boolean marshalElement(String elementNs, String elementLocal, XSTypeDefinition type, boolean optional, boolean nillable, boolean declareNs, boolean declareXsiType) {
        boolean trace;
        Object value = this.stack.peek();
        boolean result = value != null || value == null && (optional || nillable);
        boolean bl = trace = this.log.isTraceEnabled() && result;
        if (trace) {
            String prefix = this.getPrefix(elementNs);
            this.log.trace((Object)("started element ns=" + elementNs + ", local=" + elementLocal + ", prefix=" + prefix));
        }
        if (value != null) {
            this.marshalElementType(elementNs, elementLocal, type, declareNs, nillable, declareXsiType);
        } else if (nillable) {
            this.writeNillable(elementNs, elementLocal, nillable);
        }
        if (trace) {
            this.log.trace((Object)("finished element ns=" + elementNs + ", local=" + elementLocal));
        }
        return result;
    }

    private void marshalElementType(String elementNs, String elementLocal, XSTypeDefinition type, boolean declareNs, boolean nillable, boolean declareXsiType) {
        switch (type.getTypeCategory()) {
            case 16: {
                this.marshalSimpleType(elementNs, elementLocal, (XSSimpleTypeDefinition)type, declareNs, nillable, declareXsiType);
                break;
            }
            case 15: {
                this.marshalComplexType(elementNs, elementLocal, (XSComplexTypeDefinition)type, declareNs, declareXsiType);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
            }
        }
    }

    private void marshalSimpleType(String elementUri, String elementLocal, XSSimpleTypeDefinition type, boolean declareNs, boolean nillable, boolean declareXsiType) {
        Object value = this.stack.peek();
        if (value != null) {
            boolean genPrefix;
            String prefix = this.getPrefix(elementUri);
            boolean bl = genPrefix = prefix == null && elementUri != null && elementUri.length() > 0;
            if (genPrefix) {
                prefix = "ns_" + elementLocal;
            }
            AttributesImpl attrs = null;
            String typeName = type.getName();
            if ("QName".equals(typeName) || "NOTATION".equals(typeName) || type.getItemType() != null && ("QName".equals(type.getItemType().getName()) || "NOTATION".equals(type.getItemType().getName()))) {
                attrs = new AttributesImpl(5);
            }
            String marshalled = this.marshalCharacters(elementUri, prefix, type, value, attrs);
            if ((declareNs || declareXsiType) && this.nsRegistry.size() > 0) {
                if (attrs == null) {
                    attrs = new AttributesImpl(this.nsRegistry.size() + 1);
                }
                this.declareNs(attrs);
            }
            if (declareXsiType) {
                this.declareXsiType((XSTypeDefinition)type, attrs);
            }
            if (genPrefix) {
                if (attrs == null) {
                    attrs = new AttributesImpl(1);
                }
                attrs.add(null, prefix, "xmlns:" + prefix, null, elementUri);
            }
            String qName = XercesXsMarshaller.prefixLocalName(prefix, elementLocal);
            this.content.startElement(elementUri, elementLocal, qName, attrs);
            this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
            this.content.endElement(elementUri, elementLocal, qName);
        } else {
            this.writeNillable(elementUri, elementLocal, nillable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalComplexType(String elementNsUri, String elementLocalName, XSComplexTypeDefinition type, boolean declareNs, boolean declareXsiType) {
        Object value;
        String prefix;
        boolean genPrefix;
        AttributesImpl attrs;
        Object o = this.stack.peek();
        XSParticle particle = type.getParticle();
        XSObjectList attributeUses = type.getAttributeUses();
        int attrsTotal = declareNs || declareXsiType ? this.nsRegistry.size() + attributeUses.getLength() + 1 : attributeUses.getLength();
        AttributesImpl attributesImpl = attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && this.nsRegistry.size() > 0) {
            this.declareNs(attrs);
        }
        String generatedPrefix = null;
        if (declareXsiType && (generatedPrefix = this.declareXsiType((XSTypeDefinition)type, attrs)) != null) {
            String typeNsWithGeneratedPrefix = type.getNamespace();
            XercesXsMarshaller.declareNs(attrs, generatedPrefix, typeNsWithGeneratedPrefix);
            this.declareNamespace(generatedPrefix, typeNsWithGeneratedPrefix);
        }
        boolean bl = genPrefix = (prefix = this.getPrefix(elementNsUri)) == null && elementNsUri != null && elementNsUri.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocalName;
            this.declareNamespace(prefix, elementNsUri);
            if (attrs == null) {
                attrs = new AttributesImpl(1);
            }
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNsUri);
        }
        for (int i = 0; i < attributeUses.getLength(); ++i) {
            String attrLocal;
            this.currentAttribute = (XSAttributeUse)attributeUses.item(i);
            XSAttributeDeclaration attrDec = this.currentAttribute.getAttrDeclaration();
            String attrNs = attrDec.getNamespace();
            Object attrValue = this.provider.getAttributeValue(o, this.ctx, attrNs, attrLocal = attrDec.getName());
            if (attrValue == null) continue;
            if (attrs == null) {
                attrs = new AttributesImpl(5);
            }
            String attrPrefix = null;
            if (attrNs != null && (attrPrefix = this.getPrefix(attrNs)) == null && attrNs != null && attrNs.length() > 0) {
                attrPrefix = "ns_" + attrLocal;
                attrs.add(null, attrPrefix, "xmlns:" + attrPrefix, null, attrNs);
            }
            String qName = attrPrefix == null || attrPrefix.length() == 0 ? attrLocal : attrPrefix + ":" + attrLocal;
            XSSimpleTypeDefinition attrType = attrDec.getTypeDefinition();
            if (attrType.getItemType() != null) {
                List<Object> list;
                XSSimpleTypeDefinition itemType = attrType.getItemType();
                if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
                if (attrValue instanceof List) {
                    list = (List<Object>)attrValue;
                } else {
                    if (!attrValue.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + attrValue);
                    list = Arrays.asList((Object[])attrValue);
                }
                if (Constants.QNAME_QNAME.getLocalPart().equals(itemType.getName())) {
                    for (int listInd = 0; listInd < list.size(); ++listInd) {
                        String itemPrefix;
                        QName item = (QName)list.get(listInd);
                        String itemNs = item.getNamespaceURI();
                        if (itemNs == null || itemNs.length() <= 0) continue;
                        if (itemNs.equals(elementNsUri)) {
                            itemPrefix = prefix;
                        } else {
                            itemPrefix = this.getPrefix(itemNs);
                            if (itemPrefix == null) {
                                itemPrefix = attrLocal + listInd;
                                XercesXsMarshaller.declareNs(attrs, itemPrefix, itemNs);
                            }
                        }
                        item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
                        list.set(listInd, item);
                    }
                }
                attrValue = SimpleTypeBindings.marshalList(itemType.getName(), list, null);
            } else if (attrType.getLexicalPattern().item(0) != null && attrType.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), (short)2)) {
                String item = attrType.getLexicalPattern().item(0);
                attrValue = item.indexOf(48) != -1 && item.indexOf(49) != -1 ? ((Boolean)attrValue != false ? "1" : "0") : ((Boolean)attrValue != false ? "true" : "false");
            } else if (Constants.QNAME_QNAME.getNamespaceURI().equals(attrType.getNamespace()) && Constants.QNAME_QNAME.getLocalPart().equals(attrType.getName())) {
                QName qNameValue = (QName)attrValue;
                String qNamePrefix = null;
                boolean declarePrefix = false;
                String ns = qNameValue.getNamespaceURI();
                if (ns != null && ns.length() > 0 && (qNamePrefix = this.getPrefix(ns)) == null) {
                    qNamePrefix = qNameValue.getPrefix();
                    if (qNamePrefix == null || qNamePrefix.length() == 0) {
                        qNamePrefix = "ns_" + qNameValue.getLocalPart();
                    }
                    XercesXsMarshaller.declareNs(attrs, qNamePrefix, ns);
                    this.nsRegistry.addPrefixMapping(qNamePrefix, ns);
                    declarePrefix = true;
                }
                attrValue = SimpleTypeBindings.marshalQName(qNameValue, this.nsRegistry);
                if (declarePrefix) {
                    this.nsRegistry.removePrefixMapping(qNamePrefix);
                }
            } else {
                attrValue = attrValue.toString();
            }
            attrs.add(attrNs, attrLocal, qName, attrDec.getTypeDefinition().getName(), attrValue.toString());
        }
        this.currentAttribute = null;
        String characters = null;
        if (type.getSimpleType() != null && (value = this.getSimpleContentValue(elementNsUri, elementLocalName, (XSTypeDefinition)type)) != null) {
            XSSimpleTypeDefinition simpleType = type.getSimpleType();
            String typeName = simpleType.getName();
            if (attrs == null && ("QName".equals(typeName) || "NOTATION".equals(typeName) || simpleType.getItemType() != null && ("QName".equals(simpleType.getItemType().getName()) || "NOTATION".equals(simpleType.getItemType().getName())))) {
                attrs = new AttributesImpl(5);
            }
            characters = this.marshalCharacters(elementNsUri, prefix, simpleType, value, attrs);
        }
        String qName = XercesXsMarshaller.prefixLocalName(prefix, elementLocalName);
        this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        if (characters != null) {
            this.content.characters(characters.toCharArray(), 0, characters.length());
        }
        this.content.endElement(elementNsUri, elementLocalName, qName);
        if (genPrefix) {
            this.removePrefixMapping(prefix);
        }
        if (generatedPrefix == null) return;
        this.removePrefixMapping(generatedPrefix);
    }

    private boolean marshalParticle(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                Iterator i;
                Object o = this.stack.peek();
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        this.stack.push(value);
                        marshalled = this.marshalModelGroup(particle, declareNs);
                        this.stack.pop();
                    }
                    break;
                }
                marshalled = this.marshalModelGroup(particle, declareNs);
                break;
            }
            case 9: {
                Iterator i;
                Object o = this.stack.peek();
                boolean popWildcardValue = false;
                ObjectLocalMarshaller marshaller = null;
                AbstractMarshaller.FieldToWildcardMapping mapping = (AbstractMarshaller.FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
                if (mapping != null) {
                    marshaller = mapping.marshaller;
                    o = mapping.fieldInfo.getValue(o);
                    this.stack.push(o);
                    popWildcardValue = true;
                }
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        marshalled = this.marshalWildcardOccurence(particle, marshaller, value, declareNs);
                    }
                } else {
                    marshalled = this.marshalWildcardOccurence(particle, marshaller, o, declareNs);
                }
                if (!popWildcardValue) break;
                this.stack.pop();
                break;
            }
            case 2: {
                Iterator i;
                XSElementDeclaration element = (XSElementDeclaration)term;
                XSTypeDefinition type = element.getTypeDefinition();
                Object o = this.getElementValue(element.getNamespace(), element.getName(), type);
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        marshalled = this.marshalElementOccurence(element.getNamespace(), element.getName(), type, value, element.getNillable(), particle.getMinOccurs() == 0, declareNs);
                    }
                    break;
                }
                marshalled = this.marshalElementOccurence(element.getNamespace(), element.getName(), type, o, element.getNillable(), particle.getMinOccurs() == 0, declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        return marshalled;
    }

    private boolean marshalElementOccurence(String elementNs, String elementLocal, XSTypeDefinition type, Object value, boolean nillable, boolean optional, boolean declareNs) {
        boolean declareXsiType = false;
        QName xsiTypeQName = null;
        if (!(value == null || (xsiTypeQName = (QName)this.cls2TypeMap.get(value.getClass())) == null || type.getName().equals(xsiTypeQName.getLocalPart()) && type.getNamespace().equals(xsiTypeQName.getNamespaceURI()))) {
            XSTypeDefinition xsiType;
            declareXsiType = true;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(value.getClass() + " is mapped to xsi:type " + xsiTypeQName));
            }
            if ((xsiType = this.model.getTypeDefinition(xsiTypeQName.getLocalPart(), xsiTypeQName.getNamespaceURI())) == null) {
                this.log.warn((Object)("Class " + value.getClass() + " is mapped to type " + xsiTypeQName + " but the type is not found in schema."));
            } else {
                type = xsiType;
            }
        }
        this.stack.push(value);
        boolean marshalled = this.marshalElement(elementNs, elementLocal, type, optional, nillable, declareNs, declareXsiType);
        this.stack.pop();
        return marshalled;
    }

    private boolean marshalWildcardOccurence(XSParticle particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs) {
        boolean marshalled = true;
        if (marshaller != null) {
            marshaller.marshal(this.ctx, value);
        } else {
            this.stack.push(value);
            marshalled = this.marshalWildcard(particle, declareNs);
            this.stack.pop();
        }
        return marshalled;
    }

    private boolean marshalWildcard(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSWildcard wildcard = (XSWildcard)particle.getTerm();
        Object o = this.stack.peek();
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(o.getClass());
        if (mapping == null) {
            QName autoType = SimpleTypeBindings.typeQName(o.getClass());
            if (autoType != null) {
                String marshalled2 = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
                this.content.characters(marshalled2.toCharArray(), 0, marshalled2.length());
                return true;
            }
            if (this.ignoreUnresolvedWildcard) {
                this.log.warn((Object)("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o));
                return true;
            }
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
        }
        GenericObjectModelProvider parentProvider = this.provider;
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        XSModel parentModel = this.model;
        this.root = o;
        this.stack = new AbstractMarshaller.StackImpl();
        XSModel xSModel = this.model = mapping.schemaUrl == null ? this.model : Util.loadSchema(mapping.schemaUrl, this.schemaResolver);
        if (mapping.provider != null) {
            this.provider = mapping.provider;
        }
        if (mapping.elementName != null) {
            XSElementDeclaration elDec = this.model.getElementDeclaration(mapping.elementName.getLocalPart(), mapping.elementName.getNamespaceURI());
            if (elDec == null) {
                throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
            }
            Object elementValue = this.provider.getRoot(this.root, null, elDec.getNamespace(), elDec.getName());
            marshalled = this.marshalElementOccurence(elDec.getNamespace(), elDec.getName(), elDec.getTypeDefinition(), elementValue, elDec.getNillable(), particle.getMinOccurs() == 0, declareNs);
        } else if (mapping.typeName != null) {
            XSTypeDefinition typeDef = this.model.getTypeDefinition(mapping.typeName.getLocalPart(), mapping.typeName.getNamespaceURI());
            if (typeDef == null) {
                ArrayList<QName> typeNames = new ArrayList<QName>();
                XSNamedMap types = this.model.getComponents((short)3);
                for (int i = 0; i < types.getLength(); ++i) {
                    XSObject type = types.item(i);
                    if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
                    typeNames.add(new QName(type.getNamespace(), type.getName()));
                }
                throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema." + " Defined types are: " + typeNames);
            }
            Object elementValue = this.provider.getRoot(this.root, null, wildcard.getNamespace(), wildcard.getName());
            marshalled = this.marshalElementOccurence(wildcard.getNamespace(), wildcard.getName(), typeDef, elementValue, true, particle.getMinOccurs() == 0, declareNs);
        } else {
            throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
        }
        this.root = parentRoot;
        this.provider = parentProvider;
        this.stack = parentStack;
        this.model = parentModel;
        return marshalled;
    }

    private boolean marshalModelGroup(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSModelGroup modelGroup = (XSModelGroup)particle.getTerm();
        switch (modelGroup.getCompositor()) {
            case 3: {
                marshalled = this.marshalModelGroupAll(modelGroup.getParticles(), declareNs);
                break;
            }
            case 2: {
                marshalled = this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
                break;
            }
            case 1: {
                marshalled = this.marshalModelGroupSequence(modelGroup.getParticles(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
            }
        }
        return marshalled;
    }

    private boolean marshalModelGroupAll(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        for (int i = 0; i < particles.getLength() && !marshalled; ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(XSObjectList particles, boolean declareNs) {
        boolean marshalled = true;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled &= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String marshalCharacters(String elementUri, String elementPrefix, XSSimpleTypeDefinition type, Object value, AttributesImpl attrs) {
        boolean removePrefix;
        String prefix;
        String typeName;
        if (type.getItemType() != null) {
            List list;
            XSSimpleTypeDefinition itemType = type.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List)value;
                return SimpleTypeBindings.marshalList(itemType.getName(), list, null);
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = XercesXsMarshaller.asList(value);
            }
            return SimpleTypeBindings.marshalList(itemType.getName(), list, null);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) {
            QName qName;
            typeName = type.getName();
            prefix = null;
            removePrefix = false;
            if (("QName".equals(typeName) || "NOTATION".equals(typeName)) && (qName = (QName)value).getNamespaceURI() != null && qName.getNamespaceURI().length() > 0 && (prefix = this.nsRegistry.getPrefix(qName.getNamespaceURI())) == null) {
                prefix = qName.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = qName.getLocalPart() + "_ns";
                }
                this.nsRegistry.addPrefixMapping(prefix, qName.getNamespaceURI());
                XercesXsMarshaller.declareNs(attrs, prefix, qName.getNamespaceURI());
                removePrefix = true;
            }
        } else {
            Method getValue;
            if (type.getLexicalPattern().item(0) != null && type.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), (short)2)) {
                String item = type.getLexicalPattern().item(0);
                if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
                    if ((Boolean)value == false) return "0";
                    return "1";
                }
                if ((Boolean)value == false) return "false";
                return "true";
            }
            StringList lexicalEnumeration = type.getLexicalEnumeration();
            if (lexicalEnumeration == null) return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
            if (lexicalEnumeration.getLength() <= 0) return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
            try {
                getValue = value.getClass().getMethod("value", null);
            }
            catch (NoSuchMethodException e) {
                try {
                    getValue = value.getClass().getMethod("getValue", null);
                }
                catch (NoSuchMethodException e1) {
                    ArrayList<String> values = new ArrayList<String>(lexicalEnumeration.getLength());
                    int i = 0;
                    while (i < lexicalEnumeration.getLength()) {
                        values.add(lexicalEnumeration.item(i));
                        ++i;
                    }
                    throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type (" + type.getNamespace() + ", " + type.getName() + "): " + values);
                }
            }
            try {
                value = getValue.invoke(value, null);
                return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
            }
        }
        String marshalled = SimpleTypeBindings.marshal(typeName, value, this.nsRegistry);
        if (!removePrefix) return marshalled;
        this.nsRegistry.removePrefixMapping(prefix);
        return marshalled;
    }

    private String declareXsiType(XSTypeDefinition type, AttributesImpl attrs) {
        String pref;
        String result = null;
        String xsiPrefix = this.nsRegistry.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            attrs.add("http://www.w3.org/2001/XMLSchema", "xmlns", "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
            xsiPrefix = "xsi";
        }
        if ((pref = this.getPrefix(type.getNamespace())) == null) {
            result = pref = type.getName() + "_ns";
        }
        String typeQName = pref == null ? type.getName() : pref + ':' + type.getName();
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":type", null, typeQName);
        return result;
    }

    private Object getElementValue(String elementNs, String elementLocal, XSTypeDefinition type) {
        Object value;
        Object peeked;
        Object object = peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
        if (peeked == null) {
            value = null;
        } else if (peeked instanceof Collection || peeked.getClass().isArray()) {
            value = peeked;
        } else {
            XSTypeDefinition parentType = this.currentElementType;
            this.currentElementType = type;
            value = this.provider.getChildren(peeked, this.ctx, elementNs, elementLocal);
            if (value == null) {
                value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
            }
            this.currentElementType = parentType;
        }
        return value;
    }

    private Object getSimpleContentValue(String elementNs, String elementLocal, XSTypeDefinition type) {
        Object value;
        Object peeked;
        Object object = peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
        if (peeked == null) {
            value = null;
        } else {
            XSTypeDefinition parentType = this.currentElementType;
            this.currentElementType = type;
            value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
            this.currentElementType = parentType;
        }
        return value;
    }

    private void writeNillable(String elementNs, String elementLocal, boolean nillable) {
        AttributesImpl attrs;
        if (!this.supportNil) {
            return;
        }
        if (!nillable) {
            throw new JBossXBRuntimeException("Failed to marshal " + new QName(elementNs, elementLocal) + ": Java value is null but the element is not nillable.");
        }
        String prefix = this.getPrefix(elementNs);
        if (prefix == null && elementNs != null && elementNs.length() > 0) {
            prefix = "ns_" + elementLocal;
            attrs = new AttributesImpl(2);
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNs);
        } else {
            attrs = new AttributesImpl(1);
        }
        String xsiPrefix = this.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            xsiPrefix = "xsi";
            attrs.add(null, xsiPrefix, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
        }
        String nilQName = xsiPrefix + ":nil";
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
        String qName = XercesXsMarshaller.prefixLocalName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, attrs);
        this.content.endElement(elementNs, elementLocal, qName);
    }

    private static boolean isArrayWrapper(XSTypeDefinition type) {
        XSComplexTypeDefinition cType;
        XSParticle particle;
        boolean is = false;
        if (15 == type.getTypeCategory() && (particle = (cType = (XSComplexTypeDefinition)type).getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }

    private Iterator getIterator(Object value) {
        Iterator i = null;
        if (value instanceof Collection) {
            i = ((Collection)value).iterator();
        } else if (value.getClass().isArray()) {
            final Object arr = value;
            i = new Iterator(){
                private int curInd = 0;
                private int length = Array.getLength(arr);

                public boolean hasNext() {
                    return this.curInd < this.length;
                }

                public Object next() {
                    return Array.get(arr, this.curInd++);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented.");
                }
            };
        } else if (value instanceof Iterator) {
            i = (Iterator)value;
        }
        return i;
    }

    private static boolean isRepeatable(XSParticle particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1 || particle.getMinOccurs() > 1;
    }

    private static final List asList(final Object arr) {
        return new AbstractList(){
            private final Object array;
            {
                this.array = arr;
            }

            public Object get(int index) {
                return Array.get(this.array, index);
            }

            public int size() {
                return Array.getLength(this.array);
            }
        };
    }
}

