/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverConfigMBean;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class SchemaResolverConfig
implements SchemaResolverConfigMBean {
    private static final Logger log = Logger.getLogger((Class)SchemaResolverConfig.class);
    protected static DefaultSchemaResolver resolver = (DefaultSchemaResolver)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    protected Properties schemaInitializers;
    protected Properties schemaLocations;
    protected Properties parseAnnotations;

    public Properties getSchemaInitializers() {
        return this.schemaInitializers;
    }

    public void setSchemaInitializers(Properties schemaInitializers) {
        this.schemaInitializers = schemaInitializers;
        if (schemaInitializers != null && schemaInitializers.size() != 0) {
            Iterator<Map.Entry<Object, Object>> i = schemaInitializers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String namespace = (String)entry.getKey();
                String initializer = (String)entry.getValue();
                try {
                    resolver.addSchemaInitializer(namespace, initializer);
                }
                catch (Exception ignored) {
                    log.debug((Object)"Ignored: ", (Throwable)ignored);
                }
            }
        }
    }

    public Properties getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(Properties schemaLocations) {
        this.schemaLocations = schemaLocations;
        if (schemaLocations != null && schemaLocations.size() != 0) {
            Iterator<Map.Entry<Object, Object>> i = schemaLocations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String namespace = (String)entry.getKey();
                String location = (String)entry.getValue();
                resolver.addSchemaLocation(namespace, location);
            }
        }
    }

    public Properties getParseAnnotations() {
        return this.parseAnnotations;
    }

    public void setParseAnnotations(Properties parseAnnotations) {
        this.parseAnnotations = parseAnnotations;
        if (parseAnnotations != null && parseAnnotations.size() != 0) {
            Iterator<Map.Entry<Object, Object>> i = parseAnnotations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String namespace = (String)entry.getKey();
                String value = (String)entry.getValue();
                Boolean booleanValue = Boolean.valueOf(value);
                resolver.addSchemaParseAnnotations(namespace, booleanValue);
            }
        }
    }
}

