/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jms;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestSetup;
import org.objectweb.jtests.jms.conform.connection.ConnectionTest;
import org.objectweb.jtests.jms.conform.connection.TopicConnectionTest;
import org.objectweb.jtests.jms.conform.message.MessageBodyTest;
import org.objectweb.jtests.jms.conform.message.MessageDefaultTest;
import org.objectweb.jtests.jms.conform.message.MessageTypeTest;
import org.objectweb.jtests.jms.conform.message.headers.MessageHeaderTest;
import org.objectweb.jtests.jms.conform.message.properties.JMSXPropertyTest;
import org.objectweb.jtests.jms.conform.message.properties.MessagePropertyConversionTest;
import org.objectweb.jtests.jms.conform.message.properties.MessagePropertyTest;
import org.objectweb.jtests.jms.conform.queue.QueueBrowserTest;
import org.objectweb.jtests.jms.conform.queue.TemporaryQueueTest;
import org.objectweb.jtests.jms.conform.selector.SelectorSyntaxTest;
import org.objectweb.jtests.jms.conform.selector.SelectorTest;
import org.objectweb.jtests.jms.conform.session.QueueSessionTest;
import org.objectweb.jtests.jms.conform.session.SessionTest;
import org.objectweb.jtests.jms.conform.session.TopicSessionTest;
import org.objectweb.jtests.jms.conform.session.UnifiedSessionTest;
import org.objectweb.jtests.jms.conform.topic.TemporaryTopicTest;

/**
 * JoramUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.2 $
 */
public class JoramUnitTestCase extends AbstractTestCaseWithSetup
{
   public JoramUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * Get the test delegate
    * 
    * @param clazz the test class
    * @param adminName the admin name
    * @return the delegate
    * @throws Exception for any error
    */
   public static JoramTestDelegate getDelegate(Class clazz, String adminName) throws Exception
   {
      return new JoramTestDelegate(clazz, adminName);
   }

   public static Test getTestSuite(Class clazz) throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(ConnectionTest.suite());
      suite.addTest(TopicConnectionTest.suite());
      suite.addTest(MessageBodyTest.suite());
      suite.addTest(MessageDefaultTest.suite());
      suite.addTest(MessageTypeTest.suite());
      suite.addTest(MessageHeaderTest.suite());
      suite.addTest(JMSXPropertyTest.suite());
      suite.addTest(MessagePropertyConversionTest.suite());
      suite.addTest(MessagePropertyTest.suite());
      suite.addTest(QueueBrowserTest.suite());
      suite.addTest(TemporaryQueueTest.suite());
      suite.addTest(SelectorSyntaxTest.suite());
      suite.addTest(SelectorTest.suite());
      suite.addTest(QueueSessionTest.suite());
      suite.addTest(SessionTest.suite());
      suite.addTest(TopicSessionTest.suite());
      suite.addTest(UnifiedSessionTest.suite());
      suite.addTest(TemporaryTopicTest.suite());
      return new AbstractTestSetup(clazz, suite);
   }
}
