/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.jdk.SecurityActions;

class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name) {
        String value = System.getSecurityManager() == null ? Actions.NON_PRIVILEGED.getProperty(name) : Actions.PRIVILEGED.getProperty(name);
        return value;
    }

    static String getProperty(String name, String def) {
        String value = System.getSecurityManager() == null ? Actions.NON_PRIVILEGED.getProperty(name, def) : Actions.PRIVILEGED.getProperty(name, def);
        return value;
    }

    static interface Actions {
        public static final Actions NON_PRIVILEGED = new Actions(){

            public String getProperty(String name) {
                return System.getProperty(name);
            }

            public String getProperty(String name, String def) {
                return System.getProperty(name, def);
            }
        };
        public static final Actions PRIVILEGED = new Actions(){

            public String getProperty(String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction(this, name){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$name = val$name;
                    }

                    public Object run() {
                        return System.getProperty(this.val$name);
                    }
                });
            }

            public String getProperty(String name, String def) {
                return (String)AccessController.doPrivileged(new PrivilegedAction(this, name, def){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ String val$def;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$name = val$name;
                        this.val$def = val$def;
                    }

                    public Object run() {
                        return System.getProperty(this.val$name, this.val$def);
                    }
                });
            }
        };

        public String getProperty(String var1);

        public String getProperty(String var1, String var2);
    }
}

