/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.deploy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class JBossDeployMojo
extends AbstractMojo {
    private static String fileSep = System.getProperty("file.separator");
    protected MavenProject project;
    private Scm scm;
    private List licenses;
    protected List pluginComponents;
    protected Properties projectProperties;
    private List pluginArtifacts;
    private File targetDirectory;
    private Artifact projectArtifact;
    private String jbossDeployRoot;
    private Map importsParam;
    private List exportsParam;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing JBoss deploy plugin");
        if (!this.project.getPackaging().equals("jar")) {
            this.getLog().info((CharSequence)("Ignoring project with packaging type: " + this.project.getPackaging()));
            return;
        }
        String artifactFileName = this.project.getArtifactId() + "." + this.project.getPackaging();
        String artifactFilePath = this.targetDirectory.toString() + fileSep + artifactFileName;
        String artifactSourcesFilePath = this.targetDirectory.toString() + fileSep + this.project.getArtifactId() + "-sources" + "." + this.project.getPackaging();
        String artifactJavadocFilePath = this.targetDirectory.toString() + fileSep + this.project.getArtifactId() + "-javadoc" + "." + this.project.getPackaging();
        String artifactTestsFilePath = this.targetDirectory.toString() + fileSep + this.project.getArtifactId() + "-tests" + "." + this.project.getPackaging();
        String deployToPath = this.jbossDeployRoot + fileSep + this.project.getGroupId() + fileSep + this.project.getArtifactId() + fileSep + this.project.getVersion() + fileSep;
        InputStream templateInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("component-info-template.txt");
        if (templateInputStream == null) {
            this.getLog().error((CharSequence)"Unable to load template file");
            return;
        }
        StringBuffer compInfoTemplate = new StringBuffer(1000);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(templateInputStream));
            char[] buf = new char[1000];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                compInfoTemplate.append(String.valueOf(buf, 0, numRead));
            }
            reader.close();
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"Unable to load component info template.");
            this.getLog().error((CharSequence)ioe.toString());
            throw new MojoExecutionException(ioe.getMessage());
        }
        String componentId = this.project.getGroupId() + "/" + this.project.getArtifactId();
        this.evaluateVariable(compInfoTemplate, "project.name", componentId + "-component-info");
        this.evaluateVariable(compInfoTemplate, "component.id", componentId);
        this.evaluateVariable(compInfoTemplate, "project.version", this.project.getVersion());
        if (this.licenses.size() == 0) {
            this.getLog().warn((CharSequence)"No license specified in pom.xml.  Default lgpl license will be used.");
            this.evaluateVariable(compInfoTemplate, "project.license", "lgpl");
        } else {
            License firstLicense = (License)this.licenses.get(0);
            this.evaluateVariable(compInfoTemplate, "project.license", firstLicense.getName());
        }
        if (this.project.getDescription() == null || this.project.getDescription().equals("")) {
            this.project.setDescription(this.project.getId());
        }
        this.evaluateVariable(compInfoTemplate, "project.description", this.project.getDescription());
        if (this.scm == null || this.scm.getConnection() == null) {
            this.evaluateVariable(compInfoTemplate, "project.scm", "");
        } else {
            String scmConnStr = this.scm.getConnection().replaceFirst("scm:", "");
            this.evaluateVariable(compInfoTemplate, "project.scm", "scm=\"" + scmConnStr + "\"");
        }
        StringBuffer artifacts = new StringBuffer();
        artifacts.append("    <artifact id=\"" + artifactFileName + "\"/>\n");
        if (new File(artifactTestsFilePath).exists()) {
            artifacts.append("    <artifact id=\"" + this.project.getArtifactId() + "-tests." + this.project.getPackaging() + "\"/>\n");
        }
        if (new File(artifactSourcesFilePath).exists()) {
            artifacts.append("    <artifact id=\"" + this.project.getArtifactId() + "-sources." + this.project.getPackaging() + "\"/>\n");
        }
        if (new File(artifactJavadocFilePath).exists()) {
            artifacts.append("    <artifact id=\"" + this.project.getArtifactId() + "-javadoc." + this.project.getPackaging() + "\"/>\n");
        }
        this.evaluateVariable(compInfoTemplate, "artifacts", artifacts.toString());
        StringBuffer includes = new StringBuffer();
        includes.append("      <include input=\"" + artifactFileName + "\"/>");
        this.evaluateVariable(compInfoTemplate, "includes", includes.toString());
        if (this.importsParam == null) {
            this.evaluateVariable(compInfoTemplate, "imports", "");
        } else {
            StringBuffer imports = new StringBuffer();
            Set componentNames = this.importsParam.keySet();
            for (Object component : componentNames) {
                imports.append("    <import componentref=\"" + component + "\">\n");
                imports.append("      <compatible version=\"" + this.importsParam.get(component) + "\"/>\n");
                imports.append("    </import>\n");
            }
            this.evaluateVariable(compInfoTemplate, "imports", imports.toString());
        }
        try {
            File deployToDir = new File(deployToPath);
            if (!deployToDir.exists()) {
                deployToDir.mkdirs();
            }
            File compInfoFile = new File(deployToPath + "component-info.xml");
            FileWriter fw = new FileWriter(compInfoFile);
            fw.write(compInfoTemplate.toString());
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.getLog().debug((CharSequence)("Copying from: " + artifactFilePath));
        this.getLog().info((CharSequence)("Deploying to: " + deployToPath));
        String deployToPathLib = deployToPath + "lib" + fileSep;
        try {
            this.copyFileToDir(artifactFilePath, deployToPathLib);
            this.copyFileToDir(artifactTestsFilePath, deployToPathLib);
            this.copyFileToDir(artifactSourcesFilePath, deployToPathLib);
            this.copyFileToDir(artifactJavadocFilePath, deployToPathLib);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Problem copying artifacts: " + ioe.getMessage());
        }
    }

    public void copyFileToDir(String src, String dest) throws IOException {
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            return;
        }
        File destDir = new File(dest);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = new File(destDir.getCanonicalPath() + fileSep + srcFile.getName());
        FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
        FileChannel dstChannel = new FileOutputStream(destFile).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
        this.getLog().debug((CharSequence)("Copied to file: " + destFile.getCanonicalPath()));
    }

    public void evaluateVariable(StringBuffer buffer, String var, String value) {
        int start = 0;
        while ((start = buffer.indexOf("${" + var + "}")) != -1) {
            int end = start + ("${" + var + "}").length();
            buffer.replace(start, end, value);
        }
    }
}

