/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.deploy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class JBossDeployMojo
extends AbstractMojo {
    private static String fileSep = System.getProperty("file.separator");
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private Scm scm;
    private List licenses;
    protected List pluginComponents;
    protected Properties projectProperties;
    private List pluginArtifacts;
    private File targetDirectory;
    private Artifact projectArtifact;
    private String jbossDeployRoot;
    private Map imports;
    private List exports;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing JBoss deploy plugin");
        File deployToDir = new File(this.jbossDeployRoot + fileSep + this.project.getGroupId() + fileSep + this.project.getArtifactId() + fileSep + this.project.getVersion() + fileSep);
        File deployToLibDir = new File(deployToDir.getAbsolutePath() + fileSep + "lib" + fileSep);
        InputStream templateInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("component-info-template.txt");
        if (templateInputStream == null) {
            this.getLog().error((CharSequence)"Unable to load template file");
            return;
        }
        StringBuffer compInfoTemplate = new StringBuffer();
        try {
            compInfoTemplate.append(IOUtils.toString((InputStream)templateInputStream));
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"Unable to load component info template.");
            this.getLog().error((CharSequence)ioe.toString());
            throw new MojoExecutionException(ioe.getMessage());
        }
        String componentId = this.project.getGroupId() + "/" + this.project.getArtifactId();
        this.evaluateVariable(compInfoTemplate, "project.name", componentId + "-component-info");
        this.evaluateVariable(compInfoTemplate, "component.id", componentId);
        this.evaluateVariable(compInfoTemplate, "project.version", this.project.getVersion());
        if (this.licenses.size() == 0) {
            this.getLog().warn((CharSequence)"No license specified in pom.xml.  Default lgpl license will be used.");
            this.evaluateVariable(compInfoTemplate, "project.license", "lgpl");
        } else {
            License firstLicense = (License)this.licenses.get(0);
            this.evaluateVariable(compInfoTemplate, "project.license", firstLicense.getName());
        }
        if (this.project.getDescription() == null || this.project.getDescription().equals("")) {
            this.project.setDescription(this.project.getId());
        }
        this.evaluateVariable(compInfoTemplate, "project.description", this.project.getDescription());
        if (this.scm == null || this.scm.getConnection() == null) {
            this.evaluateVariable(compInfoTemplate, "project.scm", "");
        } else {
            String scmConnStr = this.scm.getConnection().replaceFirst("scm:", "");
            this.evaluateVariable(compInfoTemplate, "project.scm", "scm=\"" + scmConnStr + "\"");
        }
        StringBuffer artifacts = new StringBuffer();
        Artifact projectArtifact = this.project.getArtifact();
        if (projectArtifact != null && projectArtifact.getFile() != null) {
            artifacts.append("    <artifact id=\"" + projectArtifact.getFile().getName() + "\"/>\n");
            try {
                FileUtils.copyFileToDirectory((File)projectArtifact.getFile(), (File)deployToLibDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        List list = this.project.getAttachedArtifacts();
        this.getLog().debug((CharSequence)("Number of artifacts: " + list.size()));
        for (Object obj : list) {
            Artifact artifact = (Artifact)obj;
            this.getLog().debug((CharSequence)artifact.getArtifactId());
            artifacts.append("    <artifact id=\"" + artifact.getArtifactId() + "-" + artifact.getClassifier() + ".jar" + "\"/>\n");
            try {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)deployToLibDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        this.evaluateVariable(compInfoTemplate, "artifacts", artifacts.toString());
        StringBuffer exportsString = new StringBuffer();
        if (this.project.getArtifact().getFile() != null) {
            exportsString.append("      <include input=\"" + this.project.getArtifact().getFile().getName() + "\"/>\n");
        }
        if (this.exports != null) {
            for (Object export : this.exports) {
                exportsString.append("      <include input=\"" + export + "\"/>\n");
            }
        }
        this.evaluateVariable(compInfoTemplate, "includes", exportsString.toString());
        if (this.imports == null) {
            this.evaluateVariable(compInfoTemplate, "imports", "");
        } else {
            StringBuffer importsString = new StringBuffer();
            Set componentNames = this.imports.keySet();
            for (Object component : componentNames) {
                importsString.append("    <import componentref=\"" + component + "\">\n");
                importsString.append("      <compatible version=\"" + this.imports.get(component) + "\"/>\n");
                importsString.append("    </import>\n");
            }
            this.evaluateVariable(compInfoTemplate, "imports", importsString.toString());
        }
        try {
            if (!deployToDir.exists()) {
                deployToDir.mkdirs();
            }
            File compInfoFile = new File(deployToDir + fileSep + "component-info.xml");
            FileWriter fw = new FileWriter(compInfoFile);
            fw.write(compInfoTemplate.toString());
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void evaluateVariable(StringBuffer buffer, String var, String value) {
        int start = 0;
        while ((start = buffer.indexOf("${" + var + "}")) != -1) {
            int end = start + ("${" + var + "}").length();
            buffer.replace(start, end, value);
        }
    }
}

