/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.zip;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class ZipMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private File outputDirectory;
    private File classesDirectory;
    private String finalName;
    private ZipArchiver zipArchiver;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private boolean forceCreation;
    private String classifier;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected String getClassifier() {
        return this.classifier;
    }

    protected File getClassesDirectory() {
        return this.classesDirectory;
    }

    protected static File getZipFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".zip");
    }

    public File createArchive() throws MojoExecutionException {
        File zipFile = ZipMojo.getZipFile(this.outputDirectory, this.finalName, this.getClassifier());
        this.zipArchiver.setDestFile(zipFile);
        this.zipArchiver.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"Zipfile will be empty - no content was marked for inclusion!");
            } else {
                this.zipArchiver.addDirectory(contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
            }
            this.zipArchiver.createArchive();
            return zipFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling zipfile", e);
        }
    }

    public void execute() throws MojoExecutionException {
        File zipFile = this.createArchive();
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "zip", classifier, zipFile);
        } else {
            this.getProject().getArtifact().setFile(zipFile);
        }
    }
}

