/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.ProducerState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.destination.JBossTemporaryQueue;
import org.jboss.jms.destination.JBossTemporaryTopic;
import org.jboss.jms.message.JBossBytesMessage;
import org.jboss.jms.message.JBossMapMessage;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.JBossObjectMessage;
import org.jboss.jms.message.JBossStreamMessage;
import org.jboss.jms.message.JBossTextMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;

public class ProducerAspect {
    private static final Logger log = Logger.getLogger(ProducerAspect.class);
    private boolean trace = log.isTraceEnabled();

    public Object handleSend(Invocation invocation) throws Throwable {
        JBossMessage messageToSend;
        MethodInvocation mi = (MethodInvocation)invocation;
        Object[] args = mi.getArguments();
        Destination destination = (Destination)args[0];
        Message m = (Message)args[1];
        int deliveryMode = (Integer)args[2];
        int priority = (Integer)args[3];
        long timeToLive = (Long)args[4];
        boolean keepID = args.length > 5 ? (Boolean)args[5] : false;
        ProducerState producerState = this.getProducerState((Invocation)mi);
        if (deliveryMode == -1) {
            deliveryMode = producerState.getDeliveryMode();
            if (this.trace) {
                log.trace((Object)("Using producer's default delivery mode: " + deliveryMode));
            }
        }
        m.setJMSDeliveryMode(deliveryMode);
        if (priority == -1) {
            priority = producerState.getPriority();
            if (this.trace) {
                log.trace((Object)("Using producer's default priority: " + priority));
            }
        }
        if (priority < 0 || priority > 9) {
            throw new MessageFormatException("Invalid message priority (" + priority + "). " + "Valid priorities are 0-9");
        }
        m.setJMSPriority(priority);
        if (producerState.isDisableMessageTimestamp()) {
            m.setJMSTimestamp(0L);
        } else {
            m.setJMSTimestamp(System.currentTimeMillis());
        }
        if (timeToLive == Long.MIN_VALUE) {
            timeToLive = producerState.getTimeToLive();
            if (this.trace) {
                log.trace((Object)("Using producer's default timeToLive: " + timeToLive));
            }
        }
        if (timeToLive == 0L) {
            m.setJMSExpiration(0L);
        } else {
            m.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (destination == null) {
            destination = producerState.getDestination();
            if (destination == null) {
                throw new UnsupportedOperationException("Destination not specified");
            }
            if (this.trace) {
                log.trace((Object)("Using producer's default destination: " + destination));
            }
        } else if (producerState.getDestination() != null && !producerState.getDestination().equals(destination)) {
            throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
        }
        if (((JBossDestination)destination).isTemporary()) {
            this.validateTemporaryDestination(destination);
        }
        SessionState sessionState = (SessionState)producerState.getParent();
        ConnectionState connectionState = (ConnectionState)sessionState.getParent();
        boolean foreign = false;
        if (!(m instanceof MessageProxy)) {
            foreign = true;
            messageToSend = m instanceof BytesMessage ? new JBossBytesMessage((BytesMessage)m, 0L) : (m instanceof MapMessage ? new JBossMapMessage((MapMessage)m, 0L) : (m instanceof ObjectMessage ? new JBossObjectMessage((ObjectMessage)m, 0L) : (m instanceof StreamMessage ? new JBossStreamMessage((StreamMessage)m, 0L) : (m instanceof TextMessage ? new JBossTextMessage((TextMessage)m, 0L) : new JBossMessage(m, 0L)))));
            messageToSend.setJMSMessageID(null);
            messageToSend.setJMSDestination(destination);
            if (connectionState.getRemotingConnection().isStrictTck()) {
                m.setJMSDestination(destination);
            }
        } else {
            MessageProxy proxy = (MessageProxy)m;
            m.setJMSDestination(destination);
            messageToSend = proxy.getMessage();
            proxy.beforeSend();
        }
        if (!keepID) {
            String id = "ID:JBM-" + UUID.randomUUID().toString();
            messageToSend.setJMSMessageID(id);
        }
        messageToSend.doBeforeSend();
        if (foreign) {
            m.setJMSMessageID(messageToSend.getJMSMessageID());
        }
        ((SessionDelegate)((Object)sessionState.getDelegate())).send(messageToSend, false);
        return null;
    }

    private void validateTemporaryDestination(Destination destination) throws InvalidDestinationException {
        if (destination instanceof JBossTemporaryTopic) {
            if (((JBossTemporaryTopic)destination).isDeleted()) {
                throw new InvalidDestinationException("Temporary topic was deleted");
            }
        } else if (destination instanceof JBossTemporaryQueue && ((JBossTemporaryQueue)destination).isDeleted()) {
            throw new InvalidDestinationException("Temporary queue was deleted");
        }
    }

    public Object handleSetDisableMessageID(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setDisableMessageID((Boolean)args[0]);
        return null;
    }

    public Object handleGetDisableMessageID(Invocation invocation) throws Throwable {
        return this.getProducerState(invocation).isDisableMessageID() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object handleSetDisableMessageTimestamp(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setDisableMessageTimestamp((Boolean)args[0]);
        return null;
    }

    public Object handleGetDisableMessageTimestamp(Invocation invocation) throws Throwable {
        return this.getProducerState(invocation).isDisableMessageTimestamp() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object handleSetDeliveryMode(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setDeliveryMode((Integer)args[0]);
        return null;
    }

    public Object handleGetDeliveryMode(Invocation invocation) throws Throwable {
        return new Integer(this.getProducerState(invocation).getDeliveryMode());
    }

    public Object handleSetPriority(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setPriority((Integer)args[0]);
        return null;
    }

    public Object handleGetPriority(Invocation invocation) throws Throwable {
        return new Integer(this.getProducerState(invocation).getPriority());
    }

    public Object handleSetTimeToLive(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setTimeToLive((Long)args[0]);
        return null;
    }

    public Object handleGetTimeToLive(Invocation invocation) throws Throwable {
        return new Long(this.getProducerState(invocation).getTimeToLive());
    }

    public Object handleGetDestination(Invocation invocation) throws Throwable {
        return this.getProducerState(invocation).getDestination();
    }

    public Object handleSetDestination(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        this.getProducerState(invocation).setDestination((Destination)args[0]);
        return null;
    }

    public Object handleClosing(Invocation invocation) throws Throwable {
        return new Long(-1L);
    }

    public Object handleClose(Invocation invocation) throws Throwable {
        return null;
    }

    private ProducerState getProducerState(Invocation inv) {
        return (ProducerState)((DelegateSupport)inv.getTargetObject()).getState();
    }
}

