/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.pojo.annotation.Reentrant;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.AopUtil;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reentrant
public class CachedSetImpl
extends AbstractSet
implements Advised {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private AbstractCollectionInterceptor interceptor;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.cache.pojo.collection.CachedSetImpl"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_toString6853976482757027775;
    private static WeakReference aop$MethodInfo_hashCode2593808613140459179;

    public CachedSetImpl(PojoCacheImpl cache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    @Override
    public boolean add(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size + 1; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                this.attach(key, o, true);
                return true;
            }
            if (!o.equals(o2)) continue;
            return false;
        }
        throw new CacheException();
    }

    @Override
    public void clear() {
        Set<Node> children = this.getNodeChildren();
        for (Node n : children) {
            this.pojoCache.detach(n.getFqn());
        }
    }

    @Override
    public boolean contains(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                return false;
            }
            if (!o.equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        Node node = this.cache.getRoot().getChild(this.getFqn());
        if (node == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return new IteratorImpl(node);
    }

    @Override
    public boolean remove(Object o) {
        String key;
        Object o2;
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        boolean removed = false;
        String oldkey = null;
        for (int i = 0; i < size && (o2 = this.getNoUnmask(key = this.toLong(hashCode, i))) != null; ++i) {
            if (removed) {
                this.detach(key);
                this.attach(oldkey, o2);
            }
            if (o.equals(o2)) {
                this.detach(key, true);
                removed = true;
            }
            oldkey = key;
        }
        return removed;
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    @Override
    public String toString() {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_toString6853976482757027775.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            toString_6853976482757027775 toString_68539764827570277752 = new toString_6853976482757027775(methodInfo, interceptorArray);
            toString_68539764827570277752.setTargetObject(this);
            toString_68539764827570277752.typedTargetObject = this;
            toString_68539764827570277752.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (String)toString_68539764827570277752.invokeNext();
        }
        return this.org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop();
    }

    private String toLong(long hashCode, long count) {
        long key = hashCode & 0xFFFFL | count << 32;
        return Long.toHexString(key);
    }

    private Object attach(Object key, Object pojo) {
        return this.attach(key, pojo, false);
    }

    private Object attach(Object key, Object pojo, boolean add) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        Object o = this.pojoCache.attach(fqn, pojo);
        if (add) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"ADD");
        }
        return o;
    }

    private Object detach(Object key) {
        return this.detach(key, false);
    }

    private Object detach(Object key, boolean remove) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        if (remove) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"REMOVE");
        }
        return this.pojoCache.detach(fqn);
    }

    private Object getNoUnmask(Object key) {
        return this.pojoCache.getObject(AopUtil.constructFqn(this.getFqn(), key));
    }

    @Override
    public int hashCode() {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_hashCode2593808613140459179.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            hashCode_2593808613140459179 hashCode_25938086131404591792 = new hashCode_2593808613140459179(methodInfo, interceptorArray);
            hashCode_25938086131404591792.setTargetObject(this);
            hashCode_25938086131404591792.typedTargetObject = this;
            hashCode_25938086131404591792.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)hashCode_25938086131404591792.invokeNext();
        }
        return this.org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return super.equals(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        CachedSetImpl cachedSetImpl = this;
        synchronized (cachedSetImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        CachedSetImpl cachedSetImpl = this;
        synchronized (cachedSetImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    public String org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[").append(key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public int org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop() {
        int result = super.hashCode();
        result = 29 * result + this.cache.hashCode();
        result = 29 * result + this.interceptor.hashCode();
        return result;
    }

    private class IteratorImpl
    implements Iterator {
        private Iterator<NodeSPI> iterator;
        private Node node;
        private Object o;

        private IteratorImpl(Node node) {
            HashSet children = new HashSet(((NodeSPI)node).getChildrenDirect());
            this.iterator = children.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.node = (Node)this.iterator.next();
            this.o = Null.toNullValue(CachedSetImpl.this.pojoCache.getObject(this.node.getFqn()));
            return this.o;
        }

        public void remove() throws IllegalStateException {
            if (this.node == null) {
                throw new IllegalStateException();
            }
            CachedSetImpl.this.remove(this.o);
        }
    }

    public static class toString_6853976482757027775
    extends MethodInvocation
    implements Untransformable {
        public CachedSetImpl typedTargetObject;

        public toString_6853976482757027775(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public toString_6853976482757027775(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public toString_6853976482757027775(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public toString_6853976482757027775() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop();
        }

        public Invocation copy() {
            toString_6853976482757027775 toString_68539764827570277752 = new toString_6853976482757027775(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            toString_68539764827570277752.arguments = this.arguments;
            ((InvocationBase)toString_68539764827570277752).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)toString_68539764827570277752).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)toString_68539764827570277752).instanceResolver = ((InvocationBase)this).instanceResolver;
            toString_68539764827570277752.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)toString_68539764827570277752).targetObject = ((InvocationBase)this).targetObject;
            return toString_68539764827570277752;
        }
    }

    public static class hashCode_2593808613140459179
    extends MethodInvocation
    implements Untransformable {
        public CachedSetImpl typedTargetObject;

        public hashCode_2593808613140459179(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public hashCode_2593808613140459179(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public hashCode_2593808613140459179(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public hashCode_2593808613140459179() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop());
        }

        public Invocation copy() {
            hashCode_2593808613140459179 hashCode_25938086131404591792 = new hashCode_2593808613140459179(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            hashCode_25938086131404591792.arguments = this.arguments;
            ((InvocationBase)hashCode_25938086131404591792).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)hashCode_25938086131404591792).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)hashCode_25938086131404591792).instanceResolver = ((InvocationBase)this).instanceResolver;
            hashCode_25938086131404591792.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)hashCode_25938086131404591792).targetObject = ((InvocationBase)this).targetObject;
            return hashCode_25938086131404591792;
        }
    }
}

