/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.demo;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.cache.demo.CacheModelDelegate;
import org.jboss.cache.demo.JBossCacheGUI;
import org.jboss.cache.notifications.annotation.CacheListener;

@CacheListener
public class PojoCacheGUI
extends JBossCacheGUI {
    public PojoCacheGUI(CacheModelDelegate cacheDelegate, boolean useConsole) throws Exception {
        super(cacheDelegate, useConsole);
    }

    protected String getWelcomeMessage() {
        return "Welcome to the BeanShell console.\n\nThis console gives you a direct shell interface to the GUI above and allows you to manipulate the pojo cache directly. Some of the variables initialised in this shell session are:\n\n// an instance of org.jboss.cache.pojo\n    PojoCache cache;\n// the transaction manager registered with the cache\n    TransactionManager transactionManager;\n";
    }

    protected void configureInterpreter(Interpreter interpreter, CacheModelDelegate cacheDelegate) throws EvalError {
        interpreter.getNameSpace().importPackage("org.jboss.cache");
        interpreter.getNameSpace().importPackage("org.jboss.cache.pojo");
        interpreter.getNameSpace().importPackage("org.jboss.cache.transaction");
        interpreter.getNameSpace().importPackage("org.jboss.cache.pojo.test");
        interpreter.set("cache", cacheDelegate.getCacheShellVariable());
        interpreter.set("transactionManager", (Object)cacheDelegate.getGenericCache().getConfiguration().getRuntimeConfig().getTransactionManager());
    }

    protected void populateTable(Map data) {
        this.clearTable();
        if (data == null) {
            return;
        }
        int num_rows = data.size();
        if (num_rows > 0) {
            TreeMap sortedMap = new TreeMap(data);
            for (Map.Entry entry : sortedMap.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                this.getTableModel().addRow(new Object[]{key, val});
            }
            this.getTableModel().fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }
}

