/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.cache.pojo.memory.FieldPersistentReference;
import org.jboss.cache.pojo.util.AopUtil;

class AdvisedPojoHandler {
    private final Log log = LogFactory.getLog(AdvisedPojoHandler.class);
    private Cache<Object, Object> cache_;
    private PojoCacheImpl pCache_;
    private PojoUtil util_;

    public AdvisedPojoHandler(PojoCacheImpl pCache, InternalHelper internal, PojoUtil util) {
        this.pCache_ = pCache;
        this.cache_ = this.pCache_.getCache();
        this.util_ = util;
    }

    public Object get(Fqn fqn, Class clazz, PojoInstance pojoInstance) throws CacheException {
        CachedType type = this.pCache_.getCachedType(clazz);
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new CacheException("failed creating instance of " + clazz.getName(), (Throwable)e);
        }
        InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
        CacheFieldInterceptor interceptor = new CacheFieldInterceptor(this.pCache_, fqn, type);
        interceptor.setAopInstance(pojoInstance);
        this.util_.attachInterceptor(obj, advisor, interceptor);
        return obj;
    }

    void put(Fqn fqn, Fqn referencingFqn, Object obj) throws CacheException {
        CachedType type = this.pCache_.getCachedType(obj.getClass());
        InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
        if (advisor == null) {
            advisor = new ClassInstanceAdvisor(obj);
            ((Advised)obj)._setInstanceAdvisor(advisor);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PojoInstance pojoInstance = InternalHelper.initializeAopInstance(referencingFqn);
        map.put("POJOCache.PojoInstance", pojoInstance);
        pojoInstance.setPojoClass(type.getType());
        HashMap<Field, Object> subPojoMap = new HashMap<Field, Object>();
        Iterator i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)((FieldPersistentReference)i.next()).get();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", (Throwable)e);
            }
            if (CachedType.isSimpleAttribute(field)) {
                map.put(field.getName(), value);
                continue;
            }
            subPojoMap.put(field, value);
        }
        this.cache_.getRoot().addChild(fqn).putAll(map);
        CacheFieldInterceptor interceptor = new CacheFieldInterceptor(this.pCache_, fqn, type);
        interceptor.setAopInstance(pojoInstance);
        this.util_.attachInterceptor(obj, advisor, interceptor);
        InternalHelper.setPojo(pojoInstance, obj);
        for (Object o : subPojoMap.keySet()) {
            Field field = (Field)o;
            Object value = subPojoMap.get(field);
            if (value == null) continue;
            this.pCache_.attach(fqn, value, field.getName());
            if (!(value instanceof Map) && !(value instanceof List) && !(value instanceof Set)) continue;
            Object newValue = this.pCache_.getObject(fqn, field.getName());
            this.util_.inMemorySubstitution(obj, field, newValue);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("internalPut(): inserting with fqn: " + fqn));
        }
    }

    Object remove(Fqn fqn, Object result, Class clazz) throws CacheException {
        CachedType type = this.pCache_.getCachedType(clazz);
        InstanceAdvisor advisor = ((Advised)result)._getInstanceAdvisor();
        Iterator i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)((FieldPersistentReference)i.next()).get();
            Object value = null;
            if (!CachedType.isSimpleAttribute(field)) {
                value = this.pCache_.detach(fqn, field.getName());
                if (!(value instanceof Map) && !(value instanceof List) && !(value instanceof Set)) continue;
                this.util_.inMemorySubstitution(result, field, value);
                continue;
            }
            value = this.cache_.get(fqn, (Object)field.getName());
            this.util_.inMemorySubstitution(result, field, value);
        }
        this.cache_.getRoot().getChild(fqn).clearData();
        CacheFieldInterceptor interceptor = (CacheFieldInterceptor)AopUtil.findCacheInterceptor(advisor);
        if (interceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("regularRemoveObject(): removed cache interceptor fqn: " + fqn + " interceptor: " + interceptor));
            }
            this.util_.detachInterceptor(advisor, interceptor);
        }
        return null;
    }
}

