/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profiler.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jboss.profiler.console.ProfilerControl;
import org.jboss.profiler.console.ProfilerPID;

public class ProfilerConsole {
    private static final String STRING_PAUSE = "pause";
    private static final String STRING_START = "start";
    private static final String STRING_QUIT = "quit";
    private static final String STRING_STOP = "stop";
    public static final int QUIT_COMMAND = 4;
    ProfilerControl control;
    int port;

    public ProfilerConsole(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMenu() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println();
            Iterator iter = this.control.getHash().values().iterator();
            System.out.println("PIDs");
            while (iter.hasNext()) {
                ProfilerPID iterPid = (ProfilerPID)iter.next();
                System.out.println("PID =>" + iterPid.getPid() + " (" + iterPid.getActiveCommand() + ")");
            }
            System.out.println("Usage:");
            System.out.println("quit - finish console");
            System.out.println("start <pid> - starts the profiler");
            System.out.println("stop <pid>  - stops the profiler");
            System.out.println("pause <pid> - pauses the profiler (it can be restared with start)");
            System.out.println();
            System.out.print("?");
        }
    }

    private String[] token(String string) {
        boolean isQuit;
        StringTokenizer tokenizer = new StringTokenizer(string, " ");
        String[] tokens = new String[2];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i++] = tokenizer.nextToken().trim();
        }
        boolean bl = isQuit = i == 1 && tokens[0].trim().equals(STRING_QUIT);
        if (i != 2 && !isQuit) {
            return null;
        }
        return tokens;
    }

    private int getCommand(String command) {
        if (command.equals(STRING_QUIT)) {
            return 4;
        }
        if (command.equals(STRING_START)) {
            return 1;
        }
        if (command.equals(STRING_STOP)) {
            return 3;
        }
        if (command.equals(STRING_PAUSE)) {
            return 2;
        }
        return -1;
    }

    public void doConsole() throws IOException {
        this.control = new ProfilerControl(this, this.port);
        Thread threadControl = new Thread(this.control);
        threadControl.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String strLine = null;
        while (true) {
            this.printMenu();
            strLine = input.readLine();
            String[] tokens = this.token(strLine);
            if (tokens == null) {
                System.out.println("Invalid parameters!");
                continue;
            }
            int command = this.getCommand(tokens[0]);
            if (command < 0) {
                System.out.println("Invalid command");
                continue;
            }
            if (command == 4) {
                System.out.println("Datacapturing quit");
                System.exit(0);
            }
            Integer pid = new Integer(tokens[1]);
            ProfilerPID profilerPid = (ProfilerPID)this.control.getHash().get(pid);
            profilerPid.executeCommand(tokens[0], command);
            System.out.println("changed to " + command + " - " + profilerPid);
        }
    }

    public static void main(String[] arg) {
        try {
            if (arg.length == 0) {
                System.out.println("Usage: java -jar profilerConsole.jar port");
                System.exit(-1);
            }
            int port = Integer.parseInt(arg[0]);
            ProfilerConsole console = new ProfilerConsole(port);
            console.doConsole();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

