/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.logging.Logger;
import org.jboss.remoting.security.CustomSSLServerSocketFactory;
import org.jboss.remoting.security.CustomSSLSocketFactory;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.util.socket.RemotingKeyManager;

public class SSLSocketBuilder
implements SSLSocketBuilderMBean,
Cloneable {
    public static final String REMOTING_SSL_PROVIDER_NAME = "org.jboss.remoting.sslProviderName";
    public static final String REMOTING_SSL_PROTOCOL = "org.jboss.remoting.sslProtocol";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String REMOTING_SOCKET_USE_CLIENT_MODE = "org.jboss.remoting.socket.useClientMode";
    public static final String REMOTING_SERVER_SOCKET_USE_CLIENT_MODE = "org.jboss.remoting.serversocket.useClientMode";
    public static final String REMOTING_CLIENT_AUTH_MODE = "org.jboss.remoting.clientAuthMode";
    public static final String CLIENT_AUTH_MODE_NONE = "none";
    public static final String CLIENT_AUTH_MODE_WANT = "want";
    public static final String CLIENT_AUTH_MODE_NEED = "need";
    public static final String REMOTING_SERVER_AUTH_MODE = "org.jboss.remoting.serverAuthMode";
    public static final String REMOTING_KEY_STORE_FILE_PATH = "org.jboss.remoting.keyStore";
    public static final String REMOTING_KEY_STORE_TYPE = "org.jboss.remoting.keyStoreType";
    public static final String REMOTING_KEY_STORE_ALGORITHM = "org.jboss.remoting.keyStoreAlgorithm";
    public static final String REMOTING_KEY_STORE_PASSWORD = "org.jboss.remoting.keyStorePassword";
    public static final String REMOTING_KEY_ALIAS = "org.jboss.remoting.keyAlias";
    public static final String REMOTING_KEY_PASSWORD = "org.jboss.remoting.keyPassword";
    public static final String STANDARD_KEY_STORE_FILE_PATH = "javax.net.ssl.keyStore";
    public static final String STANDARD_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String STANDARD_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    public static final String DEFAULT_KEY_STORE_ALGORITHM = "SunX509";
    public static final String REMOTING_TRUST_STORE_FILE_PATH = "org.jboss.remoting.trustStore";
    public static final String REMOTING_TRUST_STORE_TYPE = "org.jboss.remoting.trustStoreType";
    public static final String REMOTING_TRUST_STORE_ALGORITHM = "org.jboss.remoting.trustStoreAlgorithm";
    public static final String REMOTING_TRUST_STORE_PASSWORD = "org.jboss.remoting.trustStorePassword";
    public static final String STANDARD_TRUST_STORE_FILE_PATH = "javax.net.ssl.trustStore";
    public static final String STANDARD_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String STANDARD_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String REMOTING_DEFAULT_SOCKET_FACTORY_CLASS = "org.jboss.remoting.defaultSocketFactory";
    private SSLContext sslContextServerSocketFactory = null;
    private SSLContext sslContextSocketFactory = null;
    private Provider provider = null;
    private String providerName = null;
    private String secureSocketProtocol = null;
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    private SecureRandom secureRandom = null;
    private URL keyStoreFilePath = null;
    private String keyStoreType = null;
    private String keyStoreAlgorithm = null;
    private String keyStorePassword = null;
    private String keyAlias = null;
    private String keyPassword = null;
    private URL trustStoreFilePath = null;
    private String trustStoreType = null;
    private String trustStoreAlgorithm = null;
    private String trustStorePassword = null;
    private Map config = null;
    private Boolean socketUseClientMode = null;
    private Boolean serverSocketUseClientMode = null;
    private String clientAuthMode = null;
    private Boolean serverAuthMode = null;
    private boolean useSSLServerSocketFactory = true;
    private boolean useSSLSocketFactory = true;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$security$SSLSocketBuilder == null ? (class$org$jboss$remoting$security$SSLSocketBuilder = SSLSocketBuilder.class$("org.jboss.remoting.security.SSLSocketBuilder")) : class$org$jboss$remoting$security$SSLSocketBuilder));
    static /* synthetic */ Class class$org$jboss$remoting$security$SSLSocketBuilder;

    public SSLSocketBuilder() {
        this(null);
    }

    public SSLSocketBuilder(Map config) {
        this.config = config;
    }

    public void setUseSSLServerSocketFactory(boolean shouldUse) {
        this.useSSLServerSocketFactory = shouldUse;
    }

    public boolean getUseSSLServerSocketFactory() {
        return this.useSSLServerSocketFactory;
    }

    public void setUseSSLSocketFactory(boolean shouldUse) {
        this.useSSLSocketFactory = shouldUse;
    }

    public boolean getUseSSLSocketFactory() {
        return this.useSSLSocketFactory;
    }

    public ServerSocketFactory createSSLServerSocketFactory() throws IOException {
        return this.createSSLServerSocketFactory(null);
    }

    public ServerSocketFactory createSSLServerSocketFactory(CustomSSLServerSocketFactory wrapper) throws IOException {
        ServerSocketFactory ssf = null;
        if (this.getUseSSLServerSocketFactory()) {
            ssf = SSLServerSocketFactory.getDefault();
        } else {
            if (wrapper == null) {
                wrapper = new CustomSSLServerSocketFactory(null, this);
            }
            ssf = this.createCustomServerSocketFactory(wrapper);
        }
        return ssf;
    }

    protected ServerSocketFactory createCustomServerSocketFactory(CustomSSLServerSocketFactory wrapper) throws IOException {
        if (this.sslContextServerSocketFactory == null) {
            this.createServerSocketFactorySSLContext();
            this.initializeServerSocketFactorySSLContext();
        }
        SSLServerSocketFactory ssf = this.sslContextServerSocketFactory.getServerSocketFactory();
        wrapper.setFactory(ssf);
        return wrapper;
    }

    public SocketFactory createSSLSocketFactory() throws IOException {
        return this.createSSLSocketFactory(null);
    }

    public SocketFactory createSSLSocketFactory(CustomSSLSocketFactory wrapper) throws IOException {
        SocketFactory sf = null;
        if (this.getUseSSLSocketFactory()) {
            String defaultFactoryName = System.getProperty(REMOTING_DEFAULT_SOCKET_FACTORY_CLASS);
            if (defaultFactoryName != null) {
                try {
                    Class sfClass = ClassLoaderUtility.loadClass(defaultFactoryName, class$org$jboss$remoting$security$SSLSocketBuilder == null ? (class$org$jboss$remoting$security$SSLSocketBuilder = SSLSocketBuilder.class$("org.jboss.remoting.security.SSLSocketBuilder")) : class$org$jboss$remoting$security$SSLSocketBuilder);
                    Method m = sfClass.getMethod("getDefault", null);
                    if (m == null) {
                        throw new RuntimeException("Could not create the socket factory " + defaultFactoryName + " because the class " + sfClass + " doesn't provide the getDefault method.");
                    }
                    sf = (SocketFactory)m.invoke(null, null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not create the socket factory " + defaultFactoryName, ex);
                }
            }
            if (sf == null) {
                sf = SSLSocketFactory.getDefault();
            }
        } else {
            if (wrapper == null) {
                wrapper = new CustomSSLSocketFactory(null, this);
            }
            sf = this.createCustomSocketFactory(wrapper);
        }
        return sf;
    }

    protected SocketFactory createCustomSocketFactory(CustomSSLSocketFactory wrapper) throws IOException {
        if (this.sslContextSocketFactory == null) {
            this.createSocketFactorySSLContext();
            this.initializeSocketFactorySSLContext();
        }
        SSLSocketFactory sf = this.sslContextSocketFactory.getSocketFactory();
        wrapper.setFactory(sf);
        return wrapper;
    }

    public SSLContext getServerSocketFactorySSLContext() {
        return this.sslContextServerSocketFactory;
    }

    public SSLContext getSocketFactorySSLContext() {
        return this.sslContextSocketFactory;
    }

    public String getSecureSocketProtocol() {
        if (this.secureSocketProtocol == null) {
            if (this.config != null) {
                this.secureSocketProtocol = (String)this.config.get(REMOTING_SSL_PROTOCOL);
            }
            if (this.secureSocketProtocol == null) {
                this.secureSocketProtocol = DEFAULT_SSL_PROTOCOL;
            }
        }
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String protocol) {
        if (protocol == null || protocol.length() <= 0) {
            throw new IllegalArgumentException("Can not set remoting socket factory with null protocol");
        }
        this.secureSocketProtocol = protocol;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getProviderName() {
        if (this.providerName == null && this.config != null) {
            this.providerName = (String)this.config.get(REMOTING_SSL_PROVIDER_NAME);
        }
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public SecureRandom getSecureRandom() {
        if (this.secureRandom != null) {
            return this.secureRandom;
        }
        this.secureRandom = new SecureRandom();
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public String getKeyStoreURL() {
        URL keyStore = this.getKeyStore();
        if (keyStore != null) {
            return keyStore.toString();
        }
        return null;
    }

    public URL getKeyStore() {
        String path;
        if (this.keyStoreFilePath != null) {
            return this.keyStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get(REMOTING_KEY_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setKeyStoreURL(path);
        }
        if (this.keyStoreFilePath == null && (path = System.getProperty(STANDARD_KEY_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setKeyStoreURL(path);
        }
        return this.keyStoreFilePath;
    }

    public void setKeyStoreURL(String keyStoreFilePath) {
        try {
            this.keyStoreFilePath = this.validateStoreURL(keyStoreFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot validate the store URL: " + keyStoreFilePath, e);
        }
    }

    public void setKeyStore(URL keyStore) {
        this.keyStoreFilePath = keyStore;
    }

    public String getKeyStoreType() {
        String type;
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        if (this.config != null && (type = (String)this.config.get(REMOTING_KEY_STORE_TYPE)) != null && type.length() > 0) {
            this.keyStoreType = type;
        }
        if (this.keyStoreType == null) {
            this.keyStoreType = System.getProperty(STANDARD_KEY_STORE_TYPE);
            if (this.keyStoreType == null) {
                this.keyStoreType = DEFAULT_KEY_STORE_TYPE;
            }
        }
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreAlgorithm() {
        String alg;
        if (this.keyStoreAlgorithm != null) {
            return this.keyStoreAlgorithm;
        }
        if (this.config != null && (alg = (String)this.config.get(REMOTING_KEY_STORE_ALGORITHM)) != null && alg.length() > 0) {
            this.keyStoreAlgorithm = alg;
        }
        if (this.keyStoreAlgorithm == null) {
            this.keyStoreAlgorithm = DEFAULT_KEY_STORE_ALGORITHM;
        }
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String algorithm) {
        this.keyStoreAlgorithm = algorithm;
    }

    public String getKeyStorePassword() {
        String passwd;
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(REMOTING_KEY_STORE_PASSWORD)) != null && passwd.length() > 0) {
            this.keyStorePassword = passwd;
        }
        if (this.keyStorePassword == null) {
            this.keyStorePassword = System.getProperty(STANDARD_KEY_STORE_PASSWORD);
        }
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreURL() {
        URL trustStore = this.getTrustStore();
        if (trustStore != null) {
            return trustStore.toString();
        }
        return null;
    }

    public URL getTrustStore() {
        String path;
        if (this.trustStoreFilePath != null) {
            return this.trustStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get(REMOTING_TRUST_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setTrustStoreURL(path);
        }
        if (this.trustStoreFilePath == null && (path = System.getProperty(STANDARD_TRUST_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setTrustStoreURL(path);
        }
        return this.trustStoreFilePath;
    }

    public void setTrustStore(URL trustStore) {
        this.trustStoreFilePath = trustStore;
    }

    public void setTrustStoreURL(String trustStoreFilePath) {
        try {
            this.trustStoreFilePath = this.validateStoreURL(trustStoreFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot validate the store URL: " + trustStoreFilePath, e);
        }
    }

    public String getTrustStoreType() {
        String type;
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        if (this.config != null && (type = (String)this.config.get(REMOTING_TRUST_STORE_TYPE)) != null && type.length() > 0) {
            this.trustStoreType = type;
        }
        if (this.trustStoreType == null) {
            this.trustStoreType = System.getProperty(STANDARD_TRUST_STORE_TYPE);
            if (this.trustStoreType == null) {
                this.trustStoreType = this.getKeyStoreType();
            }
        }
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreAlgorithm() {
        String alg;
        if (this.trustStoreAlgorithm != null) {
            return this.trustStoreAlgorithm;
        }
        if (this.config != null && (alg = (String)this.config.get(REMOTING_TRUST_STORE_ALGORITHM)) != null && alg.length() > 0) {
            this.trustStoreAlgorithm = alg;
        }
        if (this.trustStoreAlgorithm == null) {
            this.trustStoreAlgorithm = this.getKeyStoreAlgorithm();
        }
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String algorithm) {
        this.trustStoreAlgorithm = algorithm;
    }

    public String getTrustStorePassword() {
        String passwd;
        if (this.trustStorePassword != null) {
            return this.trustStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(REMOTING_TRUST_STORE_PASSWORD)) != null && passwd.length() > 0) {
            this.trustStorePassword = passwd;
        }
        if (this.trustStorePassword == null) {
            this.trustStorePassword = System.getProperty(STANDARD_TRUST_STORE_PASSWORD);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = this.getKeyStorePassword();
            }
        }
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyAlias() {
        if (this.keyAlias != null) {
            return this.keyAlias;
        }
        if (this.config != null) {
            this.keyAlias = (String)this.config.get(REMOTING_KEY_ALIAS);
        }
        return this.keyAlias;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String getKeyPassword() {
        String passwd;
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(REMOTING_KEY_PASSWORD)) != null && passwd.length() > 0) {
            this.keyPassword = passwd;
        }
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isSocketUseClientMode() {
        if (this.socketUseClientMode == null) {
            this.socketUseClientMode = this.config != null && this.config.containsKey(REMOTING_SOCKET_USE_CLIENT_MODE) ? Boolean.valueOf((String)this.config.get(REMOTING_SOCKET_USE_CLIENT_MODE)) : Boolean.TRUE;
        }
        return this.socketUseClientMode;
    }

    public boolean isServerSocketUseClientMode() {
        if (this.serverSocketUseClientMode == null) {
            this.serverSocketUseClientMode = this.config != null && this.config.containsKey(REMOTING_SERVER_SOCKET_USE_CLIENT_MODE) ? Boolean.valueOf((String)this.config.get(REMOTING_SERVER_SOCKET_USE_CLIENT_MODE)) : Boolean.FALSE;
        }
        return this.serverSocketUseClientMode;
    }

    public void setSocketUseClientMode(boolean useClientMode) {
        this.socketUseClientMode = useClientMode;
    }

    public void setServerSocketUseClientMode(boolean useClientMode) {
        this.serverSocketUseClientMode = useClientMode;
    }

    public boolean isClientAuthModeNone() {
        return CLIENT_AUTH_MODE_NONE.equals(this.getClientAuthMode());
    }

    public boolean isClientAuthModeWant() {
        return CLIENT_AUTH_MODE_WANT.equals(this.getClientAuthMode());
    }

    public boolean isClientAuthModeNeed() {
        return CLIENT_AUTH_MODE_NEED.equals(this.getClientAuthMode());
    }

    public String getClientAuthMode() {
        if (this.clientAuthMode == null) {
            if (this.config != null && this.config.containsKey(REMOTING_CLIENT_AUTH_MODE)) {
                this.setClientAuthMode((String)this.config.get(REMOTING_CLIENT_AUTH_MODE));
            } else {
                this.clientAuthMode = CLIENT_AUTH_MODE_NONE;
            }
        }
        return this.clientAuthMode;
    }

    public void setClientAuthMode(String mode) {
        if (mode == null || !mode.equalsIgnoreCase(CLIENT_AUTH_MODE_NONE) && !mode.equalsIgnoreCase(CLIENT_AUTH_MODE_WANT) && !mode.equalsIgnoreCase(CLIENT_AUTH_MODE_NEED)) {
            log.warn((Object)("Client authentication mode is invalid [" + mode + "]; falling back to NEED mode"));
            this.clientAuthMode = CLIENT_AUTH_MODE_NEED;
        } else {
            this.clientAuthMode = mode;
        }
    }

    public boolean isServerAuthMode() {
        if (this.serverAuthMode == null) {
            this.serverAuthMode = this.config != null && this.config.containsKey(REMOTING_SERVER_AUTH_MODE) ? Boolean.valueOf((String)this.config.get(REMOTING_SERVER_AUTH_MODE)) : Boolean.TRUE;
        }
        return this.serverAuthMode;
    }

    public void setServerAuthMode(boolean mode) {
        this.serverAuthMode = mode;
    }

    protected void createServerSocketFactorySSLContext() throws IOException {
        try {
            this.sslContextServerSocketFactory = this.getProvider() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProvider()) : (this.getProviderName() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProviderName()) : SSLContext.getInstance(this.getSecureSocketProtocol()));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error creating server socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void createSocketFactorySSLContext() throws IOException {
        try {
            this.sslContextSocketFactory = this.getProvider() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProvider()) : (this.getProviderName() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProviderName()) : SSLContext.getInstance(this.getSecureSocketProtocol()));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error creating socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void initializeServerSocketFactorySSLContext() throws IOException {
        try {
            if (this.sslContextServerSocketFactory == null) {
                this.createServerSocketFactorySSLContext();
            }
            try {
                this.keyManagers = this.loadKeyManagers();
            }
            catch (NullStoreURLException e) {
                if (this.isServerSocketUseClientMode()) {
                    this.keyManagers = null;
                    log.debug((Object)("Could not find keytore url.  " + e.getMessage()));
                }
                IOException ioe = new IOException("Can not find keystore url.");
                ioe.initCause(e);
                throw ioe;
            }
            try {
                boolean isClientMode = this.isServerSocketUseClientMode();
                this.trustManagers = this.loadTrustManagers(isClientMode);
            }
            catch (NullStoreURLException e) {
                this.trustManagers = null;
                log.debug((Object)("Could not find truststore url.  " + e.getMessage()));
            }
            this.secureRandom = this.getSecureRandom();
            this.sslContextServerSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error initializing server socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void initializeSocketFactorySSLContext() throws IOException {
        try {
            if (this.sslContextSocketFactory == null) {
                this.createSocketFactorySSLContext();
            }
            try {
                this.keyManagers = this.loadKeyManagers();
            }
            catch (NullStoreURLException e) {
                this.keyManagers = null;
                log.debug((Object)("Could not find keystore url.  " + e.getMessage()));
            }
            try {
                boolean isClientMode = this.isSocketUseClientMode();
                this.trustManagers = this.loadTrustManagers(isClientMode);
            }
            catch (NullStoreURLException e) {
                if (this.keyManagers != null) {
                    this.trustManagers = null;
                    log.debug((Object)("Could not find truststore url.  " + e.getMessage()));
                }
                IOException ioe = new IOException("Can not find truststore url.");
                ioe.initCause(e);
                throw ioe;
            }
            this.secureRandom = this.getSecureRandom();
            this.sslContextSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error initializing socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected TrustManager[] loadTrustManagers(boolean isClientMode) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, NullStoreURLException {
        if (isClientMode && !this.isServerAuthMode()) {
            this.trustManagers = new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        } else {
            String tsType = this.getTrustStoreType();
            String tsPasswd = this.getTrustStorePassword();
            URL tsPathURL = this.getTrustStore();
            String tsAlg = this.getTrustStoreAlgorithm();
            KeyStore trustStore = this.loadKeyStore(tsType, tsPathURL, tsPasswd);
            TrustManagerFactory trustMgrFactory = this.getProvider() != null ? TrustManagerFactory.getInstance(tsAlg, this.getProvider()) : (this.getProviderName() != null ? TrustManagerFactory.getInstance(tsAlg, this.getProviderName()) : TrustManagerFactory.getInstance(tsAlg));
            if (trustStore != null) {
                trustMgrFactory.init(trustStore);
                this.trustManagers = trustMgrFactory.getTrustManagers();
            }
        }
        return this.trustManagers;
    }

    protected KeyManager[] loadKeyManagers() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException, NullStoreURLException {
        URL ksPathURL;
        String ksPasswd = this.getKeyStorePassword();
        String ksType = this.getKeyStoreType();
        KeyStore keyStore = this.loadKeyStore(ksType, ksPathURL = this.getKeyStore(), ksPasswd);
        if (keyStore != null) {
            boolean containsAlias;
            String alias = this.getKeyAlias();
            if (alias != null && !(containsAlias = keyStore.isKeyEntry(alias))) {
                throw new IOException("Can not find key entry for key store (" + ksPathURL + ") with given alias (" + alias + ")");
            }
            KeyManagerFactory keyMgrFactory = null;
            String alg = this.getKeyStoreAlgorithm();
            keyMgrFactory = this.getProvider() != null ? KeyManagerFactory.getInstance(alg, this.getProvider()) : (this.getProviderName() != null ? KeyManagerFactory.getInstance(alg, this.getProviderName()) : KeyManagerFactory.getInstance(alg));
            String keyPasswd = this.getKeyPassword();
            if (keyPasswd == null || keyPasswd.length() == 0) {
                keyPasswd = ksPasswd;
            }
            keyMgrFactory.init(keyStore, keyPasswd.toCharArray());
            this.keyManagers = keyMgrFactory.getKeyManagers();
            if (alias != null) {
                for (int x = 0; x < this.keyManagers.length; ++x) {
                    this.keyManagers[x] = new RemotingKeyManager((X509KeyManager)this.keyManagers[x], alias);
                }
            }
        }
        return this.keyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(String storeType, URL storePathURL, String storePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, NullStoreURLException {
        KeyStore keyStore;
        block7: {
            keyStore = null;
            keyStore = this.getProvider() != null ? KeyStore.getInstance(storeType, this.getProvider()) : (this.getProviderName() != null ? KeyStore.getInstance(storeType, this.getProviderName()) : KeyStore.getInstance(storeType));
            if (storePathURL == null) {
                throw new NullStoreURLException("Can not find store file for url because store url is null.");
            }
            InputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = storePathURL.openStream();
                char[] password = storePassword != null ? storePassword.toCharArray() : null;
                keyStore.load(keyStoreInputStream, password);
                Object var8_7 = null;
                if (keyStoreInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    keyStoreInputStream = null;
                }
                throw throwable;
            }
            try {
                keyStoreInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            keyStoreInputStream = null;
            {
            }
        }
        return keyStore;
    }

    protected URL validateStoreURL(String storePath) throws IOException {
        URL url;
        block4: {
            url = null;
            try {
                url = new URL(storePath);
            }
            catch (MalformedURLException e) {
                File tst = new File(storePath);
                if (tst.exists()) {
                    url = tst.toURL();
                }
                if (url != null) break block4;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                url = loader.getResource(storePath);
            }
        }
        if (url == null) {
            String msg = "Failed to find url=" + storePath + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class NullStoreURLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NullStoreURLException(String message) {
            super(message);
        }
    }
}

