/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.InputMultiplexor;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.PendingAction;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;
import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;

public class MultiplexingManager
implements OutputMultiplexor.OutputMultiplexorClient,
HandshakeCompletedListener {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MultiplexingManager == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingManager = MultiplexingManager.class$("org.jboss.remoting.transport.multiplex.MultiplexingManager")) : class$org$jboss$remoting$transport$multiplex$MultiplexingManager));
    private static int staticThreadsMonitorPeriod;
    private static boolean staticThreadsRunning;
    private static Object shareableMapLock;
    private static Map shareableManagers;
    private static Object localAddressMapLock;
    private static Map managersByLocalAddress;
    private static Object remoteAddressMapLock;
    private static Map managersByRemoteAddress;
    private static Set allManagers;
    private static InputMultiplexor inputMultiplexor;
    private static OutputMultiplexor outputMultiplexor;
    private static OutputMultiplexor.OutputThread outputThread;
    private static InputMultiplexor.MultiGroupInputThread multiGroupInputThread;
    private static VirtualSelector virtualSelector;
    private static Protocol.BackChannelThread backChannelThread;
    private static List pendingActions;
    private static PendingActionThread pendingActionThread;
    private static Timer timer;
    private static boolean hasBeenIdle;
    private static final short time;
    private int shutdownRequestTimeout;
    private int shutdownMonitorPeriod;
    private int shutdownRefusalsMaximum;
    private static Map configuration;
    private Map socketMap = Collections.synchronizedMap(new HashMap());
    private Set registeredSockets = Collections.synchronizedSet(new HashSet());
    private Map outputStreamMap = Collections.synchronizedMap(new HashMap());
    private Map inputStreamMap = Collections.synchronizedMap(new HashMap());
    private Set outputStreamSet = Collections.synchronizedSet(new HashSet());
    private OutputStream backchannelOutputStream;
    private Set threadsWaitingForRemoteServerSocket = new HashSet();
    private Protocol protocol;
    private Socket socket;
    String description;
    private boolean bound = false;
    private boolean connected = false;
    private InetSocketAddress remoteSocketAddress;
    private InetSocketAddress localSocketAddress;
    private InetSocketAddress localWildCardAddress;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ServerSocket serverSocket;
    private boolean remoteServerSocketRegistered = false;
    private boolean createdForRemoteServerSocket;
    private InputMultiplexor.SingleGroupInputThread inputThread;
    private OutputStream deadLetterOutputStream = new ByteArrayOutputStream();
    private ShutdownManager shutdownManager = new ShutdownManager();
    private ShutdownThread shutdownThread;
    private boolean shutdown = false;
    private boolean trace;
    private boolean debug;
    private boolean info;
    private long id;
    private SocketFactory socketFactory;
    private HandshakeCompletedEvent handshakeCompletedEvent;
    private IOException readException;
    private IOException writeException;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingManager;

    protected static synchronized void init(Map configuration) throws IOException {
        try {
            if (staticThreadsRunning) {
                return;
            }
            log.info((Object)"starting static threads");
            outputMultiplexor = new OutputMultiplexor(configuration);
            outputThread = outputMultiplexor.getAnOutputThread();
            outputThread.setName("output:" + time);
            outputThread.setDaemon(true);
            outputThread.start();
            log.debug((Object)"started output thread");
            inputMultiplexor = new InputMultiplexor(configuration);
            multiGroupInputThread = inputMultiplexor.getaMultiGroupInputThread();
            multiGroupInputThread.setName("input:" + time);
            multiGroupInputThread.setDaemon(true);
            multiGroupInputThread.start();
            log.debug((Object)"started input thread");
            virtualSelector = new VirtualSelector();
            backChannelThread = Protocol.getBackChannelThread(virtualSelector);
            backChannelThread.setName("backchannel:" + time);
            backChannelThread.setDaemon(true);
            backChannelThread.start();
            log.debug((Object)"started backchannel thread");
            timer = new Timer(true);
            TimerTask shutdownMonitorTask = new TimerTask(){

                public void run() {
                    log.trace((Object)("allManagers.isEmpty(): " + allManagers.isEmpty()));
                    log.trace((Object)("hasBeenIdle: " + hasBeenIdle));
                    if (allManagers.isEmpty()) {
                        if (hasBeenIdle) {
                            MultiplexingManager.shutdownThreads();
                            this.cancel();
                        } else {
                            hasBeenIdle = true;
                        }
                    } else {
                        hasBeenIdle = false;
                    }
                }
            };
            timer.scheduleAtFixedRate(shutdownMonitorTask, staticThreadsMonitorPeriod, (long)staticThreadsMonitorPeriod);
            pendingActionThread = new PendingActionThread();
            pendingActionThread.setName("pending actions:" + time);
            pendingActionThread.setDaemon(true);
            pendingActionThread.start();
            log.debug((Object)"started pendingAction thread");
            staticThreadsRunning = true;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw e;
        }
    }

    protected MultiplexingManager(Map configuration) throws IOException {
        if (configuration != null) {
            MultiplexingManager.configuration.putAll(configuration);
        }
        this.socketFactory = (SocketFactory)configuration.get("multiplex.SocketFactory");
        this.id = new Date().getTime();
        this.socket = this.createSocket();
        allManagers.add(this);
        if (this.debug) {
            log.debug((Object)("new MultiplexingManager(" + this.id + "): " + this.description));
        }
    }

    protected MultiplexingManager(Socket socket, Map configuration) throws IOException {
        this.socket = socket;
        if (configuration != null) {
            MultiplexingManager.configuration.putAll(configuration);
        }
        this.id = new Date().getTime();
        this.setup();
        allManagers.add(this);
        if (this.debug) {
            log.debug((Object)("new MultiplexingManager(" + this.id + "): " + this.description));
        }
    }

    protected MultiplexingManager(InetSocketAddress address, int timeout, Map configuration) throws IOException {
        if (configuration != null) {
            MultiplexingManager.configuration.putAll(configuration);
        }
        this.socketFactory = (SocketFactory)configuration.get("multiplex.SocketFactory");
        this.id = new Date().getTime();
        this.socket = this.createSocket(address, timeout);
        this.setup();
        allManagers.add(this);
        if (this.debug) {
            log.debug((Object)("new MultiplexingManager(" + this.id + "): " + this.description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setup() throws IOException {
        this.description = this.socket.toString();
        this.trace = log.isTraceEnabled();
        this.debug = log.isDebugEnabled();
        this.info = log.isInfoEnabled();
        this.initParameters(configuration);
        Class clazz = class$org$jboss$remoting$transport$multiplex$MultiplexingManager == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingManager = MultiplexingManager.class$("org.jboss.remoting.transport.multiplex.MultiplexingManager")) : class$org$jboss$remoting$transport$multiplex$MultiplexingManager;
        synchronized (clazz) {
            if (!staticThreadsRunning) {
                MultiplexingManager.init(configuration);
            }
        }
        if (this.socket.getChannel() == null) {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        } else {
            this.inputStream = Channels.newInputStream(this.socket.getChannel());
            this.outputStream = Channels.newOutputStream(this.socket.getChannel());
            this.socket.setTcpNoDelay(false);
        }
        this.outputStreamMap.put(SocketId.DEADLETTER_SOCKET_ID, this.deadLetterOutputStream);
        this.registeredSockets.add(SocketId.PROTOCOL_SOCKET_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_CONNECT_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_VERIFY_ID);
        this.registeredSockets.add(SocketId.BACKCHANNEL_SOCKET_ID);
        this.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID, null);
        this.protocol = new Protocol(this);
        MultiplexingInputStream bcis = this.getAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID, null);
        bcis.register(virtualSelector, this);
        if (this.debug) {
            log.debug((Object)"registered backchannel input stream");
        }
        this.backchannelOutputStream = new MultiplexingOutputStream(this, SocketId.PROTOCOL_SOCKET_ID);
        outputMultiplexor.register(this);
        if (this.socket.getChannel() == null) {
            log.debug((Object)"creating single group input thread");
            if (inputMultiplexor == null) {
                inputMultiplexor = new InputMultiplexor(configuration);
            }
            this.inputThread = inputMultiplexor.getaSingleGroupInputThread(this, this.socket, this.deadLetterOutputStream);
            this.inputThread.setName(this.inputThread.getName() + ":input(" + this.description + ")");
            this.inputThread.start();
        } else {
            this.socket.getChannel().configureBlocking(false);
            multiGroupInputThread.registerSocketGroup(this);
            log.debug((Object)"registered socket group");
        }
        this.registerByLocalAddress(new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort()));
        this.registerByRemoteAddress(new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort()));
        this.bound = true;
        this.connected = true;
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).addHandshakeCompletedListener(this);
        }
    }

    protected void initParameters(Map configuration) {
        MultiplexingManager.configuration = configuration;
        staticThreadsMonitorPeriod = Multiplex.getOneParameter(configuration, "staticThreadsMonitorPeriod", "multiplex.staticThreadsMonitorPeriod", 5000);
        this.shutdownRequestTimeout = Multiplex.getOneParameter(configuration, "shutdownRequestTimeout", "multiplex.shutdownRequestTimeout", 5000);
        this.shutdownRefusalsMaximum = Multiplex.getOneParameter(configuration, "shutdownRefusalsMaximum", "multiplex.shutdownRefusalsMaximum", 5);
        this.shutdownMonitorPeriod = Multiplex.getOneParameter(configuration, "shutdownMonitorPeriod", "multiplex.shutdownMonitorPeriod", 1000);
    }

    public static MultiplexingManager getaManager(Socket socket, Map configuration) throws IOException {
        log.debug((Object)"entering getaManager(Socket socket)");
        return new MultiplexingManager(socket, configuration);
    }

    public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address) throws IOException {
        return MultiplexingManager.getaManagerByLocalAddress(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address, Map conf) throws IOException {
        log.debug((Object)"entering getaManagerByLocalAddress(InetSocketAddress address)");
        MultiplexingManager m = null;
        Object object = localAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByLocalAddress.get(address);
            if (managers != null) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (IOException e) {
                    }
                }
            }
        }
        log.debug((Object)"There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(conf);
        m.bind(address);
        return m;
    }

    public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout) throws IOException {
        return MultiplexingManager.getaManagerByRemoteAddress(address, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout, Map conf) throws IOException {
        log.debug((Object)"entering getaManagerByRemoteAddress(InetSocketAddress address)");
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        return new MultiplexingManager(address, timeout, conf);
    }

    public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout) throws IOException {
        return MultiplexingManager.getaManagerByAddressPair(remoteAddress, localAddress, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map conf) throws IOException {
        MultiplexingManager m;
        log.debug((Object)"entering getaManagerByRemoteAddress(InetSocketAddress address)");
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    if (!m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        log.debug((Object)"There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(conf);
        m.bind(localAddress);
        return m;
    }

    public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout) throws IOException {
        return MultiplexingManager.getaShareableManager(address, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout, Map conf) throws IOException {
        log.debug((Object)"entering getaShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        return new MultiplexingManager(address, timeout, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiplexingManager getAnExistingShareableManager(InetSocketAddress address, Map conf) throws IOException {
        log.debug((Object)"entering getAnExistingShareableManager()");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        return null;
    }

    public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout) throws IOException {
        return MultiplexingManager.getaShareableManagerByAddressPair(remoteAddress, localAddress, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map conf) throws IOException {
        MultiplexingManager m;
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    if (!m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        log.debug((Object)"There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(conf);
        m.bind(localAddress);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiplexingManager getAnExistingShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, Map conf) throws IOException {
        log.debug((Object)"entering getaShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (!m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug((Object)("manager shutting down: " + m));
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForShareableManager(InetSocketAddress address) throws IOException {
        log.debug((Object)"entering checkForShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            return managers != null && !managers.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        log.debug((Object)"entering checkForManagerByAddressPair()");
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (!m.localSocketAddress.equals(localAddress)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForShareableManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        log.debug((Object)"entering checkForShareableManagerByAddressPair()");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (!m.localSocketAddress.equals(localAddress)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getStaticThreadMonitorPeriod() {
        return staticThreadsMonitorPeriod;
    }

    public static void setStaticThreadsMonitorPeriod(int period) {
        staticThreadsMonitorPeriod = period;
    }

    protected static synchronized void shutdownThreads() {
        log.info((Object)"entering shutdownThreads");
        if (outputThread != null) {
            outputThread.shutdown();
        }
        if (multiGroupInputThread != null) {
            multiGroupInputThread.shutdown();
        }
        if (backChannelThread != null) {
            backChannelThread.shutdown();
        }
        if (pendingActionThread != null) {
            pendingActionThread.shutdown();
        }
        log.info((Object)"cancelling timer");
        if (timer != null) {
            timer.cancel();
        }
        while (true) {
            try {
                if (outputThread != null) {
                    outputThread.join();
                }
                if (multiGroupInputThread != null) {
                    multiGroupInputThread.join();
                }
                if (backChannelThread != null) {
                    backChannelThread.join();
                }
                if (pendingActionThread == null) break;
                pendingActionThread.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        staticThreadsRunning = false;
        log.info((Object)"static threads shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addToPendingActions(PendingAction pendingAction) {
        List list = pendingActions;
        synchronized (list) {
            pendingActions.add(pendingAction);
            pendingActions.notifyAll();
        }
    }

    public synchronized void bind(InetSocketAddress address) throws IOException {
        if (this.bound) {
            throw new IOException("socket is already bound");
        }
        if (this.socket == null) {
            this.socket = this.createSocket();
        }
        if (this.socket == null) {
            this.localSocketAddress = address;
        } else {
            this.socket.bind(address);
        }
        this.bound = true;
    }

    public synchronized void connect(InetSocketAddress address, int timeout) throws IOException {
        if (this.connected) {
            if (this.socket.getRemoteSocketAddress().equals(address)) {
                return;
            }
            throw new IOException("socket is already connected");
        }
        if (this.debug) {
            log.debug((Object)("connecting to: " + address));
        }
        if (this.socket == null) {
            this.socket = this.createSocket(address, timeout);
        } else {
            this.socket.connect(address, timeout);
        }
        this.connected = true;
        this.setup();
    }

    public synchronized MultiplexingInputStream registerServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != null && this.serverSocket != serverSocket) {
            log.error((Object)("[" + this.id + "]: " + "attempt to register a second server socket"));
            log.error((Object)("current server socket: " + this.serverSocket.toString()));
            log.error((Object)("new server socket:     " + serverSocket.toString()));
            throw new IOException("attempt to register a second server socket");
        }
        if (this.debug) {
            log.debug((Object)serverSocket.toString());
        }
        this.serverSocket = serverSocket;
        return this.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
    }

    public synchronized void unRegisterServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != serverSocket) {
            log.error((Object)"server socket attempting unregister but is not registered");
            throw new IOException("server socket is not registered");
        }
        log.debug((Object)"server socket unregistering");
        this.removeAnInputStream(SocketId.SERVER_SOCKET_ID);
        this.serverSocket = null;
        this.shutdownManager.decrementReferences();
    }

    public synchronized MultiplexingInputStream registerSocket(VirtualSocket socket) throws IOException {
        SocketId localSocketId = socket.getLocalSocketId();
        VirtualSocket currentSocket = this.socketMap.put(localSocketId, socket);
        if (currentSocket != null) {
            String errorMessage = "attempting to register socket on currently used port:" + currentSocket.getLocalVirtualPort();
            log.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        if (this.debug) {
            log.debug((Object)("registering virtual socket on port: " + localSocketId.getPort()));
        }
        this.registeredSockets.add(socket.getLocalSocketId());
        return this.getAnInputStream(localSocketId, socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unRegisterSocket(VirtualSocket socket) throws IOException {
        try {
            if (this.info) {
                log.info((Object)(this + ": entering unRegisterSocket()"));
            }
            this.shutdownManager.decrementReferences();
            SocketId localSocketId = socket.getLocalSocketId();
            if (localSocketId == null) {
                return;
            }
            VirtualSocket currentSocket = (VirtualSocket)this.socketMap.remove(localSocketId);
            if (currentSocket == null) {
                String errorMessage = "attempting to unregister unrecognized socket: " + socket.getLocalSocketId().getPort();
                log.error((Object)errorMessage);
                throw new IOException(errorMessage);
            }
            if (this.debug) {
                log.debug((Object)("unregistering virtual socket on port: " + localSocketId.getPort()));
            }
            this.registeredSockets.remove(localSocketId);
            this.removeAnInputStream(localSocketId);
            if (this.info) {
                log.info((Object)(this + ": leaving unRegisterSocket()"));
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerRemoteServerSocket() throws IOException {
        log.debug((Object)"registerRemoteServerSocket()");
        if (this.remoteServerSocketRegistered) {
            log.error((Object)"duplicate remote server socket registration");
            throw new IOException("duplicate remote server socket registration");
        }
        this.remoteServerSocketRegistered = true;
        this.registerShareable(this.remoteSocketAddress);
        Set set = this.threadsWaitingForRemoteServerSocket;
        synchronized (set) {
            this.threadsWaitingForRemoteServerSocket.notifyAll();
        }
        if (!this.createdForRemoteServerSocket) {
            this.incrementReferences();
        }
    }

    public synchronized void unRegisterRemoteServerSocket() {
        if (!this.remoteServerSocketRegistered) {
            log.error((Object)"no remote server socket is registered");
        } else {
            if (this.debug) {
                log.debug((Object)(this + ": remote VSS unregistering"));
            }
            this.remoteServerSocketRegistered = false;
            this.unregisterShareable();
            MultiplexingManager.addToPendingActions(new PendingAction(){

                void doAction() {
                    try {
                        MultiplexingManager.this.decrementReferences();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            });
        }
    }

    public void setCreatedForRemoteServerSocket() {
        this.createdForRemoteServerSocket = true;
    }

    public synchronized boolean isRemoteServerSocketRegistered() {
        return this.remoteServerSocketRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRemoteServerSocketRegistered() {
        if (this.remoteServerSocketRegistered) {
            return true;
        }
        Set set = this.threadsWaitingForRemoteServerSocket;
        synchronized (set) {
            this.threadsWaitingForRemoteServerSocket.add(Thread.currentThread());
            while (!this.remoteServerSocketRegistered) {
                try {
                    this.threadsWaitingForRemoteServerSocket.wait();
                }
                catch (InterruptedException e) {
                    log.info((Object)"interrupted waiting for registration of remote server socket");
                    if (!this.shutdown) continue;
                    this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
                    return false;
                }
            }
        }
        this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
        return true;
    }

    public void incrementReferences() throws IOException {
        this.shutdownManager.incrementReferences();
    }

    public void decrementReferences() throws IOException {
        this.shutdownManager.decrementReferences();
    }

    public Collection getAllOutputStreams() {
        return this.outputStreamMap.values();
    }

    public OutputStream getDeadLetterOutputStream() {
        return this.deadLetterOutputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public MultiplexingInputStream getAnInputStream(SocketId socketId, VirtualSocket socket) throws IOException {
        MultiplexingInputStream mis;
        if (this.debug) {
            log.debug((Object)("getAnInputStream(): " + socketId.getPort()));
        }
        if ((mis = (MultiplexingInputStream)this.inputStreamMap.get(socketId)) != null) {
            if (mis.getSocket() == null) {
                mis.setSocket(socket);
            }
            return mis;
        }
        GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
        if (pos == null) {
            pos = new GrowablePipedOutputStream();
            this.outputStreamMap.put(socketId, pos);
        }
        mis = new MultiplexingInputStream(pos, this, socket);
        this.inputStreamMap.put(socketId, mis);
        if (this.readException != null) {
            mis.setReadException(this.readException);
        }
        return mis;
    }

    public GrowablePipedOutputStream getAnOutputStream(SocketId socketId) {
        GrowablePipedOutputStream pos;
        if (this.debug) {
            log.debug((Object)("getAnOutputStream(): " + socketId.getPort()));
        }
        if ((pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId)) == null) {
            pos = new GrowablePipedOutputStream();
            this.outputStreamMap.put(socketId, pos);
        }
        return pos;
    }

    public MultiplexingOutputStream getAnOutputStream(VirtualSocket socket, SocketId socketId) {
        MultiplexingOutputStream mos = new MultiplexingOutputStream(this, socket, socketId);
        this.outputStreamSet.add(mos);
        if (this.writeException != null) {
            mos.setWriteException(this.writeException);
        }
        return mos;
    }

    public GrowablePipedOutputStream getConnectedOutputStream(SocketId socketId) throws IOException {
        MultiplexingInputStream mis;
        if (this.debug) {
            log.debug((Object)("getConnectedOutputStream(): " + socketId.getPort()));
        }
        if ((mis = (MultiplexingInputStream)this.inputStreamMap.get(socketId)) != null) {
            GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
            if (pos == null) {
                StringBuffer message = new StringBuffer();
                message.append("MultiplexingInputStream exists ").append("without matching GrowablePipedOutputStream: ").append("socketId = ").append(socketId);
                throw new IOException(message.toString());
            }
            return pos;
        }
        GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
        if (pos == null) {
            pos = new GrowablePipedOutputStream();
            this.outputStreamMap.put(socketId, pos);
        }
        mis = new MultiplexingInputStream(pos, this);
        this.inputStreamMap.put(socketId, mis);
        return pos;
    }

    public OutputStream getBackchannelOutputStream() {
        return this.backchannelOutputStream;
    }

    public HandshakeCompletedEvent getHandshakeCompletedEvent() {
        return this.handshakeCompletedEvent;
    }

    public OutputMultiplexor getOutputMultiplexor() {
        return outputMultiplexor;
    }

    public OutputStream getOutputStreamByLocalSocket(SocketId socketId) {
        return (OutputStream)this.outputStreamMap.get(socketId);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public VirtualSocket getSocketByLocalPort(SocketId socketId) {
        return (VirtualSocket)this.socketMap.get(socketId);
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.description = this.socket.toString();
        this.handshakeCompletedEvent = event;
        Object obj = configuration.get("multiplex.SSLHandshakeListener");
        if (obj != null) {
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            listener.handshakeCompleted(event);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isServerSocketRegistered() {
        return this.serverSocket != null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean isSocketRegistered(SocketId socketId) {
        return this.registeredSockets.contains(socketId);
    }

    public boolean respondToShutdownRequest() {
        return this.shutdownManager.respondToShutdownRequest();
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public int getShutdownMonitorPeriod() {
        return this.shutdownMonitorPeriod;
    }

    public int getShutdownRefusalsMaximum() {
        return this.shutdownRefusalsMaximum;
    }

    public int getShutdownRequestTimeout() {
        return this.shutdownRequestTimeout;
    }

    public void setShutdownRequestTimeout(int timeout) {
        this.shutdownRequestTimeout = timeout;
    }

    public void setShutdownRefusalsMaximum(int maximum) {
        this.shutdownRefusalsMaximum = maximum;
    }

    public void setShutdownMonitorPeriod(int period) {
        this.shutdownMonitorPeriod = period;
    }

    public synchronized void outputFlushed() {
        if (this.shutdownThread != null) {
            this.shutdownThread.setSafeToShutdown(true);
        }
        this.notifyAll();
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return super.toString();
    }

    protected Socket createSocket(InetSocketAddress endpoint, int timeout) throws IOException {
        Socket socket = null;
        if (this.localSocketAddress == null) {
            socket = this.socketFactory != null ? this.socketFactory.createSocket(endpoint.getAddress(), endpoint.getPort()) : SocketChannel.open(endpoint).socket();
        } else if (this.socketFactory != null) {
            socket = this.socketFactory.createSocket(endpoint.getAddress(), endpoint.getPort(), this.localSocketAddress.getAddress(), this.localSocketAddress.getPort());
        } else {
            socket = SocketChannel.open().socket();
            socket.bind(this.localSocketAddress);
            socket.connect(endpoint);
        }
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).addHandshakeCompletedListener(this);
        }
        socket.setSoTimeout(timeout);
        return socket;
    }

    protected Socket createSocket() throws IOException {
        Socket socket = null;
        try {
            socket = this.socketFactory != null ? this.socketFactory.createSocket() : SocketChannel.open().socket();
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).addHandshakeCompletedListener(this);
            }
        }
        catch (IOException e) {
            if ("Unconnected sockets not implemented".equals(e.getMessage())) {
                return null;
            }
            throw e;
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerByLocalAddress(InetSocketAddress address) {
        Object object = localAddressMapLock;
        synchronized (object) {
            this.localSocketAddress = address;
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)managersByLocalAddress.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managersByLocalAddress.put(address, managers);
            }
            managers.add(this);
            this.localWildCardAddress = new InetSocketAddress(address.getPort());
            managers = (HashSet<MultiplexingManager>)managersByLocalAddress.get(this.localWildCardAddress);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managersByLocalAddress.put(this.localWildCardAddress, managers);
            }
            managers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterByLocalAddress() {
        Object object = localAddressMapLock;
        synchronized (object) {
            HashSet managers = null;
            if (this.localSocketAddress != null && (managers = (HashSet)managersByLocalAddress.get(this.localSocketAddress)) != null) {
                managers.remove(this);
                if (managers.isEmpty()) {
                    managersByLocalAddress.remove(this.localSocketAddress);
                }
            }
            if (this.localWildCardAddress != null && (managers = (HashSet)managersByLocalAddress.get(this.localWildCardAddress)) != null) {
                managers.remove(this);
                if (managers.isEmpty()) {
                    managersByLocalAddress.remove(this.localWildCardAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerByRemoteAddress(InetSocketAddress address) {
        this.remoteSocketAddress = address;
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)managersByRemoteAddress.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managers.add(this);
                managersByRemoteAddress.put(address, managers);
            } else {
                managers.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterByRemoteAddress() {
        if (this.remoteSocketAddress != null) {
            Object object = remoteAddressMapLock;
            synchronized (object) {
                HashSet managers = (HashSet)managersByRemoteAddress.get(this.remoteSocketAddress);
                if (managers != null) {
                    managers.remove(this);
                    if (managers.isEmpty()) {
                        managersByRemoteAddress.remove(this.remoteSocketAddress);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerShareable(InetSocketAddress address) {
        if (this.debug) {
            log.debug((Object)("registering as shareable: " + this + ": " + address.toString()));
        }
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)shareableManagers.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managers.add(this);
                shareableManagers.put(address, managers);
            } else {
                managers.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterShareable() {
        if (this.debug) {
            log.debug((Object)("unregistering remote: " + this + ": " + this.description));
        }
        if (this.remoteSocketAddress != null) {
            Object object = shareableMapLock;
            synchronized (object) {
                HashSet managers = (HashSet)shareableManagers.get(this.remoteSocketAddress);
                if (managers != null) {
                    managers.remove(this);
                    if (managers.isEmpty()) {
                        shareableManagers.remove(this.remoteSocketAddress);
                    }
                }
            }
        }
    }

    protected void unregisterAllMaps() {
        this.unregisterByLocalAddress();
        this.unregisterByRemoteAddress();
        this.unregisterShareable();
    }

    protected void removeAnInputStream(SocketId socketId) {
        if (this.debug) {
            log.debug((Object)("entering removeAnInputStream(): " + socketId.getPort()));
        }
        InputStream is = (InputStream)this.inputStreamMap.remove(socketId);
        OutputStream os = (OutputStream)this.outputStreamMap.remove(socketId);
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ignored) {
                log.error((Object)("error closing PipedInputStream (" + this.socket.getPort() + ")"), (Throwable)ignored);
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception ignored) {
                log.error((Object)("error closing PipedOutputStream (" + this.socket.getPort() + ")"), (Throwable)ignored);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReadException(IOException e) {
        HashSet tempSet;
        this.unregisterAllMaps();
        this.notifySocketsOfException();
        if (multiGroupInputThread != null) {
            multiGroupInputThread.unregisterSocketGroup(this);
        }
        this.readException = e;
        Map map = this.inputStreamMap;
        synchronized (map) {
            tempSet = new HashSet(this.inputStreamMap.values());
        }
        Iterator it = tempSet.iterator();
        while (it.hasNext()) {
            MultiplexingInputStream is = (MultiplexingInputStream)it.next();
            is.setReadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWriteException(IOException e) {
        HashSet tempSet;
        this.unregisterAllMaps();
        this.notifySocketsOfException();
        outputMultiplexor.unregister(this);
        this.writeException = e;
        Map map = this.outputStreamMap;
        synchronized (map) {
            tempSet = new HashSet(this.outputStreamSet);
        }
        Iterator it = tempSet.iterator();
        while (it.hasNext()) {
            MultiplexingOutputStream os = (MultiplexingOutputStream)it.next();
            os.setWriteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySocketsOfException() {
        Map map = this.socketMap;
        synchronized (map) {
            Iterator it = this.socketMap.values().iterator();
            while (it.hasNext()) {
                ((VirtualSocket)it.next()).notifyOfException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEOF() {
        HashSet tempSet;
        log.debug((Object)"setEOF()");
        Map map = this.inputStreamMap;
        synchronized (map) {
            tempSet = new HashSet(this.inputStreamMap.values());
        }
        Iterator it = tempSet.iterator();
        while (it.hasNext()) {
            MultiplexingInputStream is = (MultiplexingInputStream)it.next();
            try {
                is.handleRemoteShutdown();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    protected synchronized void shutdown() {
        if (this.debug) {
            log.debug((Object)(this.description + ": entering shutdown()"));
        }
        this.shutdownThread = new ShutdownThread();
        this.shutdownThread.setName(this.shutdownThread.getName() + ":shutdown");
        this.shutdownThread.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        shareableMapLock = new Object();
        shareableManagers = new HashMap();
        localAddressMapLock = new Object();
        managersByLocalAddress = new HashMap();
        remoteAddressMapLock = new Object();
        managersByRemoteAddress = new HashMap();
        allManagers = Collections.synchronizedSet(new HashSet());
        pendingActions = new ArrayList();
        time = (short)System.currentTimeMillis();
        configuration = new HashMap();
    }

    protected static class PendingActionThread
    extends StoppableThread {
        private List pendingActionsTemp = new ArrayList();

        protected PendingActionThread() {
        }

        protected void doInit() {
            log.debug((Object)"PendingActionThread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            List list = pendingActions;
            synchronized (list) {
                while (pendingActions.isEmpty()) {
                    try {
                        pendingActions.wait();
                    }
                    catch (InterruptedException ignored) {
                        if (this.isRunning()) continue;
                        return;
                    }
                }
                this.pendingActionsTemp.addAll(pendingActions);
                pendingActions.clear();
            }
            Iterator it = this.pendingActionsTemp.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof PendingAction) {
                    ((PendingAction)o).doAction();
                    continue;
                }
                log.error((Object)("object in closePendingSockets has invalid type: " + o.getClass()));
            }
            this.pendingActionsTemp.clear();
        }

        public void shutdown() {
            log.debug((Object)"pending action thread beginning shut down");
            super.shutdown();
            this.interrupt();
        }

        protected void doShutDown() {
            log.debug((Object)"PendingActionThread shutting down");
        }
    }

    protected class ShutdownThread
    extends Thread {
        private boolean safeToShutDown;

        protected ShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String message = null;
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + ": manager shutting down"));
            }
            MultiplexingManager.this.unregisterByLocalAddress();
            MultiplexingManager.this.unregisterByRemoteAddress();
            MultiplexingManager.this.unregisterShareable();
            if (MultiplexingManager.this.socket != null) {
                try {
                    if (outputMultiplexor != null) {
                        outputMultiplexor.unregister(MultiplexingManager.this);
                        MultiplexingManager multiplexingManager = MultiplexingManager.this;
                        synchronized (multiplexingManager) {
                            while (!this.safeToShutDown) {
                                if (MultiplexingManager.this.debug) {
                                    log.debug((Object)"waiting for safe to shut down");
                                }
                                try {
                                    MultiplexingManager.this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    if (MultiplexingManager.this.socket.getChannel() == null) {
                        MultiplexingManager.this.socket.close();
                    } else {
                        message = MultiplexingManager.this.description;
                        if (multiGroupInputThread != null) {
                            multiGroupInputThread.unregisterSocketGroup(MultiplexingManager.this);
                        }
                        MultiplexingManager.this.socket.close();
                        if (MultiplexingManager.this.debug) {
                            log.debug((Object)("closed socket: " + MultiplexingManager.this.description));
                        }
                    }
                    log.debug((Object)"manager: closed socket");
                }
                catch (Exception e) {
                    log.error((Object)"manager: unable to close socket", (Throwable)e);
                }
            }
            if (MultiplexingManager.this.inputThread != null) {
                MultiplexingManager.this.inputThread.shutdown();
                try {
                    MultiplexingManager.this.inputThread.join();
                    log.debug((Object)"manager: joined input thread");
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"manager: interrupted exception waiting for read thread");
                }
            }
            MultiplexingManager.this.removeAnInputStream(SocketId.PROTOCOL_SOCKET_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID);
            MultiplexingManager.this.shutdown = true;
            if (MultiplexingManager.this.info) {
                log.info((Object)("removing from allManagers: " + MultiplexingManager.this.description + "(" + MultiplexingManager.this.id + ")"));
            }
            allManagers.remove(MultiplexingManager.this);
            if (MultiplexingManager.this.info) {
                log.info((Object)("manager shut down (: " + MultiplexingManager.this.id + "): " + message));
            }
            if (MultiplexingManager.this.debug) {
                log.debug((Object)("managers left: " + allManagers.size()));
            }
        }

        public void setSafeToShutdown(boolean safe) {
            if (MultiplexingManager.this.debug) {
                log.debug((Object)"output flushed");
            }
            this.safeToShutDown = safe;
        }
    }

    protected class ShutdownManager {
        private int referenceCount = 1;
        private boolean reserved = false;
        private boolean shutdownRequestInProgress = false;
        private boolean readyToShutdown = false;
        ShutdownMonitorTimerTask shutdownMonitorTimerTask;
        private boolean shutdown = false;
        private boolean remoteShutdown = false;
        private boolean shutdownHandled;
        private boolean requestShutdownFailed;

        protected ShutdownManager() {
        }

        public synchronized void reserveManager() throws IOException {
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.referenceCount));
            }
            while (this.shutdownRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)"interruption in ShutdownRequestThread");
                }
            }
            if (this.shutdown || this.remoteShutdown) {
                throw new IOException("manager shutting down");
            }
            this.readyToShutdown = false;
            this.reserved = true;
            if (this.shutdownMonitorTimerTask != null) {
                this.shutdownMonitorTimerTask.cancel();
            }
            this.notifyAll();
        }

        public synchronized void unreserveManager() {
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.referenceCount));
            }
            if (!this.reserved) {
                log.error((Object)("attempting to unreserve a MultiplexingManager that was not reserved: " + MultiplexingManager.this.description));
                return;
            }
            this.reserved = false;
            if (this.referenceCount == 0) {
                ++this.referenceCount;
                this.decrementReferences();
            }
        }

        public synchronized void incrementReferences() throws IOException {
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.referenceCount));
            }
            while (this.shutdownRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)"interruption in ShutdownRequestThread");
                }
            }
            if (this.shutdown || this.remoteShutdown) {
                throw new IOException("not accepting new clients");
            }
            this.readyToShutdown = false;
            this.reserved = false;
            ++this.referenceCount;
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.referenceCount));
            }
            if (this.shutdownMonitorTimerTask != null) {
                this.shutdownMonitorTimerTask.cancel();
            }
            this.notifyAll();
        }

        public synchronized void decrementReferences() {
            --this.referenceCount;
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.referenceCount));
            }
            if (this.reserved) {
                if (MultiplexingManager.this.debug) {
                    log.debug((Object)(MultiplexingManager.this.description + ": reserved == true"));
                }
                return;
            }
            if (this.referenceCount == 0) {
                this.readyToShutdown = true;
                if (MultiplexingManager.this.isConnected()) {
                    ShutdownRequestThread shutdownRequestThread = new ShutdownRequestThread();
                    shutdownRequestThread.setName(shutdownRequestThread.getName() + ":shutdownRequest:" + time);
                    shutdownRequestThread.setDaemon(true);
                    if (MultiplexingManager.this.info) {
                        log.info((Object)(MultiplexingManager.this.description + "starting ShutdownRequestThread: " + shutdownRequestThread.toString()));
                    }
                    shutdownRequestThread.start();
                    try {
                        this.wait(MultiplexingManager.this.shutdownRequestTimeout);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"interrupt in ShutdownRequestThread");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(MultiplexingManager.this.description + this.shutdown));
                        log.debug((Object)(MultiplexingManager.this.description + shutdownRequestThread.isAlive()));
                    }
                    if (this.shutdownRequestInProgress) {
                        this.shutdown = true;
                        this.shutdownRequestInProgress = false;
                    }
                } else {
                    this.shutdown = true;
                }
                if (this.shutdown) {
                    MultiplexingManager.this.shutdown();
                    this.notifyAll();
                } else {
                    this.shutdownMonitorTimerTask = new ShutdownMonitorTimerTask();
                    if (MultiplexingManager.this.info) {
                        log.info((Object)(MultiplexingManager.this.description + ": scheduling ShutdownMonitorTask: " + this.shutdownMonitorTimerTask));
                    }
                    timer.schedule((TimerTask)this.shutdownMonitorTimerTask, MultiplexingManager.this.shutdownMonitorPeriod, (long)MultiplexingManager.this.shutdownMonitorPeriod);
                }
            }
        }

        protected synchronized boolean respondToShutdownRequest() {
            if (MultiplexingManager.this.debug) {
                log.debug((Object)(MultiplexingManager.this.description + this.readyToShutdown));
                log.debug((Object)(MultiplexingManager.this.description + this.shutdown));
            }
            if (this.readyToShutdown) {
                this.remoteShutdown = true;
                if (MultiplexingManager.this.debug) {
                    log.debug((Object)(MultiplexingManager.this.description + ": respondToShutdownRequest(): set remoteShutdown to true"));
                }
            }
            return this.readyToShutdown;
        }

        protected boolean isShutdown() {
            return this.shutdown;
        }

        private class ShutdownMonitorTimerTask
        extends TimerTask {
            int count;
            boolean cancelled;

            private ShutdownMonitorTimerTask() {
            }

            public boolean cancel() {
                log.debug((Object)"cancelling ShutdownMonitorTimerTask");
                this.cancelled = true;
                return super.cancel();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (MultiplexingManager.this.debug) {
                    log.debug((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": entering ShutdownMonitorTimerTask"));
                }
                ++this.count;
                ShutdownManager shutdownManager = ShutdownManager.this;
                synchronized (shutdownManager) {
                    if (ShutdownManager.this.shutdownHandled) {
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": shutdownHandled == true"));
                        }
                        this.cancel();
                    } else if (ShutdownManager.this.shutdown) {
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": shutdown is true"));
                        }
                        ShutdownManager.this.shutdownHandled = true;
                        MultiplexingManager.this.shutdown();
                        this.cancel();
                    } else if (ShutdownManager.this.readyToShutdown && ShutdownManager.this.remoteShutdown) {
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": ShutdownMonitorTimerTask: found remoteShutdown == true"));
                        }
                        ShutdownManager.this.shutdown = true;
                        ShutdownManager.this.shutdownHandled = true;
                        MultiplexingManager.this.shutdown();
                        ShutdownManager.this.notifyAll();
                        this.cancel();
                    } else if (ShutdownManager.this.requestShutdownFailed) {
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": ShutdownMonitorTimerTask: found requestShutdownFailed == true"));
                        }
                        ShutdownManager.this.shutdown = true;
                        ShutdownManager.this.shutdownHandled = true;
                        MultiplexingManager.this.shutdown();
                        ShutdownManager.this.notifyAll();
                        this.cancel();
                    } else if (this.count > MultiplexingManager.this.shutdownRefusalsMaximum) {
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": ShutdownMonitorTimerTask: " + "shutdown refusal count exceeded maximut: " + MultiplexingManager.this.shutdownRefusalsMaximum));
                        }
                        ShutdownManager.this.shutdown = true;
                        ShutdownManager.this.shutdownHandled = true;
                        MultiplexingManager.this.shutdown();
                        ShutdownManager.this.notifyAll();
                        this.cancel();
                    } else {
                        if (ShutdownManager.this.shutdownRequestInProgress) {
                            if (MultiplexingManager.this.info) {
                                log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": shutdownRequestInProgress == true"));
                            }
                            return;
                        }
                        ShutdownRequestThread shutdownRequestThread = new ShutdownRequestThread();
                        shutdownRequestThread.setName(shutdownRequestThread.getName() + ":shutdownRequest:" + time);
                        shutdownRequestThread.setDaemon(true);
                        if (MultiplexingManager.this.info) {
                            log.info((Object)(((ShutdownManager)ShutdownManager.this).MultiplexingManager.this.description + ": starting ShutdownRequestThread: " + shutdownRequestThread.toString()));
                        }
                        shutdownRequestThread.start();
                    }
                }
            }

            public String toString() {
                return "shutdownRequest:" + time;
            }
        }

        private class ShutdownRequestThread
        extends Thread {
            public ShutdownRequestThread() {
                ShutdownManager.this.shutdownRequestInProgress = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ShutdownManager.this.shutdown = MultiplexingManager.this.protocol.requestManagerShutdown(MultiplexingManager.this.shutdownRequestTimeout * 2);
                    if (MultiplexingManager.this.info) {
                        log.info((Object)("shutdown: " + ShutdownManager.this.shutdown));
                    }
                }
                catch (SocketTimeoutException e) {
                    ShutdownManager.this.requestShutdownFailed = true;
                    log.debug((Object)"socket timeout exception in manager shutdown request");
                }
                catch (Exception e) {
                    ShutdownManager.this.requestShutdownFailed = true;
                    log.debug((Object)"i/o exception in manager shutdown request", (Throwable)e);
                }
                if (MultiplexingManager.this.info) {
                    log.info((Object)("ShutdownRequestThread.run() done: " + ShutdownManager.this.shutdown));
                }
                ShutdownManager.this.shutdownRequestInProgress = false;
                ShutdownManager shutdownManager = ShutdownManager.this;
                synchronized (shutdownManager) {
                    ShutdownManager.this.notifyAll();
                }
            }
        }
    }
}

