/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CompressingUnMarshaller
extends SerializableUnMarshaller {
    public static final String DATATYPE = "compressible";
    private UnMarshaller wrappedUnMarshaller;
    private static final long serialVersionUID = 3843451434770746776L;

    public CompressingUnMarshaller() {
    }

    public CompressingUnMarshaller(UnMarshaller unMarshaller) {
        this.wrappedUnMarshaller = unMarshaller;
    }

    public InputStream getMarshallingStream(InputStream inputStream) throws IOException {
        return inputStream;
    }

    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        GZIPInputStream gzis = new GZIPInputStream(inputStream);
        BufferedInputStream bis = new BufferedInputStream(gzis);
        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        ObjectInputStream ois = manager.createInput(bis, this.getClassLoader());
        if (this.wrappedUnMarshaller != null) {
            if (this.wrappedUnMarshaller instanceof VersionedUnMarshaller) {
                return ((VersionedUnMarshaller)this.wrappedUnMarshaller).read(ois, metadata, version);
            }
            return this.wrappedUnMarshaller.read(ois, metadata);
        }
        return super.read(ois, metadata, version);
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return new CompressingUnMarshaller(this.wrappedUnMarshaller);
    }
}

