/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;

public class ServletServerInvoker
extends WebServerInvoker
implements ServletServerInvokerMBean {
    private static final Logger log = Logger.getLogger((Class)ServletServerInvoker.class);

    public ServletServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public ServletServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected String getDefaultDataType() {
        return "http";
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        Object o = this.configuration.get("preserveLines");
        if (o != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        String requestContentType = request.getContentType();
        try {
            Object invocationResponse = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http", this.getSerializationType());
            Object obj = null;
            obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read((InputStream)inputStream, metadata, Version.getDefaultVersion()) : unmarshaller.read((InputStream)inputStream, metadata);
            inputStream.close();
            InvocationRequest invocationRequest = null;
            invocationRequest = obj instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = InetAddress.getByName(remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                invocationResponse = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                invocationResponse = null;
                response.sendError(500, "Error processing invocation request.  " + ex.getMessage());
            }
            if (invocationResponse != null) {
                response.setContentType(requestContentType);
                int iContentLength = this.getContentLength(invocationResponse);
                response.setContentLength(iContentLength);
                ServletOutputStream outputStream = response.getOutputStream();
                Marshaller marshaller = MarshalFactory.getMarshaller("http", this.getSerializationType());
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocationResponse, (OutputStream)outputStream, Version.getDefaultVersion());
                } else {
                    marshaller.write(invocationResponse, (OutputStream)outputStream);
                }
                outputStream.close();
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
    }

    public byte[] processRequest(HttpServletRequest request, byte[] requestByte, HttpServletResponse response) throws ServletException, IOException {
        String path;
        byte[] retval = new byte[]{};
        boolean isRemotingUserAgent = false;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            isRemotingUserAgent = userAgent.startsWith("JBossRemoting");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        metadata.put("MethodType", request.getMethod());
        Object o = this.configuration.get("preserveLines");
        if (o != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        if ((path = request.getPathTranslated()) != null) {
            metadata.put("Path", path);
        }
        String requestContentType = request.getContentType();
        try {
            Map responseMap;
            Object responseObject = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = this.getUnMarshaller();
            Object obj = null;
            obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(new ByteArrayInputStream(requestByte), metadata, Version.getDefaultVersion()) : unmarshaller.read(new ByteArrayInputStream(requestByte), metadata);
            inputStream.close();
            boolean isError = false;
            InvocationRequest invocationRequest = null;
            if (obj instanceof InvocationRequest) {
                invocationRequest = (InvocationRequest)obj;
                Map requestMap = invocationRequest.getRequestPayload();
                if (requestMap == null) {
                    invocationRequest.setRequestPayload(metadata);
                } else {
                    requestMap.putAll(metadata);
                }
            } else {
                invocationRequest = WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj);
            }
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = InetAddress.getByName(remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                responseObject = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                if (this.checkForNoExceptionReturn(metadata)) {
                    log.trace((Object)"Returning error message instead of Exception");
                    response.sendError(500, "Error occurred processing invocation request. ");
                    return retval;
                }
                responseObject = ex;
                isError = true;
            }
            int status = 200;
            if (responseObject != null) {
                if (isError) {
                    status = 500;
                }
            } else if (!isRemotingUserAgent || "HEAD".equals(request.getMethod())) {
                status = 204;
            }
            if ((responseMap = invocationRequest.getReturnPayload()) != null) {
                Integer handlerStatus = (Integer)responseMap.remove("ResponseCode");
                if (handlerStatus != null) {
                    status = handlerStatus;
                }
                Set entries = responseMap.entrySet();
                Iterator itr = entries.iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    response.addHeader(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            response.setStatus(status);
            if (isRemotingUserAgent && !(invocationRequest instanceof WebServerInvoker.CreatedInvocationRequest)) {
                responseObject = new InvocationResponse(invocationRequest.getSessionId(), responseObject, isError, responseMap);
            }
            if (responseObject != null) {
                String responseContentType = null;
                if (responseMap != null) {
                    responseContentType = (String)responseMap.get("Content-Type");
                }
                if (responseContentType == null) {
                    responseContentType = responseObject == null ? requestContentType : WebUtil.getContentType(responseObject);
                }
                response.setContentType(responseContentType);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Marshaller marshaller = this.getMarshaller();
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(responseObject, outputStream, Version.getDefaultVersion());
                } else {
                    marshaller.write(responseObject, outputStream);
                }
                retval = outputStream.toByteArray();
                response.setContentLength(retval.length);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
        return retval;
    }

    private boolean checkForNoExceptionReturn(Map headers) {
        Object val;
        boolean flag = false;
        if (headers != null && (val = headers.get("dont-return-exception")) != null) {
            if (val instanceof String) {
                flag = Boolean.valueOf((String)val);
            } else if (val instanceof String[]) {
                String param = ((String[])val)[0];
                flag = Boolean.valueOf(param);
            }
        }
        return flag;
    }
}

