/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;

public class SSIEcho
implements SSICommand {
    protected static final String DEFAULT_ENCODING = "entity";
    protected static final String MISSING_VARIABLE_VALUE = "(none)";

    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String encoding = DEFAULT_ENCODING;
        String errorMessage = ssiMediator.getConfigErrMsg();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            if (paramName.equalsIgnoreCase("var")) {
                String variableValue = ssiMediator.getVariableValue(paramValue, encoding);
                if (variableValue == null) {
                    variableValue = MISSING_VARIABLE_VALUE;
                }
                writer.write(variableValue);
                lastModified = System.currentTimeMillis();
                continue;
            }
            if (paramName.equalsIgnoreCase("encoding")) {
                if (this.isValidEncoding(paramValue)) {
                    encoding = paramValue;
                    continue;
                }
                ssiMediator.log("#echo--Invalid encoding: " + paramValue);
                writer.write(errorMessage);
                continue;
            }
            ssiMediator.log("#echo--Invalid attribute: " + paramName);
            writer.write(errorMessage);
        }
        return lastModified;
    }

    protected boolean isValidEncoding(String encoding) {
        return encoding.equalsIgnoreCase("url") || encoding.equalsIgnoreCase(DEFAULT_ENCODING) || encoding.equalsIgnoreCase("none");
    }
}

