/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;

public class CombinedRealm
extends RealmBase {
    private static Logger log = Logger.getLogger(CombinedRealm.class);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected List<Realm> realms = new LinkedList<Realm>();

    public void addRealm(Realm theRealm) {
        this.realms.add(theRealm);
        if (log.isDebugEnabled()) {
            sm.getString("combinedRealm.addRealm", theRealm.getInfo(), Integer.toString(this.realms.size()));
        }
    }

    public Principal authenticate(String username, byte[] credentials) {
        Principal authenticatedUser = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", username, realm.getInfo()));
            }
            if ((authenticatedUser = realm.authenticate(username, credentials)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", username, realm.getInfo()));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSucess", username, realm.getInfo()));
            break;
        }
        return authenticatedUser;
    }

    public Principal authenticate(String username, String clientDigest, String once, String nc, String cnonce, String qop, String realmName, String md5a2) {
        Principal authenticatedUser = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", username, realm.getInfo()));
            }
            if ((authenticatedUser = realm.authenticate(username, clientDigest, once, nc, cnonce, qop, realmName, md5a2)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", username, realm.getInfo()));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSucess", username, realm.getInfo()));
            break;
        }
        return authenticatedUser;
    }

    public Principal authenticate(String username, String credentials) {
        Principal authenticatedUser = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", username, realm.getInfo()));
            }
            if ((authenticatedUser = realm.authenticate(username, credentials)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", username, realm.getInfo()));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSucess", username, realm.getInfo()));
            break;
        }
        return authenticatedUser;
    }

    public void setContainer(Container container) {
        for (Realm realm : this.realms) {
            realm.setContainer(container);
        }
        super.setContainer(container);
    }

    public void start() throws LifecycleException {
        for (Realm realm : this.realms) {
            if (!(realm instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)realm)).start();
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        for (Realm realm : this.realms) {
            if (!(realm instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)realm)).stop();
        }
    }

    public Principal authenticate(X509Certificate[] certs) {
        Principal authenticatedUser = null;
        String username = null;
        if (certs != null && certs.length > 0) {
            username = certs[0].getSubjectDN().getName();
        }
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", username, realm.getInfo()));
            }
            if ((authenticatedUser = realm.authenticate(certs)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", username, realm.getInfo()));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSucess", username, realm.getInfo()));
            break;
        }
        return authenticatedUser;
    }

    protected String getName() {
        UnsupportedOperationException uoe = new UnsupportedOperationException(sm.getString("combinedRealm.getName"));
        log.error((Object)sm.getString("combinedRealm.unexpectedMethod"), (Throwable)uoe);
        throw uoe;
    }

    protected String getPassword(String username) {
        UnsupportedOperationException uoe = new UnsupportedOperationException(sm.getString("combinedRealm.getPassword"));
        log.error((Object)sm.getString("combinedRealm.unexpectedMethod"), (Throwable)uoe);
        throw uoe;
    }

    protected Principal getPrincipal(String username) {
        UnsupportedOperationException uoe = new UnsupportedOperationException(sm.getString("combinedRealm.getPrincipal"));
        log.error((Object)sm.getString("combinedRealm.unexpectedMethod"), (Throwable)uoe);
        throw uoe;
    }
}

