/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cometd.bayeux.Client;
import org.apache.cometd.bayeux.Listener;
import org.apache.cometd.bayeux.Message;
import org.apache.tomcat.bayeux.ChannelImpl;
import org.apache.tomcat.bayeux.MessageImpl;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.logging.Logger;
import org.jboss.servlet.http.HttpEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
implements Client {
    private static Logger log = Logger.getLogger(ClientImpl.class);
    public static final int SUPPORT_CALLBACK_POLL = 1;
    public static final int SUPPORT_LONG_POLL = 2;
    public static final String COMET_EVENT_ATTR = "org.apache.cometd.bayeux.client";
    protected static LinkedList<Message> EMPTY_LIST = new LinkedList();
    protected LinkedList<Message> messages = null;
    protected Queue<HttpEvent> events = new LinkedList<HttpEvent>();
    protected String id;
    protected int supportedConnTypes = 3;
    protected int desirectConnType = 2;
    protected boolean useJsonFiltered = false;
    protected boolean local;
    protected Listener listener;
    protected AtomicInteger nrofsubscriptions = new AtomicInteger(0);

    protected ClientImpl(String id, boolean local) {
        this.id = id;
        this.local = local;
        if (!local) {
            this.messages = new LinkedList();
        }
    }

    protected ClientImpl(String id, HttpEvent event) {
        this(id, false);
        this.events = new ConcurrentLinkedQueue<HttpEvent>();
        this.addCometEvent(event);
    }

    @Override
    public synchronized void deliver(Message message) {
        this.deliverInternal(null, new MessageImpl[]{(MessageImpl)message});
    }

    @Override
    public synchronized void deliver(Message[] message) {
        this.deliverInternal(null, message);
    }

    protected synchronized void deliverInternal(ChannelImpl channel, MessageImpl message) {
        this.deliverInternal(channel, new MessageImpl[]{message});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deliverInternal(ChannelImpl channel, Message[] msgs) {
        if (this.isLocal()) {
            ArrayList<Message> list = new ArrayList<Message>();
            for (int i = 0; msgs != null && i < msgs.length; ++i) {
                if (this == msgs[i].getClient()) continue;
                list.add(msgs[i]);
            }
            if (this.getListener() != null && list.size() > 0) {
                this.getListener().deliver(list.toArray(new Message[0]));
            }
        } else {
            for (int i = 0; msgs != null && i < msgs.length; ++i) {
                MessageImpl message = (MessageImpl)msgs[i];
                if (this == message.getClient()) continue;
                HttpEvent event = this.events.poll();
                boolean delivered = false;
                if (event != null) {
                    HttpEvent httpEvent = event;
                    synchronized (httpEvent) {
                        RequestBase rq = (RequestBase)event.getHttpServletRequest().getAttribute("org.apache.cometd.bayeux.last_request");
                        if (rq != null) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            try {
                                map.put("channel", message.getChannel().getId());
                                map.put("data", message);
                                JSONObject json = new JSONObject(map);
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Message instantly delivered to remote client[" + this + "] message:" + json));
                                }
                                rq.addToDeliveryQueue(this, json);
                                if (i == msgs.length - 1) {
                                    RequestBase.deliver(event, this);
                                    event.close();
                                    this.removeCometEvent(event);
                                }
                                delivered = true;
                            }
                            catch (Exception e) {
                                log.warn((Object)"Exception", (Throwable)e);
                            }
                        }
                    }
                }
                if (delivered) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Message added to queue for remote client[" + this + "] message:" + message));
                }
                this.messages.add(message);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected Listener getListener() {
        return this.listener;
    }

    @Override
    public boolean hasMessages() {
        if (this.isLocal()) {
            return false;
        }
        return this.messages.size() > 0;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public int getSupportedConnTypes() {
        return this.supportedConnTypes;
    }

    public int getDesirectConnType() {
        return this.desirectConnType;
    }

    public boolean useJsonFiltered() {
        return this.useJsonFiltered;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setSupportedConnTypes(int supportedConnTypes) {
        this.supportedConnTypes = supportedConnTypes;
    }

    public void setUseJsonFiltered(boolean useJsonFiltered) {
        this.useJsonFiltered = useJsonFiltered;
    }

    public void setDesirectConnType(int desirectConnType) {
        this.desirectConnType = desirectConnType;
    }

    public boolean supportsCallbackPoll() {
        return (this.supportedConnTypes & 1) == 1;
    }

    public boolean supportsLongPoll() {
        return (this.supportedConnTypes & 2) == 2;
    }

    public synchronized List<Message> takeMessages() {
        if (this.isLocal()) {
            return null;
        }
        if (this.messages.size() == 0) {
            return EMPTY_LIST;
        }
        LinkedList<Message> result = new LinkedList<Message>(this.messages);
        this.messages.clear();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" id=").append(this.getId());
        return buf.toString();
    }

    public boolean isSubscribed() {
        return this.nrofsubscriptions.get() > 0;
    }

    protected synchronized boolean addCometEvent(HttpEvent event) {
        boolean result = false;
        if (!this.events.contains(event)) {
            this.events.add(event);
            result = true;
        }
        event.getHttpServletRequest().setAttribute(COMET_EVENT_ATTR, (Object)this);
        return result;
    }

    protected synchronized boolean removeCometEvent(HttpEvent event) {
        boolean result = this.events.remove(event);
        event.getHttpServletRequest().removeAttribute(COMET_EVENT_ATTR);
        return result;
    }

    protected void subscribed(ChannelImpl ch) {
        this.nrofsubscriptions.addAndGet(1);
    }

    protected void unsubscribed(ChannelImpl ch) {
        this.nrofsubscriptions.addAndGet(-1);
    }

    @Override
    public void startBatch() {
    }

    @Override
    public void endBatch() {
    }
}

