/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.ServletException;
import org.apache.cometd.bayeux.Message;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.MessageImpl;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.logging.Logger;
import org.jboss.servlet.http.HttpEvent;

public abstract class RequestBase
implements BayeuxRequest {
    private static Logger log = Logger.getLogger(RequestBase.class);
    protected static final SimpleDateFormat timestampFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected TomcatBayeux tomcatBayeux;
    protected String channel;
    protected String id;
    protected String clientId;
    protected String version = null;
    protected String[] suppConnTypes = null;
    protected int suppConnTypesFlag = 0;
    protected int desiredConnTypeFlag = 0;
    protected String minVersion = null;
    protected String subscription = null;
    protected String data = null;
    protected String conType = null;
    protected LinkedHashMap<String, Object> ext = new LinkedHashMap();
    protected HttpEvent event;
    protected HashMap<String, Object> response = null;
    protected int reconnectInterval = 1000;

    protected RequestBase(TomcatBayeux tb, HttpEvent event, JSONObject jsReq) throws JSONException {
        this.tomcatBayeux = tb;
        this.event = event;
        this.channel = jsReq.optString("channel");
        this.id = jsReq.optString("id");
        this.clientId = jsReq.optString("clientId");
        this.version = jsReq.optString("version");
        this.minVersion = jsReq.optString("minimumVersion");
        this.conType = jsReq.optString("connectionType");
        this.subscription = jsReq.optString("subscription");
        this.data = jsReq.optString("data");
        this.reconnectInterval = tb.getReconnectInterval();
        if (jsReq.has("ext")) {
            JSONObject jext = jsReq.getJSONObject("ext");
            Iterator i = jext.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.ext.put(key, jext.get(key));
            }
        }
        if (jsReq.has("supportedConnectionTypes")) {
            JSONArray types = jsReq.getJSONArray("supportedConnectionTypes");
            this.suppConnTypes = new String[types.length()];
            for (int i = 0; i < types.length(); ++i) {
                this.suppConnTypes[i] = types.getString(i);
                if ("callback-polling".equals(this.suppConnTypes[i])) {
                    this.suppConnTypesFlag |= 1;
                    continue;
                }
                if (!"long-polling".equals(this.suppConnTypes[i])) continue;
                this.suppConnTypesFlag |= 2;
            }
        }
        if (this.conType != null) {
            if ("callback-polling".equals(this.conType)) {
                this.desiredConnTypeFlag = 1;
            } else if ("long-polling".equals(this.conType)) {
                this.desiredConnTypeFlag = 2;
            }
        }
        this.suppConnTypesFlag = 3;
    }

    public HttpError validate() {
        HttpError result = null;
        return result;
    }

    public TomcatBayeux getTomcatBayeux() {
        return this.tomcatBayeux;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public LinkedHashMap getExt() {
        return this.ext;
    }

    public HttpEvent getEvent() {
        return this.event;
    }

    protected static void deliver(HttpEvent event, ClientImpl to) throws IOException, ServletException, BayeuxException {
        JSONArray jarray = RequestBase.getJSONArray(event, true);
        if (jarray == null) {
            throw new BayeuxException("No message to send!");
        }
        String jsonstring = jarray.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + Thread.currentThread().getName() + "] Delivering message to[" + to + "] message:" + jsonstring));
        }
        if (to != null) {
            if (to.useJsonFiltered()) {
                if (!event.getHttpServletResponse().isCommitted()) {
                    event.getHttpServletResponse().setContentType("text/json-comment-filtered");
                }
            } else if (!event.getHttpServletResponse().isCommitted()) {
                event.getHttpServletResponse().setContentType("text/json");
            }
        }
        PrintWriter out = event.getHttpServletResponse().getWriter();
        if (to != null) {
            if (to.getDesirectConnType() == 0 && to.supportsLongPoll() || to.getDesirectConnType() == 2) {
                if (to.useJsonFiltered()) {
                    out.print("/*");
                }
            } else if (to.getDesirectConnType() == 0 && to.supportsCallbackPoll() || to.getDesirectConnType() == 1) {
                String jsonp = event.getHttpServletRequest().getParameter("jsonp");
                if (jsonp == null) {
                    jsonp = "jsonpcallback";
                }
                out.print(jsonp);
                out.print('(');
            } else {
                throw new BayeuxException("Client doesn't support any appropriate connection type.");
            }
        }
        out.print(jsonstring);
        if (to != null) {
            if (to.getDesirectConnType() == 0 && to.supportsLongPoll() || to.getDesirectConnType() == 2) {
                if (to.useJsonFiltered()) {
                    out.print("*/");
                }
            } else if (to.getDesirectConnType() == 0 && to.supportsCallbackPoll() || to.getDesirectConnType() == 1) {
                out.print(");");
            }
        }
        out.flush();
        event.getHttpServletResponse().flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JSONArray getJSONArray(HttpEvent event, boolean nullok) {
        HttpEvent httpEvent = event;
        synchronized (httpEvent) {
            JSONArray jarray = (JSONArray)event.getHttpServletRequest().getAttribute("org.apache.cometd.bayeux.json_msg_array");
            if (jarray == null && !nullok) {
                jarray = new JSONArray();
                event.getHttpServletRequest().setAttribute("org.apache.cometd.bayeux.json_msg_array", (Object)jarray);
            }
            return jarray;
        }
    }

    protected JSONArray getJSONArray() {
        return RequestBase.getJSONArray(this.event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToDeliveryQueue(ClientImpl to, JSONObject msg) throws IOException, ServletException, BayeuxException {
        HttpEvent httpEvent = this.event;
        synchronized (httpEvent) {
            this.getJSONArray().put(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushMessages(ClientImpl client) throws BayeuxException {
        List<Message> msgs = client.takeMessages();
        HttpEvent httpEvent = this.event;
        synchronized (httpEvent) {
            try {
                for (MessageImpl messageImpl : msgs) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("channel", messageImpl.getChannel().getId());
                    if (messageImpl.getClient() != null) {
                        map.put("clientId", messageImpl.getClient().getId());
                    }
                    map.put("data", messageImpl);
                    JSONObject obj = new JSONObject(map);
                    this.addToDeliveryQueue(client, obj);
                }
            }
            catch (ServletException x) {
                throw new BayeuxException(x);
            }
            catch (IOException x) {
                throw new BayeuxException(x);
            }
        }
    }

    public int process(int prevops) throws BayeuxException {
        this.event.getHttpServletRequest().setAttribute("org.apache.cometd.bayeux.current_request", (Object)this);
        return prevops;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public String getTimeStamp() {
        return timestampFmt.format(new Date(System.currentTimeMillis()));
    }

    static {
        timestampFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

