/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.cometd.bayeux.Bayeux;
import org.apache.cometd.bayeux.Channel;
import org.apache.cometd.bayeux.Client;
import org.apache.cometd.bayeux.Listener;
import org.apache.cometd.bayeux.Message;
import org.apache.cometd.bayeux.SecurityPolicy;
import org.apache.tomcat.bayeux.ChannelImpl;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.MessageImpl;
import org.apache.tomcat.bayeux.UUIDGenerator;
import org.jboss.servlet.http.HttpEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatBayeux
implements Bayeux {
    protected int reconnectInterval = 5000;
    protected HashMap<String, Client> clients = new HashMap();
    protected LinkedHashMap<String, Channel> channels = new LinkedHashMap();
    protected SecurityPolicy securityPolicy = null;
    protected static ClientImpl errorClient = new ClientImpl("error-no-client", false);

    public static ClientImpl getErrorClient() {
        return errorClient;
    }

    protected TomcatBayeux() {
    }

    public void destroy() {
        throw new UnsupportedOperationException("TomcatBayeux.destroy() not yet implemented");
    }

    @Override
    public Channel getChannel(String channelId, boolean create) {
        Channel result = this.channels.get(channelId);
        if (result == null && create) {
            result = new ChannelImpl(channelId);
            this.channels.put(channelId, result);
        }
        return result;
    }

    @Override
    public Channel remove(Channel channel) {
        return (Channel)this.channels.remove(channel.getId());
    }

    @Override
    public Client remove(Client client) {
        if (client == null) {
            return null;
        }
        for (Channel ch : this.getChannels()) {
            ch.unsubscribe(client);
        }
        return this.clients.remove(client.getId());
    }

    @Override
    public Client getClient(String clientId) {
        return this.clients.get(clientId);
    }

    @Override
    public boolean hasClient(String clientId) {
        return this.clients.containsKey(clientId);
    }

    @Override
    public List<Client> getClients() {
        return Arrays.asList(this.clients.entrySet().toArray(new Client[0]));
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public boolean hasChannel(String channel) {
        return this.channels.containsKey(channel);
    }

    public Client newClient(String idprefix, Listener listener, boolean local, HttpEvent event) {
        String id = this.createUUID(idprefix);
        ClientImpl client = new ClientImpl(id, local);
        client.setListener(listener);
        this.clients.put(id, client);
        return client;
    }

    @Override
    public Client newClient(String idprefix, Listener listener) {
        assert (listener != null);
        return this.newClient(idprefix, listener, true, null);
    }

    protected ClientImpl getClientImpl(HttpEvent event) {
        return (ClientImpl)event.getHttpServletRequest().getAttribute("org.apache.cometd.bayeux.client");
    }

    protected void remove(HttpEvent event) {
        ClientImpl client = this.getClientImpl(event);
        if (client != null) {
            client.removeCometEvent(event);
        }
    }

    public String createUUID(String idprefix) {
        if (idprefix == null) {
            idprefix = "";
        }
        return idprefix + TomcatBayeux.toString(UUIDGenerator.randomUUID(false));
    }

    protected static String toString(byte[] data) {
        return TomcatBayeux.toString(data, 0, data != null ? data.length : 0);
    }

    protected static String toString(byte[] data, int offset, int length) {
        StringBuffer buf = new StringBuffer("{");
        if (data != null && length > 0) {
            buf.append(data[offset++]);
            for (int i = offset; i < length; ++i) {
                buf.append(", ").append(data[i]);
            }
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public List<Channel> getChannels() {
        return Arrays.asList(this.channels.entrySet().toArray(new Channel[0]));
    }

    protected Message newMessage() {
        String id = this.createUUID("msg-");
        return new MessageImpl(id);
    }

    @Override
    public Message newMessage(Client from) {
        MessageImpl msg = (MessageImpl)this.newMessage();
        msg.setClient(from);
        return msg;
    }

    @Override
    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setReconnectInterval(int reconnectTimeout) {
        this.reconnectInterval = reconnectTimeout;
    }
}

