/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.HashMap;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.Parameters;

public final class Request {
    private int serverPort = -1;
    private MessageBytes serverNameMB = MessageBytes.newInstance();
    private int remotePort;
    private int localPort;
    private MessageBytes schemeMB = MessageBytes.newInstance();
    private MessageBytes methodMB = MessageBytes.newInstance();
    private MessageBytes unparsedURIMB = MessageBytes.newInstance();
    private MessageBytes uriMB = MessageBytes.newInstance();
    private MessageBytes decodedUriMB = MessageBytes.newInstance();
    private MessageBytes queryMB = MessageBytes.newInstance();
    private MessageBytes protoMB = MessageBytes.newInstance();
    private MessageBytes remoteAddrMB = MessageBytes.newInstance();
    private MessageBytes localNameMB = MessageBytes.newInstance();
    private MessageBytes remoteHostMB = MessageBytes.newInstance();
    private MessageBytes localAddrMB = MessageBytes.newInstance();
    private MimeHeaders headers = new MimeHeaders();
    private MessageBytes instanceId = MessageBytes.newInstance();
    private Object[] notes = new Object[32];
    private InputBuffer inputBuffer = null;
    private UDecoder urlDecoder = new UDecoder();
    private long contentLength = -1L;
    private MessageBytes contentTypeMB = null;
    private String charEncoding = null;
    private Cookies cookies = new Cookies(this.headers);
    private Parameters parameters = new Parameters();
    private MessageBytes remoteUser = MessageBytes.newInstance();
    private MessageBytes authType = MessageBytes.newInstance();
    private HashMap attributes = new HashMap();
    private Response response;
    private ActionHook hook;
    private int bytesRead = 0;
    private long startTime = 0L;
    private int available = 0;
    private RequestInfo reqProcessorMX = new RequestInfo(this);

    public Request() {
        this.parameters.setQuery(this.queryMB);
        this.parameters.setURLDecoder(this.urlDecoder);
        this.parameters.setHeaders(this.headers);
    }

    public MessageBytes instanceId() {
        return this.instanceId;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public UDecoder getURLDecoder() {
        return this.urlDecoder;
    }

    public MessageBytes scheme() {
        return this.schemeMB;
    }

    public MessageBytes method() {
        return this.methodMB;
    }

    public MessageBytes unparsedURI() {
        return this.unparsedURIMB;
    }

    public MessageBytes requestURI() {
        return this.uriMB;
    }

    public MessageBytes decodedURI() {
        return this.decodedUriMB;
    }

    public MessageBytes query() {
        return this.queryMB;
    }

    public MessageBytes queryString() {
        return this.queryMB;
    }

    public MessageBytes protocol() {
        return this.protoMB;
    }

    public MessageBytes serverName() {
        return this.serverNameMB;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public MessageBytes remoteAddr() {
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        return this.remoteHostMB;
    }

    public MessageBytes localName() {
        return this.localNameMB;
    }

    public MessageBytes localAddr() {
        return this.localAddrMB;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = ContentType.getCharsetFromContentType(this.getContentType());
        return this.charEncoding;
    }

    public void setCharacterEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public int getContentLength() {
        long length = this.getContentLengthLong();
        if (length < Integer.MAX_VALUE) {
            return (int)length;
        }
        return -1;
    }

    public long getContentLengthLong() {
        if (this.contentLength > -1L) {
            return this.contentLength;
        }
        MessageBytes clB = this.headers.getUniqueValue("content-length");
        this.contentLength = clB == null || clB.isNull() ? -1L : clB.getLong();
        return this.contentLength;
    }

    public String getContentType() {
        this.contentType();
        if (this.contentTypeMB == null || this.contentTypeMB.isNull()) {
            return null;
        }
        return this.contentTypeMB.toString();
    }

    public void setContentType(String type) {
        this.contentTypeMB.setString(type);
    }

    public MessageBytes contentType() {
        if (this.contentTypeMB == null) {
            this.contentTypeMB = this.headers.getValue("content-type");
        }
        return this.contentTypeMB;
    }

    public void setContentType(MessageBytes mb) {
        this.contentTypeMB = mb;
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
        response.setRequest(this);
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook == null && this.response != null) {
            this.hook = this.response.getHook();
        }
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public MessageBytes getRemoteUser() {
        return this.remoteUser;
    }

    public MessageBytes getAuthType() {
        return this.authType;
    }

    public int getAvailable() {
        return this.available;
    }

    public void setAvailable(int available) {
        this.available = available;
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    public int doRead(ByteChunk chunk) throws IOException {
        int n = this.inputBuffer.doRead(chunk, this);
        if (n > 0) {
            this.bytesRead += n;
        }
        return n;
    }

    public String toString() {
        return "R( " + this.requestURI().toString() + ")";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public void recycle() {
        this.bytesRead = 0;
        this.contentLength = -1L;
        this.contentTypeMB = null;
        this.charEncoding = null;
        this.headers.recycle();
        this.serverNameMB.recycle();
        this.serverPort = -1;
        this.localNameMB.recycle();
        this.localPort = -1;
        this.remotePort = -1;
        this.available = 0;
        this.cookies.recycle();
        this.parameters.recycle();
        this.unparsedURIMB.recycle();
        this.uriMB.recycle();
        this.decodedUriMB.recycle();
        this.queryMB.recycle();
        this.methodMB.recycle();
        this.protoMB.recycle();
        this.schemeMB.recycle();
        this.instanceId.recycle();
        this.remoteUser.recycle();
        this.authType.recycle();
        this.attributes.clear();
    }

    public void updateCounters() {
        this.reqProcessorMX.updateCounters();
    }

    public RequestInfo getRequestProcessor() {
        return this.reqProcessorMX;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }
}

