/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstDotSuffix;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public final class AstValue
extends SimpleNode {
    protected static final boolean COERCE_TO_ZERO = Boolean.valueOf(System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "true"));

    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().getType((ELContext)ctx, t.base, t.property);
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        try {
            Target t = this.getTarget(ctx);
            return new ValueReference(t.base, t.property);
        }
        catch (Exception e) {
            return null;
        }
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        int i;
        Object base = this.children[0].getValue(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        ELResolver resolver = ctx.getELResolver();
        if (propCount > 1) {
            for (i = 1; base != null && i < propCount; ++i) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                base = resolver.getValue((ELContext)ctx, base, property);
            }
            if (base == null || property == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        if ((property = this.children[i].getValue(ctx)) == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[i]));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        Object property = null;
        ELResolver resolver = ctx.getELResolver();
        for (int i = 1; base != null && i < propCount; ++i) {
            property = this.children[i].getValue(ctx);
            if (property == null) {
                return null;
            }
            Object[] params = null;
            if (this.children[i] instanceof AstDotSuffix) {
                params = ((AstDotSuffix)this.children[i]).getParameters(ctx);
            }
            if (params != null && params.length > 0) {
                ctx.setPropertyResolved(false);
                base = resolver.invoke((ELContext)ctx, base, property, null, params);
                continue;
            }
            ctx.setPropertyResolved(false);
            base = resolver.getValue((ELContext)ctx, base, property);
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().isReadOnly((ELContext)ctx, t.base, t.property);
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ELResolver resolver = ctx.getELResolver();
        Class targetClass = resolver.getType((ELContext)ctx, t.base, t.property);
        if (COERCE_TO_ZERO || !this.isAssignable(value, targetClass)) {
            value = ELSupport.coerceToType(value, targetClass);
        }
        resolver.setValue((ELContext)ctx, t.base, t.property, value);
    }

    private boolean isAssignable(Object value, Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        if (value != null && targetClass.isPrimitive()) {
            return false;
        }
        return value == null || targetClass.isInstance(value);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), (Class[])m.getParameterTypes());
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Object[] params = null;
        if (this.jjtGetNumChildren() > 1 && this.children[1] instanceof AstDotSuffix) {
            params = ((AstDotSuffix)this.children[1]).getParameters(ctx);
        }
        Object result = null;
        if (params != null && params.length > 0) {
            ELResolver resolver = ctx.getELResolver();
            ctx.setPropertyResolved(false);
            result = resolver.invoke((ELContext)ctx, t.base, t.property, null, params);
        } else {
            Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
            try {
                result = m.invoke(t.base, paramValues);
            }
            catch (IllegalAccessException iae) {
                throw new ELException((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw new ELException(ite.getCause());
            }
        }
        return result;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

