/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;

final class StandardWrapperValve
extends ValveBase {
    protected static final boolean SERVLET_STATS = Globals.STRICT_SERVLET_COMPLIANCE || Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardWrapperValve.SERVLET_STATS", "false")) != false;
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private volatile int eventCount;
    private volatile int requestCount;
    private volatile int errorCount;
    private InstanceSupport support;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (container instanceof Wrapper) {
            this.support = ((Wrapper)container).getInstanceSupport();
        }
        if (this.support == null) {
            throw new IllegalStateException(sm.getString("standardWrapper.noInstanceSupport", container.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block53: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block52: {
                boolean unavailable = false;
                throwable = null;
                t1 = 0L;
                if (SERVLET_STATS) {
                    t1 = System.currentTimeMillis();
                    ++this.requestCount;
                }
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                if (!context.getAvailable()) {
                    response.sendError(503, sm.getString("standardContext.isUnavailable"));
                    unavailable = true;
                }
                if (!unavailable && wrapper.isUnavailable()) {
                    this.container.getLogger().info((Object)sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                    }
                    unavailable = true;
                }
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), (Throwable)e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                    }
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                boolean event = false;
                if (servlet instanceof HttpEventServlet && request.getConnector().hasIoEvents()) {
                    event = true;
                    request.setEventMode(true);
                }
                try {
                    response.sendAcknowledgement();
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().warn((Object)sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.REQUEST_INTEGER);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", request.getRequestPathMB());
                ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)request, wrapper);
                request.setEventMode(false);
                try {
                    String jspFile = wrapper.getJspFile();
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("beforeRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    if (servlet != null && filterChain != null) {
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                if (event) {
                                    request.setEventMode(true);
                                    request.getSession(true);
                                    filterChain.doFilterEvent(request.getEvent());
                                }
                                filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        } else if (event) {
                            request.setEventMode(true);
                            request.getSession(true);
                            filterChain.doFilterEvent(request.getEvent());
                        } else {
                            filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                        }
                    }
                    request.removeAttribute("org.apache.catalina.jsp_file");
                }
                catch (ClientAbortException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                    wrapper.unavailable(e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                    }
                }
                catch (ServletException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                if (filterChain != null) {
                    if (request.isEventMode() && !request.isAsyncStarted()) {
                        filterChain.reuse();
                    } else {
                        filterChain.release();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block52;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block53;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        if (SERVLET_STATS) {
            long time = System.currentTimeMillis() - t1;
            this.processingTime += time;
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            if (time < this.minTime) {
                this.minTime = time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        long t1;
        block36: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block35: {
                AsyncContext asyncContext = request.getAsyncContext();
                if (asyncContext != null) {
                    this.async(request, response, event);
                    return;
                }
                throwable = null;
                t1 = 0L;
                if (SERVLET_STATS) {
                    t1 = System.currentTimeMillis();
                    ++this.eventCount;
                }
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                boolean unavailable = !context.getAvailable() || wrapper.isUnavailable();
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.ASYNC_INTEGER);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", request.getRequestPathMB());
                ApplicationFilterChain filterChain = request.getFilterChain();
                try {
                    String jspFile = wrapper.getJspFile();
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("beforeRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    if (servlet != null && filterChain != null) {
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                filterChain.doFilterEvent(request.getEvent());
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        } else {
                            filterChain.doFilterEvent(request.getEvent());
                        }
                    }
                    request.removeAttribute("org.apache.catalina.jsp_file");
                }
                catch (ClientAbortException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                }
                catch (ServletException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                if (filterChain != null) {
                    if (request.isAsyncStarted()) {
                        filterChain.release();
                    } else {
                        filterChain.reuse();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block35;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block36;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        if (SERVLET_STATS) {
            long time = System.currentTimeMillis() - t1;
            this.processingTime += time;
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            if (time < this.minTime) {
                this.minTime = time;
            }
        }
    }

    public void async(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
        if (asyncContext != null) {
            if (event.getType() == HttpEvent.EventType.END || event.getType() == HttpEvent.EventType.ERROR || event.getType() == HttpEvent.EventType.TIMEOUT) {
                boolean timeout = event.getType() == HttpEvent.EventType.TIMEOUT;
                boolean error = event.getType() == HttpEvent.EventType.ERROR;
                for (Request.AsyncListenerRegistration asyncListenerRegistration : asyncContext.getAsyncListeners().values()) {
                    AsyncListener asyncListener = asyncListenerRegistration.getListener();
                    try {
                        AsyncEvent asyncEvent;
                        if (timeout) {
                            asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse());
                            asyncListener.onTimeout(asyncEvent);
                            continue;
                        }
                        if (error) {
                            Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
                            AsyncEvent asyncEvent2 = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse(), t);
                            asyncListener.onError(asyncEvent2);
                            continue;
                        }
                        asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse());
                        asyncListener.onComplete(asyncEvent);
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.async.listenerError", this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
            } else if (asyncContext.getRunnable() != null) {
                try {
                    asyncContext.getRunnable().run();
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.async.runnableError", this.getContainer().getName()), e);
                    this.exception(request, response, e);
                }
            } else if (asyncContext.getPath() != null) {
                asyncContext.done();
                Context context = (Context)this.getContainer().getParent();
                ServletContext servletContext = context.getServletContext();
                if (asyncContext.getServletContext() != null) {
                    servletContext = asyncContext.getServletContext();
                }
                request.setCanStartAsync(true);
                ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(asyncContext.getPath());
                try {
                    dispatcher.async(asyncContext.getRequest(), asyncContext.getResponse(), asyncContext.getUseAttributes());
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.async.dispatchError", this.getContainer().getName()), e);
                    this.exception(request, response, e);
                }
                request.setCanStartAsync(false);
                if (!asyncContext.isReady()) {
                    asyncContext.complete();
                }
            } else {
                throw new IllegalStateException(sm.getString("standardWrapper.async.invalidContext", this.getContainer().getName()));
            }
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

