/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.DefaultFileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.FileUploadException;

public class DiskFileUpload
extends FileUploadBase {
    private DefaultFileItemFactory fileItemFactory;

    public DiskFileUpload() {
        this.fileItemFactory = new DefaultFileItemFactory();
    }

    public DiskFileUpload(DefaultFileItemFactory fileItemFactory) {
        this.fileItemFactory = fileItemFactory;
    }

    @Override
    public FileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    @Override
    public void setFileItemFactory(FileItemFactory factory) {
        this.fileItemFactory = (DefaultFileItemFactory)factory;
    }

    public int getSizeThreshold() {
        return this.fileItemFactory.getSizeThreshold();
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.fileItemFactory.setSizeThreshold(sizeThreshold);
    }

    public String getRepositoryPath() {
        return this.fileItemFactory.getRepository().getPath();
    }

    public void setRepositoryPath(String repositoryPath) {
        this.fileItemFactory.setRepository(new File(repositoryPath));
    }

    @Override
    public long getFileSizeMax() {
        return this.fileItemFactory.getFileSizeMax();
    }

    @Override
    public void setFileSizeMax(long fileSizeMax) {
        this.fileItemFactory.setFileSizeMax(fileSizeMax);
    }

    public List<FileItem> parseRequest(HttpServletRequest req, int sizeThreshold, long sizeMax, String path) throws IOException, FileUploadException {
        this.setSizeThreshold(sizeThreshold);
        this.setSizeMax(sizeMax);
        this.setRepositoryPath(path);
        return this.parseRequest(req);
    }
}

