/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.MappingData;

public class ApplicationContext
implements ServletContext {
    protected Map attributes = new ConcurrentHashMap();
    private Map readOnlyAttributes = new ConcurrentHashMap();
    private StandardContext context = null;
    private static final ArrayList empty = new ArrayList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private Map parameters = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String basePath = null;
    private ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private boolean restricted = false;

    public ApplicationContext(String basePath, StandardContext context) {
        this.context = context;
        this.basePath = basePath;
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet(), true);
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        Context child = null;
        try {
            int slash;
            Host host = (Host)this.context.getParent();
            String mapuri = uri;
            while ((child = (Context)host.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
                mapuri = mapuri.substring(0, slash);
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (child == null) {
            return null;
        }
        if (this.context.getCrossContext()) {
            return child.getServletContext();
        }
        if (child == this.context) {
            return this.context.getServletContext();
        }
        return null;
    }

    public String getContextPath() {
        return this.context.getPath();
    }

    public String getInitParameter(String name) {
        this.mergeParameters();
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        this.mergeParameters();
        return new Enumerator(this.parameters.keySet());
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, null, name);
    }

    public String getRealPath(String path) {
        if (!this.context.isFilesystemBased()) {
            return null;
        }
        if (path == null) {
            return null;
        }
        File file = new File(this.basePath, path);
        return file.getAbsolutePath();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        pos = path.length();
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        }
        MessageBytes uriMB = dd.uriMB;
        uriMB.recycle();
        MappingData mappingData = dd.mappingData;
        CharChunk uriCC = uriMB.getCharChunk();
        try {
            uriCC.append(this.context.getPath(), 0, this.context.getPath().length());
            int semicolon = path.indexOf(59);
            if (pos >= 0 && semicolon > pos) {
                semicolon = -1;
            }
            uriCC.append(path, 0, semicolon > 0 ? semicolon : pos);
            this.context.getMapper().map(uriMB, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
            if (semicolon > 0) {
                uriCC.append(path, semicolon, pos - semicolon);
            }
        }
        catch (Exception e) {
            this.log(sm.getString("applicationContext.mapping.error"), e);
            return null;
        }
        Wrapper wrapper = (Wrapper)mappingData.wrapper;
        String requestPath = mappingData.requestPath.toString();
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        mappingData.recycle();
        return new ApplicationDispatcher(wrapper, uriCC.toString(), requestPath, wrapperPath, pathInfo, queryString, null);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || Globals.STRICT_SERVLET_COMPLIANCE && !path.startsWith("/")) {
            throw new MalformedURLException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        String libPath = "/WEB-INF/lib/";
        if (path.startsWith(libPath) && path.endsWith(".jar")) {
            File jarFile = null;
            jarFile = this.context.isFilesystemBased() ? new File(this.basePath, path) : new File(this.context.getWorkPath(), path);
            if (jarFile.exists()) {
                return jarFile.toURL();
            }
            return null;
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            String fullPath = this.context.getName() + path;
            String hostName = this.context.getParent().getName();
            try {
                resources.lookup(path);
                return new URL("jndi", "", 0, ApplicationContext.getJNDIUri(hostName, fullPath), new DirContextURLStreamHandler(resources));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if (path == null || Globals.STRICT_SERVLET_COMPLIANCE && !path.startsWith("/")) {
            return null;
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            try {
                Object resource = resources.lookup(path);
                if (resource instanceof Resource) {
                    return ((Resource)resource).streamContent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.resourcePaths.iae", path));
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            return this.getResourcePathsInternal(resources, path);
        }
        return null;
    }

    private Set getResourcePathsInternal(DirContext resources, String path) {
        ResourceSet set = new ResourceSet();
        try {
            ApplicationContext.listCollectionPaths(set, resources, path);
        }
        catch (NamingException e) {
            return null;
        }
        set.setLocked(true);
        return set;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration getServletNames() {
        return new Enumerator(empty);
    }

    public Enumeration getServlets() {
        return new Enumerator(empty);
    }

    public void log(String message) {
        this.context.getLogger().info((Object)message);
    }

    public void log(Exception exception, String message) {
        this.context.getLogger().error((Object)message, (Throwable)exception);
    }

    public void log(String message, Throwable throwable) {
        this.context.getLogger().error((Object)message, throwable);
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.get(name);
        if (oldValue != null) {
            replaced = true;
        }
        this.attributes.put(name, value);
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) throws IllegalArgumentException, IllegalStateException {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        if (this.context.findFilterDef(filterName) != null) {
            return null;
        }
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(filterName);
        filterDef.setFilterClass(className);
        this.context.addFilterDef(filterDef);
        ApplicationFilterConfig filterConfig = new ApplicationFilterConfig(this.context, filterDef);
        filterConfig.setDynamic(true);
        this.context.addApplicationFilterConfig(filterConfig);
        return (FilterRegistration.Dynamic)filterConfig.getFacade();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        if (this.context.findFilterDef(filterName) != null) {
            return null;
        }
        for (Container container : this.context.getParent().findChildren()) {
            if (!(container instanceof StandardContext)) continue;
            for (ApplicationFilterConfig filterConfig : ((StandardContext)container).findApplicationFilterConfigs()) {
                if (filterConfig.getFilterInstance() != filter) continue;
                return null;
            }
        }
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(filterName);
        filterDef.setFilterClass(filter.getClass().getName());
        this.context.addFilterDef(filterDef);
        ApplicationFilterConfig filterConfig = new ApplicationFilterConfig(this.context, filterDef);
        filterConfig.setDynamic(true);
        filterConfig.setFilter(filter);
        this.context.addApplicationFilterConfig(filterConfig);
        return (FilterRegistration.Dynamic)filterConfig.getFacade();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, filterClass.getName());
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) throws IllegalArgumentException, IllegalStateException {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        if (this.context.findChild(servletName) != null) {
            return null;
        }
        Wrapper wrapper = this.context.createWrapper();
        wrapper.setDynamic(true);
        wrapper.setName(servletName);
        wrapper.setServletClass(className);
        this.context.addChild(wrapper);
        return (ServletRegistration.Dynamic)wrapper.getFacade();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> clazz) throws IllegalArgumentException, IllegalStateException {
        return this.addServlet(servletName, clazz.getName());
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        if (this.context.findChild(servletName) != null) {
            return null;
        }
        for (Container container : this.context.getParent().findChildren()) {
            for (Container wrapper : container.findChildren()) {
                if (((Wrapper)wrapper).getServlet() != servlet) continue;
                return null;
            }
        }
        Wrapper wrapper = this.context.createWrapper();
        wrapper.setDynamic(true);
        wrapper.setName(servletName);
        wrapper.setServletClass(servlet.getClass().getName());
        wrapper.setServlet(servlet);
        this.context.addChild(wrapper);
        return (ServletRegistration.Dynamic)wrapper.getFacade();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        ApplicationFilterConfig filterConfig = this.context.findApplicationFilterConfig(filterName);
        if (filterConfig == null) {
            FilterDef filterDef = this.context.findFilterDef(filterName);
            if (filterDef == null) {
                return null;
            }
            filterConfig = new ApplicationFilterConfig(this.context, filterDef);
            this.context.addApplicationFilterConfig(filterConfig);
        }
        return filterConfig.getFacade();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(servletName);
        if (wrapper != null) {
            return wrapper.getFacade();
        }
        return null;
    }

    public Map<String, FilterRegistration> getFilterRegistrations() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        HashMap<String, FilterRegistration> result = new HashMap<String, FilterRegistration>();
        ApplicationFilterConfig[] filterConfigs = this.context.findApplicationFilterConfigs();
        for (int i = 0; i < filterConfigs.length; ++i) {
            result.put(filterConfigs[i].getFilterName(), filterConfigs[i].getFacade());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        HashMap<String, ServletRegistration> result = new HashMap<String, ServletRegistration>();
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            result.put(wrapper.getName(), wrapper.getFacade());
        }
        return Collections.unmodifiableMap(result);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getSessionTrackingModes();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getSessionCookie();
    }

    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        try {
            return (T)((Filter)this.context.getInstanceManager().newInstance(c));
        }
        catch (Throwable e) {
            throw new ServletException(sm.getString("applicationContext.create"), e);
        }
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        try {
            return (T)((Servlet)this.context.getInstanceManager().newInstance(c));
        }
        catch (Throwable e) {
            throw new ServletException(sm.getString("applicationContext.create"), e);
        }
    }

    public boolean setInitParameter(String name, String value) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        this.mergeParameters();
        if (this.parameters.get(name) != null) {
            return false;
        }
        this.parameters.put(name, value);
        return true;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        for (SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            if (this.getDefaultSessionTrackingModes().contains(sessionTrackingMode)) continue;
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae", sessionTrackingMode.toString(), this.getContextPath()));
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.SSL) && sessionTrackingModes.size() > 1) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.ssl", this.getContextPath()));
        }
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public void addListener(String className) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        EventListener listenerInstance = null;
        try {
            Class<?> clazz = this.context.getLoader().getClassLoader().loadClass(className);
            listenerInstance = (EventListener)this.context.getInstanceManager().newInstance(clazz);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", className, this.getContextPath()), t);
        }
        this.checkListenerType(listenerInstance);
        if (this.context.getApplicationLifecycleListeners() != null && listenerInstance instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", className, this.getContextPath()));
        }
        this.context.addApplicationListenerInstance(listenerInstance);
    }

    public <T extends EventListener> void addListener(T listener) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        this.checkListenerType(listener);
        if (this.context.getApplicationLifecycleListeners() != null && listener instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", listener.getClass().getName(), this.getContextPath()));
        }
        this.context.addApplicationListenerInstance(listener);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        EventListener listenerInstance = null;
        try {
            listenerInstance = (EventListener)this.context.getInstanceManager().newInstance(listenerClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", listenerClass.getName(), this.getContextPath()), e);
        }
        this.checkListenerType(listenerInstance);
        if (this.context.getApplicationLifecycleListeners() != null && listenerInstance instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", listenerClass.getName(), this.getContextPath()));
        }
        this.context.addApplicationListenerInstance(listenerInstance);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        EventListener listenerInstance = null;
        try {
            listenerInstance = (EventListener)this.context.getInstanceManager().newInstance(clazz);
        }
        catch (Throwable t) {
            throw new ServletException(sm.getString("applicationContext.create"), t);
        }
        this.checkListenerType(listenerInstance);
        return (T)listenerInstance;
    }

    public ClassLoader getClassLoader() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getLoader().getClassLoader();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        ArrayList<TaglibDescriptor> taglibDescriptors = new ArrayList<TaglibDescriptor>();
        String[] taglibURIs = this.context.findTaglibs();
        for (int i = 0; i < taglibURIs.length; ++i) {
            String taglibLocation = this.context.findTaglib(taglibURIs[i]);
            TaglibDescriptorImpl taglibDescriptor = new TaglibDescriptorImpl(taglibURIs[i], taglibLocation);
            taglibDescriptors.add(taglibDescriptor);
        }
        ArrayList<JspPropertyGroupDescriptor> jspPropertyGroupDescriptors = new ArrayList<JspPropertyGroupDescriptor>();
        JspPropertyGroup[] jspPropertyGroups = this.context.findJspPropertyGroups();
        for (int i = 0; i < jspPropertyGroups.length; ++i) {
            jspPropertyGroupDescriptors.add(jspPropertyGroups[i]);
        }
        return new JspConfigDescriptorImpl(jspPropertyGroupDescriptors, taglibDescriptors);
    }

    public int getEffectiveMajorVersion() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getVersionMajor();
    }

    public int getEffectiveMinorVersion() {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        return this.context.getVersionMinor();
    }

    public void declareRoles(String ... roleNames) {
        if (this.restricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restricted"));
        }
        if (!this.context.isStarting()) {
            throw new IllegalStateException(sm.getString("applicationContext.alreadyInitialized", this.getContextPath()));
        }
        for (String role : roleNames) {
            if (role == null || "".equals(role)) {
                throw new IllegalArgumentException(sm.getString("applicationContext.emptyRole", this.getContextPath()));
            }
            this.context.addSecurityRole(role);
        }
    }

    protected void checkListenerType(EventListener listener) {
        if (!(listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener || listener instanceof ServletRequestListener || listener instanceof ServletRequestAttributeListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionAttributeListener)) {
            throw new IllegalArgumentException(sm.getString("applicationContext.badListenerClass", listener.getClass().getName(), this.getContextPath()));
        }
    }

    protected StandardContext getContext() {
        return this.context;
    }

    protected Map getReadonlyAttributes() {
        return this.readOnlyAttributes;
    }

    protected void clearAttributes() {
        ArrayList list = new ArrayList();
        Iterator iter = this.attributes.keySet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    void setAttributeReadOnly(String name) {
        if (this.attributes.containsKey(name)) {
            this.readOnlyAttributes.put(name, name);
        }
    }

    private void mergeParameters() {
        if (this.parameters != null) {
            return;
        }
        ConcurrentHashMap<String, String> results = new ConcurrentHashMap<String, String>();
        String[] names = this.context.findParameters();
        for (int i = 0; i < names.length; ++i) {
            results.put(names[i], this.context.findParameter(names[i]));
        }
        ApplicationParameter[] params = this.context.findApplicationParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getOverride()) {
                if (results.get(params[i].getName()) != null) continue;
                results.put(params[i].getName(), params[i].getValue());
                continue;
            }
            results.put(params[i].getName(), params[i].getValue());
        }
        this.parameters = results;
    }

    private static void listCollectionPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            StringBuffer childPath = new StringBuffer(path);
            if (!"/".equals(path) && !path.endsWith("/")) {
                childPath.append("/");
            }
            childPath.append(name);
            Object object = binding.getObject();
            if (object instanceof DirContext) {
                childPath.append("/");
            }
            set.add(childPath.toString());
        }
    }

    private static String getJNDIUri(String hostName, String path) {
        if (!path.startsWith("/")) {
            return "/" + hostName + "/" + path;
        }
        return "/" + hostName + path;
    }

    private static final class TaglibDescriptorImpl
    implements TaglibDescriptor {
        private String taglibLocation;
        private String taglibURI;

        public TaglibDescriptorImpl(String taglibURI, String taglibLocation) {
            this.taglibLocation = taglibLocation;
            this.taglibURI = taglibURI;
        }

        public String getTaglibLocation() {
            return this.taglibLocation;
        }

        public String getTaglibURI() {
            return this.taglibURI;
        }
    }

    private static final class JspConfigDescriptorImpl
    implements JspConfigDescriptor {
        private Collection<JspPropertyGroupDescriptor> jspPropertyGroups;
        private Collection<TaglibDescriptor> taglibs;

        public JspConfigDescriptorImpl(Collection<JspPropertyGroupDescriptor> jspPropertyGroups, Collection<TaglibDescriptor> taglibs) {
            this.jspPropertyGroups = jspPropertyGroups;
            this.taglibs = taglibs;
        }

        public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
            return this.jspPropertyGroups;
        }

        public Collection<TaglibDescriptor> getTaglibs() {
            return this.taglibs;
        }
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        public DispatchData() {
            CharChunk uriCC = this.uriMB.getCharChunk();
            uriCC.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }
}

