/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.MimeHeaders;
import org.jboss.logging.Logger;

public final class Parameters {
    protected static Logger log = Logger.getLogger(Parameters.class);
    protected static final int NEED_NEXT = -2;
    protected static final int LAST = -1;
    public static final int INITIAL_SIZE = 8;
    protected static final String[] ARRAY_TYPE = new String[0];
    protected Field[] fields;
    protected int count;
    protected boolean didQueryParameters = false;
    protected boolean didMerge = false;
    protected MessageBytes queryMB;
    protected UDecoder urlDec;
    protected MessageBytes decodedQuery = MessageBytes.newInstance();
    protected String encoding = null;
    protected String queryStringEncoding = null;
    protected ByteChunk tmpName = new ByteChunk();
    protected ByteChunk tmpValue = new ByteChunk();
    protected CharChunk tmpNameC = new CharChunk(32);
    protected CharChunk tmpValueC = new CharChunk(128);
    private static int debug = 0;

    public Parameters() {
        this.fields = new Field[8];
    }

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setHeaders(MimeHeaders headers) {
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
    }

    public void recycle() {
        for (int i = 0; i < this.count; ++i) {
            this.fields[i].recycle();
        }
        this.count = 0;
        this.didQueryParameters = false;
        this.didMerge = false;
        this.encoding = null;
        this.decodedQuery.recycle();
    }

    protected int size() {
        return this.count;
    }

    protected MessageBytes getName(int n) {
        return this.fields[n].name;
    }

    protected MessageBytes getValue(int n) {
        return this.fields[n].value;
    }

    protected int addField() {
        int len = this.fields.length;
        int pos = this.count;
        if (this.count >= len) {
            Field[] tmp = new Field[pos * 2];
            System.arraycopy(this.fields, 0, tmp, 0, len);
            this.fields = tmp;
        }
        if (this.fields[pos] == null) {
            this.fields[pos] = new Field();
        }
        ++this.count;
        return pos;
    }

    protected int findFirst(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected int findNext(int startPos) {
        int next = this.fields[startPos].nextPos;
        if (next != -2) {
            return next;
        }
        MessageBytes name = this.fields[startPos].name;
        for (int i = startPos + 1; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            this.fields[startPos].nextPos = i;
            return i;
        }
        this.fields[startPos].nextPos = -1;
        return -1;
    }

    public void addParameterValues(String name, String[] values) {
        if (name == null || values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            int pos = this.addField();
            this.getName(pos).setString(name);
            this.getValue(pos).setString(value);
        }
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        int pos = this.findFirst(name);
        if (pos >= 0) {
            ArrayList<String> result = new ArrayList<String>();
            while (pos >= 0) {
                result.add(this.getValue(pos).toString());
                pos = this.findNext(pos);
            }
            return result.toArray(ARRAY_TYPE);
        }
        return null;
    }

    public Enumeration getParameterNames() {
        this.handleQueryParameters();
        return new NamesEnumeration();
    }

    public String getParameter(String name) {
        this.handleQueryParameters();
        int pos = this.findFirst(name);
        if (pos >= 0) {
            return this.getValue(pos).toString();
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (debug > 0) {
            this.log("Decoding query " + this.decodedQuery + " " + this.queryStringEncoding);
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    protected void addParam(String name, String value) {
        if (name == null) {
            return;
        }
        int pos = this.addField();
        this.getName(pos).setString(name);
        this.getValue(pos).setString(value);
    }

    public void processParameters(MessageBytes data) {
        this.processParameters(data, this.encoding);
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), encoding);
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.encoding);
    }

    public void processParameters(byte[] bytes, int start, int len, String enc) {
        int end = start + len;
        int pos = start;
        if (debug > 0) {
            this.log("Bytes: " + new String(bytes, start, len));
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = ByteChunk.indexOf(bytes, nameStart, end, '=');
            int nameEnd2 = ByteChunk.indexOf(bytes, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + new String(bytes, nameStart, nameEnd - nameStart));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = ByteChunk.indexOf(bytes, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) {
                log.warn((Object)"Parameters: Invalid chunk ignored.");
                continue;
            }
            this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
            this.tmpValue.setBytes(bytes, valStart, valEnd - valStart);
            try {
                this.addParam(this.urlDecode(this.tmpName, enc), this.urlDecode(this.tmpValue, enc));
            }
            catch (IOException e) {
                log.warn((Object)"Parameters: Character decoding failed. Parameter skipped.", (Throwable)e);
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
        } while (pos < end);
    }

    protected String urlDecode(ByteChunk bc, String enc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc);
        String result = null;
        if (enc != null) {
            bc.setEncoding(enc);
            result = bc.toString();
        } else {
            CharChunk cc = this.tmpNameC;
            int length = bc.getLength();
            cc.allocate(length, -1);
            byte[] bbuf = bc.getBuffer();
            char[] cbuf = cc.getBuffer();
            int start = bc.getStart();
            for (int i = 0; i < length; ++i) {
                cbuf[i] = (char)(bbuf[i + start] & 0xFF);
            }
            cc.setChars(cbuf, 0, length);
            result = cc.toString();
            cc.recycle();
        }
        return result;
    }

    public String paramsAsString() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.getParameterNames();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            sb.append(k).append("=");
            String[] v = this.getParameterValues(k);
            for (int i = 0; i < v.length; ++i) {
                sb.append(v[i]).append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameters: " + s));
        }
    }

    protected class NamesEnumeration
    implements Enumeration {
        int pos = 0;
        String next;

        public NamesEnumeration() {
            this.findNext();
        }

        private void findNext() {
            this.next = null;
            while (this.pos < Parameters.this.count) {
                this.next = Parameters.this.getName(this.pos).toString();
                for (int j = 0; j < this.pos; ++j) {
                    if (!Parameters.this.getName(j).equals(this.next)) continue;
                    this.next = null;
                    break;
                }
                if (this.next != null) break;
                ++this.pos;
            }
            ++this.pos;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            String current = this.next;
            this.findNext();
            return current;
        }
    }

    protected class Field {
        MessageBytes name = MessageBytes.newInstance();
        MessageBytes value = MessageBytes.newInstance();
        int nextPos = -2;
        int hash;
        Field nextSameHash;

        Field() {
        }

        void recycle() {
            this.name.recycle();
            this.value.recycle();
            this.nextPos = -2;
        }
    }
}

