/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.JarRepository;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.util.StringManager;
import org.apache.naming.JndiPermission;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.logging.Logger;

public class WebappClassLoader
extends URLClassLoader
implements Lifecycle {
    protected static Logger log = Logger.getLogger(WebappClassLoader.class);
    public static final boolean ENABLE_CLEAR_REFERENCES = Boolean.valueOf(System.getProperty("org.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES", "true"));
    public static final boolean SYSTEM_CL_DELEGATION = Boolean.valueOf(System.getProperty("org.apache.catalina.loader.WebappClassLoader.SYSTEM_CL_DELEGATION", "true"));
    protected static final String[] triggers = new String[]{"javax.servlet.Servlet"};
    protected static final String[] packageTriggers = new String[]{"javax.servlet."};
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    boolean antiJARLocking = false;
    protected JarRepository repository = null;
    protected Map<String, ResourceEntry> resourceEntries = new ConcurrentHashMap<String, ResourceEntry>();
    protected Map<String, Object> notFoundResources = new ConcurrentHashMap<String, Object>();
    protected static final Object VALUE = new Object();
    protected boolean delegate = false;
    protected URL[] repositoryURLs = null;
    protected ArrayList permissionList = new ArrayList();
    protected File loaderDir = null;
    protected HashMap loaderPC = new HashMap();
    protected SecurityManager securityManager = null;
    protected ClassLoader parent = null;
    protected ClassLoader system = null;
    protected boolean started = false;
    protected boolean needConvert = false;
    protected Permission allPermission = new AllPermission();

    public WebappClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public JarRepository getRepository() {
        return this.repository;
    }

    public void setRepository(JarRepository repository) {
        this.repository = repository;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        this.antiJARLocking = antiJARLocking;
    }

    public void addPermission(String path) {
        if (path == null) {
            return;
        }
        if (this.securityManager != null) {
            Permission permission = null;
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                permission = new JndiPermission(path + "*");
                this.addPermission(permission);
            } else {
                if (!path.endsWith(File.separator)) {
                    permission = new FilePermission(path, "read");
                    this.addPermission(permission);
                    path = path + File.separator;
                }
                permission = new FilePermission(path + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader");
    }

    protected void setParentClassLoader(ClassLoader pcl) {
        this.parent = pcl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappClassLoader\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findClass(" + name + ")"));
        }
        if (!this.started) {
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class clazz = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("      findClassInternal(" + name + ")"));
        }
        try {
            clazz = this.findClassInternal(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (AccessControlException ace) {
            throw new ClassNotFoundException(name, ace);
        }
        catch (RuntimeException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Returning class " + clazz));
        }
        if (log.isTraceEnabled() && clazz != null) {
            log.debug((Object)("      Loaded by " + clazz.getClassLoader()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResource(" + name + ")"));
        }
        URL url = null;
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry == null) {
            entry = this.findResourceInternal(name, name);
        }
        if (entry != null) {
            url = entry.source;
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug((Object)("    --> Returning '" + url.toString() + "'"));
            } else {
                log.debug((Object)"    --> Resource not found, returning null");
            }
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResources(" + name + ")"));
        }
        Vector<URL> result = new Vector<URL>();
        File[] repositories = this.repository.findExplodedJars();
        JarFile[] jarFiles = this.repository.findJars();
        for (i = 0; i < repositories.length; ++i) {
            File resource = new File(repositories[i], name);
            if (!resource.exists()) continue;
            result.addElement(this.getURI(resource));
        }
        for (i = 0; i < jarFiles.length; ++i) {
            JarEntry jarEntry = jarFiles[i].getJarEntry(name);
            if (jarEntry == null) continue;
            File jarFile = new File(jarFiles[i].getName());
            try {
                String jarFakeUrl = this.getURI(jarFile).toString();
                jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                result.addElement(new URL(jarFakeUrl));
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return result.elements();
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + name + ")"));
        }
        URL url = null;
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (this.antiJARLocking) {
                ResourceEntry entry = this.resourceEntries.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar") && !name.endsWith(".class")) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = this.getURI(resourceFile);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResourceAsStream(" + name + ")"));
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from local");
            }
            if ((stream = this.findLoadedResource(name)) != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader unconditionally " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        boolean delegateLoad;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        Class<?> clazz = null;
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info((Object)sm.getString("webappClassLoader.stopped", name), (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass0(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (SYSTEM_CL_DELEGATION) {
            try {
                clazz = Class.forName(name, false, this.system);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean bl = delegateLoad = this.delegate || this.filter(name);
        if (delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = Class.forName(name, false, loader);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader at end: " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = Class.forName(name, false, loader);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = (PermissionCollection)this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return this.repositoryURLs;
        }
        URL[] external = super.getURLs();
        File[] repositories = this.repository.findExplodedJars();
        JarFile[] jarFiles = this.repository.findJars();
        int length = repositories.length + jarFiles.length;
        try {
            URL[] urls = new URL[length];
            for (int i = 0; i < length; ++i) {
                urls[i] = i < repositories.length ? this.getURL(repositories[i], true) : this.getURL(new File(jarFiles[i - repositories.length].getName()), true);
            }
            this.repositoryURLs = urls;
        }
        catch (MalformedURLException e) {
            this.repositoryURLs = new URL[0];
        }
        return this.repositoryURLs;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public void start() throws LifecycleException {
        this.started = true;
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding");
        }
        catch (Exception e) {
            return;
        }
        if (encoding.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.clearReferences();
        this.started = false;
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.repositoryURLs = null;
        this.parent = null;
        this.repository = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            WebappClassLoader.deleteDir(this.loaderDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearReferences() {
        InputStream is = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");
        byte[] classBytes = new byte[4096];
        int offset = 0;
        try {
            int read = is.read(classBytes, offset, 4096 - offset);
            while (read > -1) {
                read = is.read(classBytes, offset += read, 4096 - offset);
            }
            Class<?> lpClass = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", classBytes, 0, offset);
            Object obj = lpClass.newInstance();
            obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveFailed"), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError"), (Throwable)ioe);
                }
            }
        }
        if (ENABLE_CLEAR_REFERENCES) {
            int i;
            Field[] fields;
            Class clazz;
            Collection<ResourceEntry> values = this.resourceEntries.values();
            block18: for (ResourceEntry entry : values) {
                if (entry.loadedClass == null) continue;
                clazz = entry.loadedClass;
                try {
                    fields = clazz.getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        if (!Modifier.isStatic(fields[i].getModifiers())) continue;
                        fields[i].get(null);
                        continue block18;
                    }
                }
                catch (Throwable t) {
                }
            }
            for (ResourceEntry entry : values) {
                if (entry.loadedClass == null) continue;
                clazz = entry.loadedClass;
                try {
                    fields = clazz.getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        int mods = field.getModifiers();
                        if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1 || !Modifier.isStatic(mods)) continue;
                        try {
                            field.setAccessible(true);
                            if (Modifier.isFinal(mods)) {
                                if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                                this.nullInstance(field.get(null));
                                continue;
                            }
                            field.set(null, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Set field " + field.getName() + " to null in class " + clazz.getName()));
                            continue;
                        }
                        catch (Throwable t) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Could not set field " + field.getName() + " to null in class " + clazz.getName()), t);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Could not clean fields for class " + clazz.getName()), t);
                }
            }
        }
        IntrospectionUtils.clear();
        Introspector.flushCaches();
    }

    protected void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1) continue;
            try {
                Object value;
                field.setAccessible(true);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods) || null == (value = field.get(instance))) continue;
                Class<?> valueClass = value.getClass();
                if (!this.loadedByThisOrChild(valueClass)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this WebappClassLoader."));
                    continue;
                }
                field.set(instance, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set field " + field.getName() + " to null in class " + instance.getClass().getName()));
                continue;
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName()), t);
            }
        }
    }

    protected boolean loadedByThisOrChild(Class clazz) {
        boolean result = false;
        for (ClassLoader classLoader = clazz.getClassLoader(); null != classLoader; classLoader = classLoader.getParent()) {
            if (!classLoader.equals(this)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + ".class";
        ResourceEntry entry = null;
        entry = this.findResourceInternal(name, classPath);
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            clazz = entry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(entry.codeBase);
                } else {
                    boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            entry.loadedClass = clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, new CodeSource(entry.codeBase, entry.certificates));
            entry.binaryContent = null;
            entry.source = null;
            entry.codeBase = null;
            entry.manifest = null;
            entry.certificates = null;
        }
        return clazz;
    }

    protected ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            entry.codeBase = this.getURL(new File(file, path), false);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        JarEntry jarEntry2;
        int i;
        if (!this.started) {
            log.info((Object)sm.getString("webappClassLoader.stopped", name));
            return null;
        }
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry;
        }
        int contentLength = -1;
        InputStream binaryStream = null;
        File[] repositories = this.repository.findExplodedJars();
        JarFile[] jarFiles = this.repository.findJars();
        boolean fileNeedConvert = false;
        for (i = 0; entry == null && i < repositories.length; ++i) {
            File resource = new File(repositories[i], path);
            if (!resource.exists()) continue;
            if (this.securityManager != null) {
                PrivilegedFindResource dp = new PrivilegedFindResource(repositories[i], path);
                entry = (ResourceEntry)AccessController.doPrivileged(dp);
            } else {
                entry = this.findResourceInternal(repositories[i], path);
            }
            contentLength = (int)resource.length();
            entry.lastModified = resource.lastModified();
            try {
                binaryStream = new FileInputStream(resource);
            }
            catch (IOException e) {
                return null;
            }
            if (!this.needConvert || !path.endsWith(".properties")) continue;
            fileNeedConvert = true;
        }
        if (entry == null && this.notFoundResources.containsKey(name)) {
            return null;
        }
        JarEntry jarEntry = null;
        for (i = 0; entry == null && i < jarFiles.length; ++i) {
            jarEntry = jarFiles[i].getJarEntry(path);
            if (jarEntry == null) continue;
            entry = new ResourceEntry();
            try {
                File jarFile = new File(jarFiles[i].getName());
                entry.codeBase = this.getURL(jarFile, false);
                String jarFakeUrl = this.getURI(jarFile).toString();
                jarFakeUrl = "jar:" + jarFakeUrl + "!/" + path;
                entry.source = new URL(jarFakeUrl);
                entry.lastModified = jarFile.lastModified();
            }
            catch (MalformedURLException e) {
                return null;
            }
            contentLength = (int)jarEntry.getSize();
            try {
                entry.manifest = jarFiles[i].getManifest();
                binaryStream = jarFiles[i].getInputStream(jarEntry);
            }
            catch (IOException e) {
                return null;
            }
            if (!this.antiJARLocking || path.endsWith(".class")) continue;
            byte[] buf = new byte[1024];
            File resourceFile = new File(this.loaderDir, jarEntry.getName());
            if (resourceFile.exists()) continue;
            Enumeration<JarEntry> entries = jarFiles[i].entries();
            while (entries.hasMoreElements()) {
                jarEntry2 = entries.nextElement();
                if (jarEntry2.isDirectory() || jarEntry2.getName().endsWith(".class")) continue;
                resourceFile = new File(this.loaderDir, jarEntry2.getName());
                resourceFile.getParentFile().mkdirs();
                FileOutputStream os = null;
                InputStream is = null;
                try {
                    int n;
                    is = jarFiles[i].getInputStream(jarEntry2);
                    os = new FileOutputStream(resourceFile);
                    while ((n = is.read(buf)) > 0) {
                        os.write(buf, 0, n);
                    }
                }
                catch (IOException e) {}
                continue;
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (os == null) continue;
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (entry == null) {
            this.notFoundResources.put(name, VALUE);
            return null;
        }
        if (binaryStream != null) {
            byte[] binaryContent = new byte[contentLength];
            int pos = 0;
            try {
                int n;
                while ((n = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                    pos += n;
                }
            }
            catch (IOException e) {
                log.error((Object)sm.getString("webappClassLoader.readError", name), (Throwable)e);
                jarEntry2 = null;
                return jarEntry2;
            }
            finally {
                try {
                    binaryStream.close();
                }
                catch (IOException e) {}
            }
            if (fileNeedConvert) {
                String str = new String(binaryContent, 0, pos);
                try {
                    binaryContent = str.getBytes("UTF-8");
                }
                catch (Exception e) {
                    return null;
                }
            }
            entry.binaryContent = binaryContent;
            if (jarEntry != null) {
                entry.certificates = jarEntry.getCertificates();
            }
        }
        Map<String, ResourceEntry> map = this.resourceEntries;
        synchronized (map) {
            ResourceEntry entry2 = this.resourceEntries.get(name);
            if (entry2 == null) {
                this.resourceEntries.put(name, entry);
            } else {
                entry = entry2;
            }
        }
        return entry;
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    protected Class findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!packageName.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    protected boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        for (int i = 0; i < triggers.length; ++i) {
            JarEntry jarEntry;
            Class<?> clazz = null;
            try {
                clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            if (clazz == null) continue;
            String name = triggers[i].replace('.', '/') + ".class";
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Checking for " + name));
            }
            if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
            log.info((Object)("validateJarFile(" + jarfile + ") - jar not loaded. See Servlet Spec 2.3, " + "section 9.7.2. Offending class: " + name));
            jarFile.close();
            return false;
        }
        jarFile.close();
        return true;
    }

    protected URL getURL(File file, boolean encoded) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (encoded) {
            return this.getURI(realFile);
        }
        return realFile.toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURI().toURL();
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction {
        protected File file;
        protected String path;

        PrivilegedFindResource(File file, String path) {
            this.file = file;
            this.path = path;
        }

        public Object run() {
            return WebappClassLoader.this.findResourceInternal(this.file, this.path);
        }
    }
}

