/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public abstract class RealmBase
implements Lifecycle,
Realm,
MBeanRegistration {
    private static Logger log = Logger.getLogger(RealmBase.class);
    protected Container container = null;
    protected Logger containerLog = null;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static MessageDigest md5Helper;
    protected static StringManager sm;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected String type;
    protected String domain;
    protected String host;
    protected String path;
    protected String realmPath = "/realm0";
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;
    protected boolean initialized = false;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String allRolesMode) {
        this.allRolesMode = AllRolesMode.toMode(allRolesMode);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        String serverCredentials = this.getPassword(username);
        boolean validated = serverCredentials == null ? false : (this.hasMessageDigest() ? serverCredentials.equalsIgnoreCase(this.digest(credentials)) : serverCredentials.equals(credentials));
        if (!validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", username));
            }
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", username));
        }
        return this.getPrincipal(username);
    }

    @Override
    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, credentials.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        String serverDigestValue = md5a1 + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = serverDigestValue.getBytes();
        } else {
            try {
                valueBytes = serverDigestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        String serverDigest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + clientDigest + " Username:" + username + " ClientSigest:" + clientDigest + " nOnce:" + nOnce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + md5a2 + " Server digest:" + serverDigest));
        }
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < certs.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + certs[i].getSubjectDN().getName() + "'"));
                }
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)e);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0]);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        String pattern;
        int k;
        boolean matched;
        int i;
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getRequestPathMB().toString();
        String method = request.getMethod();
        boolean found = false;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns;
                if (collection[j].findMethodOmission(method) || (patterns = collection[j].findPatterns()) == null) continue;
                for (int k2 = 0; k2 < patterns.length; ++k2) {
                    if (!uri.equals(patterns[k2])) continue;
                    found = true;
                    if (!collection[j].findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList();
                    }
                    results.add(constraints[i]);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns;
                if (collection[j].findMethodOmission(method) || (patterns = collection[j].findPatterns()) == null) continue;
                matched = false;
                int length = -1;
                for (k = 0; k < patterns.length; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (!pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                found = true;
                if (length > longest) {
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!collection[j].findMethod(method)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            boolean matched2 = false;
            int pos = -1;
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (collection[j].findMethodOmission(method) || patterns == null) continue;
                for (k = 0; k < patterns.length && !matched2; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf("/");
                    int dot = uri.lastIndexOf(".");
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched2 = true;
                    pos = j;
                }
            }
            if (!matched2) continue;
            found = true;
            if (!collection[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList<SecurityConstraint>();
            }
            results.add(constraints[i]);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                for (int k3 = 0; k3 < patterns.length && !matched; ++k3) {
                    String pattern2 = patterns[k3];
                    if (!pattern2.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (results == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList results) {
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        String[] roles;
        SecurityConstraint constraint;
        int i;
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getRequestPathMB().toString();
            String loginPage = config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to login page " + loginPage));
                }
                return true;
            }
            String errorPage = config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to error page " + errorPage));
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Allow access to username/password submission");
                }
                return true;
            }
        }
        Principal principal = request.getPrincipal();
        boolean status = false;
        boolean denyFromAll = false;
        for (i = 0; i < constraints.length; ++i) {
            constraint = constraints[i];
            roles = constraint.getAllRoles() ? request.getContext().findSecurityRoles() : constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (roles.length == 0 && !constraint.getAllRoles()) {
                if (constraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No roles ");
                    }
                    status = false;
                    denyFromAll = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all access");
                }
                status = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"  No user authenticated, cannot grant access");
                continue;
            }
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(principal, roles[j])) {
                    status = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Role found:  " + roles[j]));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + roles[j]));
            }
        }
        if (!denyFromAll && this.allRolesMode != AllRolesMode.STRICT_MODE && !status && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (i = 0; i < constraints.length; ++i) {
                constraint = constraints[i];
                if (!constraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Granting access for role-name=*, auth-only");
                    }
                    status = true;
                    break;
                }
                roles = request.getContext().findSecurityRoles();
                if (roles.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Granting access for role-name=*, strict auth-only");
                }
                status = true;
                break;
            }
        }
        if (!status) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return status;
    }

    @Override
    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        if (gp.getRealm() != this && log.isDebugEnabled()) {
            log.debug((Object)("Different realm " + this + " " + gp.getRealm()));
        }
        boolean result = gp.hasRole(role);
        if (log.isDebugEnabled()) {
            String name = principal.getName();
            if (result) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", name, role));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", name, role));
            }
        }
        return result;
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals("NONE")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder file = new StringBuilder();
        String protocol = "https";
        String host = request.getServerName();
        file.append(protocol).append("://").append(host);
        if (redirectPort != 443) {
            file.append(":").append(redirectPort);
        }
        file.append(request.getRequestURI());
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
            file.append(";");
            file.append(Globals.SESSION_PARAMETER_NAME);
            file.append("=");
            file.append(requestedSessionId);
        }
        if ((queryString = request.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + file.toString()));
        }
        response.sendRedirect(file.toString());
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("realmBase.alreadyStarted"));
            }
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", this.digest), e);
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("realmBase.notStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
        this.destroy();
    }

    public void destroy() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unregistering realm " + this.oname));
                }
            }
            catch (Exception ex) {
                log.error((Object)("Can't unregister realm " + this.oname), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                if (this.getDigestEncoding() == null) {
                    bytes = credentials.getBytes();
                } else {
                    try {
                        bytes = credentials.getBytes(this.getDigestEncoding());
                    }
                    catch (UnsupportedEncodingException uee) {
                        log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                        throw new IllegalArgumentException(uee.getMessage());
                    }
                }
                this.md.update(bytes);
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception e) {
                log.error((Object)sm.getString("realmBase.digest"), (Throwable)e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Couldn't get MD5 digest: ", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = digestValue.getBytes();
        } else {
            try {
                valueBytes = digestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        byte[] digest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            digest = md5Helper.digest(valueBytes);
        }
        return md5Encoder.encode(digest);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate usercert) {
        return this.getPrincipal(usercert.getSubjectDN().getName());
    }

    protected abstract Principal getPrincipal(String var1);

    protected Server getServer() {
        Service s;
        Container c = this.container;
        if (c instanceof Context) {
            c = c.getParent();
        }
        if (c instanceof Host) {
            c = c.getParent();
        }
        if (c instanceof Engine && (s = ((Engine)c).getService()) != null) {
            return s.getServer();
        }
        return null;
    }

    public static final String Digest(String credentials, String algorithm, String encoding) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (encoding == null) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.convert(md.digest());
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return credentials;
        }
    }

    public static void main(String[] args) {
        String encoding = null;
        int firstCredentialArg = 2;
        if (args.length > 4 && args[2].equalsIgnoreCase("-e")) {
            encoding = args[3];
            firstCredentialArg = 4;
        }
        if (args.length > firstCredentialArg && args[0].equalsIgnoreCase("-a")) {
            for (int i = firstCredentialArg; i < args.length; ++i) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.Digest(args[i], args[1], encoding));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> [-e <encoding>] <credentials>");
        }
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String theRealmPath) {
        this.realmPath = theRealmPath;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        this.host = name.getKeyProperty("host");
        this.path = name.getKeyProperty("path");
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void init() {
        this.containerLog = this.container.getLogger();
        if (this.initialized && this.container != null) {
            return;
        }
        this.initialized = true;
        if (this.container == null) {
            ObjectName parent = null;
            try {
                parent = this.host == null ? new ObjectName(this.domain + ":type=Engine") : (this.path == null ? new ObjectName(this.domain + ":type=Host,host=" + this.host) : new ObjectName(this.domain + ":j2eeType=WebModule,name=//" + this.host + this.path));
                if (this.mserver.isRegistered(parent)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Register with " + parent));
                    }
                    this.mserver.setAttribute(parent, new Attribute("realm", this));
                }
            }
            catch (Exception e) {
                log.error((Object)("Parent not available yet: " + parent));
            }
        }
        if (this.oname == null) {
            try {
                ContainerBase cb = (ContainerBase)this.container;
                this.oname = new ObjectName(cb.getDomain() + ":type=Realm" + this.getRealmSuffix() + cb.getContainerSuffix());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register Realm " + this.oname));
                }
            }
            catch (Throwable e) {
                log.error((Object)("Can't register " + this.oname), e);
            }
        }
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    static {
        sm = StringManager.getManager("org.apache.catalina.realm");
    }

    protected static class AllRolesMode {
        private String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String name) {
            AllRolesMode mode;
            if (name.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                mode = STRICT_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                mode = AUTH_ONLY_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                mode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return mode;
        }

        private AllRolesMode(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o instanceof AllRolesMode) {
                AllRolesMode mode = (AllRolesMode)o;
                equals = this.name.equals(mode.name);
            }
            return equals;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

