/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.catalina.deploy.WebOrdering;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;

public class OrderingResolver {
    protected static Logger log = Logger.getLogger(OrderingResolver.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static void resolveOrder(List<WebOrdering> webOrderings, List<String> order) {
        ArrayList<Ordering> work = new ArrayList<Ordering>();
        for (WebOrdering webOrdering : webOrderings) {
            Ordering ordering = new Ordering();
            ordering.ordering = webOrdering;
            ordering.afterOthers = webOrdering.isAfterOthers();
            ordering.beforeOthers = webOrdering.isBeforeOthers();
            if (ordering.afterOthers && ordering.beforeOthers) {
                throw new IllegalStateException(sm.getString("ordering.afterAndBeforeOthers", webOrdering.getJar()));
            }
            work.add(ordering);
        }
        for (Ordering ordering : work) {
            WebOrdering webOrdering = ordering.ordering;
            for (String name : webOrdering.getAfter()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException(sm.getString("ordering.duplicateName", webOrdering.getJar()));
                    }
                    ordering.addAfter(ordering2);
                    ordering2.addBefore(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(sm.getString("ordering.unkonwnName", webOrdering.getJar()));
            }
            for (String name : webOrdering.getBefore()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException(sm.getString("ordering.duplicateName", webOrdering.getJar()));
                    }
                    ordering.addBefore(ordering2);
                    ordering2.addAfter(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(sm.getString("ordering.unkonwnName", webOrdering.getJar()));
            }
        }
        Iterator workIterator = work.iterator();
        while (workIterator.hasNext()) {
            ((Ordering)workIterator.next()).validate();
        }
        ArrayList<Ordering> tempOrder = new ArrayList<Ordering>();
        for (Ordering ordering : work) {
            int pos;
            int i;
            int insertAfter;
            if (ordering.beforeOthers) {
                insertAfter = -1;
                boolean last = ordering.isLastBeforeOthers();
                int lastBeforeOthers = -1;
                for (i = 0; i < tempOrder.size(); ++i) {
                    if (ordering.isAfter((Ordering)tempOrder.get(i))) {
                        insertAfter = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).beforeOthers) continue;
                    lastBeforeOthers = i;
                }
                pos = insertAfter;
                if (last && lastBeforeOthers > insertAfter) {
                    pos = lastBeforeOthers;
                }
                tempOrder.add(pos + 1, ordering);
                continue;
            }
            if (ordering.afterOthers) {
                int insertBefore = tempOrder.size();
                boolean first = ordering.isFirstAfterOthers();
                int firstAfterOthers = tempOrder.size();
                for (i = tempOrder.size() - 1; i >= 0; --i) {
                    if (ordering.isBefore((Ordering)tempOrder.get(i))) {
                        insertBefore = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).afterOthers) continue;
                    firstAfterOthers = i;
                }
                pos = insertBefore;
                if (first && firstAfterOthers < insertBefore) {
                    pos = firstAfterOthers;
                }
                tempOrder.add(pos, ordering);
                continue;
            }
            insertAfter = -1;
            int insertBefore = tempOrder.size();
            for (int i2 = 0; i2 < tempOrder.size(); ++i2) {
                if (ordering.isAfter((Ordering)tempOrder.get(i2)) || ((Ordering)tempOrder.get((int)i2)).beforeOthers) {
                    insertAfter = i2;
                }
                if (!ordering.isBefore((Ordering)tempOrder.get(i2)) && !((Ordering)tempOrder.get((int)i2)).afterOthers) continue;
                insertBefore = i2;
            }
            if (insertAfter > insertBefore) {
                throw new IllegalStateException(sm.getString("ordering.orderConflict", ordering.ordering.getJar()));
            }
            tempOrder.add(insertAfter + 1, ordering);
        }
        for (Ordering ordering : tempOrder) {
            order.add(ordering.ordering.getJar());
        }
    }

    public static void main(String[] args) {
        ArrayList<String> order = new ArrayList<String>();
        ArrayList<WebOrdering> webOrderings = new ArrayList<WebOrdering>();
        OrderingResolver.resolveOrder(webOrderings, order);
        OrderingResolver.test1();
        OrderingResolver.test2();
        OrderingResolver.test3();
    }

    public static void test1() {
        ArrayList<String> order = new ArrayList<String>();
        ArrayList<WebOrdering> webOrderings = new ArrayList<WebOrdering>();
        WebOrdering A = new WebOrdering();
        A.setName("A");
        A.setJar("A.jar");
        A.setAfterOthers(true);
        A.addAfter("C");
        webOrderings.add(A);
        WebOrdering B = new WebOrdering();
        B.setName("B");
        B.setJar("B.jar");
        B.setBeforeOthers(true);
        webOrderings.add(B);
        WebOrdering C = new WebOrdering();
        C.setName("C");
        C.setJar("C.jar");
        C.setAfterOthers(true);
        webOrderings.add(C);
        WebOrdering D = new WebOrdering();
        D.setName("D");
        D.setJar("D.jar");
        webOrderings.add(D);
        WebOrdering E = new WebOrdering();
        E.setName("E");
        E.setJar("E.jar");
        webOrderings.add(E);
        WebOrdering F = new WebOrdering();
        F.setName("F");
        F.setJar("F.jar");
        F.setBeforeOthers(true);
        F.addBefore("B");
        webOrderings.add(F);
        long n1 = System.nanoTime();
        OrderingResolver.resolveOrder(webOrderings, order);
        long n2 = System.nanoTime();
        System.out.print("Result: ");
        Iterator<String> orderIterator = order.iterator();
        while (orderIterator.hasNext()) {
            System.out.print(orderIterator.next() + " ");
        }
        System.out.println("ns: " + (n2 - n1));
    }

    public static void test2() {
        ArrayList<String> order = new ArrayList<String>();
        ArrayList<WebOrdering> webOrderings = new ArrayList<WebOrdering>();
        WebOrdering A = new WebOrdering();
        A.setJar("noid.jar");
        A.setAfterOthers(true);
        A.addBefore("C");
        webOrderings.add(A);
        WebOrdering B = new WebOrdering();
        B.setName("B");
        B.setJar("B.jar");
        B.setBeforeOthers(true);
        webOrderings.add(B);
        WebOrdering C = new WebOrdering();
        C.setName("C");
        C.setJar("C.jar");
        webOrderings.add(C);
        WebOrdering D = new WebOrdering();
        D.setName("D");
        D.setJar("D.jar");
        D.setAfterOthers(true);
        webOrderings.add(D);
        WebOrdering E = new WebOrdering();
        E.setName("E");
        E.setJar("E.jar");
        E.setBeforeOthers(true);
        webOrderings.add(E);
        WebOrdering F = new WebOrdering();
        F.setName("F");
        F.setJar("F.jar");
        webOrderings.add(F);
        long n1 = System.nanoTime();
        OrderingResolver.resolveOrder(webOrderings, order);
        long n2 = System.nanoTime();
        System.out.print("Result: ");
        Iterator<String> orderIterator = order.iterator();
        while (orderIterator.hasNext()) {
            System.out.print(orderIterator.next() + " ");
        }
        System.out.println("ns: " + (n2 - n1));
    }

    public static void test3() {
        ArrayList<String> order = new ArrayList<String>();
        ArrayList<WebOrdering> webOrderings = new ArrayList<WebOrdering>();
        WebOrdering A = new WebOrdering();
        A.setName("A");
        A.setJar("A.jar");
        A.addAfter("B");
        webOrderings.add(A);
        WebOrdering B = new WebOrdering();
        B.setName("B");
        B.setJar("B.jar");
        webOrderings.add(B);
        WebOrdering C = new WebOrdering();
        C.setName("C");
        C.setJar("C.jar");
        C.setBeforeOthers(true);
        webOrderings.add(C);
        WebOrdering D = new WebOrdering();
        D.setName("D");
        D.setJar("D.jar");
        webOrderings.add(D);
        long n1 = System.nanoTime();
        OrderingResolver.resolveOrder(webOrderings, order);
        long n2 = System.nanoTime();
        System.out.print("Result: ");
        Iterator<String> orderIterator = order.iterator();
        while (orderIterator.hasNext()) {
            System.out.print(orderIterator.next() + " ");
        }
        System.out.println("ns: " + (n2 - n1));
    }

    protected static class Ordering {
        protected WebOrdering ordering;
        protected Set<Ordering> after = new HashSet<Ordering>();
        protected Set<Ordering> before = new HashSet<Ordering>();
        protected boolean afterOthers = false;
        protected boolean beforeOthers = false;

        protected Ordering() {
        }

        public boolean addAfter(Ordering ordering) {
            return this.after.add(ordering);
        }

        public boolean addBefore(Ordering ordering) {
            return this.before.add(ordering);
        }

        public void validate() {
            this.isBefore(new Ordering());
            this.isAfter(new Ordering());
        }

        public boolean isBefore(Ordering ordering) {
            return this.isBeforeInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isBeforeInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.before.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.before) {
                if (checked.contains(check)) {
                    throw new IllegalStateException(sm.getString("ordering.orderConflict", this.ordering.getJar()));
                }
                if (!check.isBeforeInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isAfter(Ordering ordering) {
            return this.isAfterInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isAfterInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.after.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.after) {
                if (checked.contains(check)) {
                    throw new IllegalStateException(sm.getString("ordering.orderConflict", this.ordering.getJar()));
                }
                if (!check.isAfterInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isLastBeforeOthers() {
            if (!this.beforeOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.before) {
                if (!check.beforeOthers) {
                    return true;
                }
                if (!check.isLastBeforeOthers()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirstAfterOthers() {
            if (!this.afterOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.after) {
                if (!check.afterOthers) {
                    return true;
                }
                if (!check.isFirstAfterOthers()) continue;
                return true;
            }
            return false;
        }
    }
}

